/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.base;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.pm.PermissionInfo;
import android.os.Handler;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.SparseArray;
import android.view.View;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.chromium.base.ApplicationStatus;
import org.chromium.base.BuildInfo;
import org.chromium.ui.UiUtils;
import org.chromium.ui.base.WindowAndroid;

public class ActivityWindowAndroid
extends WindowAndroid
implements ApplicationStatus.ActivityStateListener,
View.OnLayoutChangeListener {
    private static final int REQUEST_CODE_PREFIX = 1000;
    private static final int REQUEST_CODE_RANGE_SIZE = 100;
    private static final String TAG = "ActivityWindowAndroid";
    private static final String PERMISSION_QUERIED_KEY_PREFIX = "HasRequestedAndroidPermission::";
    private final WeakReference<Activity> mActivityRef;
    private final Handler mHandler;
    private final SparseArray<WindowAndroid.PermissionCallback> mOutstandingPermissionRequests;
    private Method mRequestPermissionsMethod;
    private int mNextRequestCode = 0;

    public ActivityWindowAndroid(Activity activity) {
        this(activity, true);
    }

    public ActivityWindowAndroid(Activity activity, boolean listenToActivityState) {
        super(activity.getApplicationContext());
        this.mActivityRef = new WeakReference<Activity>(activity);
        this.mHandler = new Handler();
        this.mOutstandingPermissionRequests = new SparseArray();
        if (listenToActivityState) {
            ApplicationStatus.registerStateListenerForActivity(this, activity);
        }
    }

    @Override
    protected void registerKeyboardVisibilityCallbacks() {
        Activity activity = (Activity)this.mActivityRef.get();
        if (activity == null) {
            return;
        }
        activity.findViewById(0x1020002).addOnLayoutChangeListener((View.OnLayoutChangeListener)this);
    }

    @Override
    protected void unregisterKeyboardVisibilityCallbacks() {
        Activity activity = (Activity)this.mActivityRef.get();
        if (activity == null) {
            return;
        }
        activity.findViewById(0x1020002).removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
    }

    @Override
    public int showCancelableIntent(PendingIntent intent, WindowAndroid.IntentCallback callback, Integer errorId) {
        Activity activity = (Activity)this.mActivityRef.get();
        if (activity == null) {
            return -1;
        }
        int requestCode = this.generateNextRequestCode();
        try {
            activity.startIntentSenderForResult(intent.getIntentSender(), requestCode, new Intent(), 0, 0, 0);
        }
        catch (IntentSender.SendIntentException e) {
            return -1;
        }
        this.storeCallbackData(requestCode, callback, errorId);
        return requestCode;
    }

    @Override
    public int showCancelableIntent(Intent intent, WindowAndroid.IntentCallback callback, Integer errorId) {
        Activity activity = (Activity)this.mActivityRef.get();
        if (activity == null) {
            return -1;
        }
        int requestCode = this.generateNextRequestCode();
        try {
            activity.startActivityForResult(intent, requestCode);
        }
        catch (ActivityNotFoundException e) {
            return -1;
        }
        this.storeCallbackData(requestCode, callback, errorId);
        return requestCode;
    }

    @Override
    public void cancelIntent(int requestCode) {
        Activity activity = (Activity)this.mActivityRef.get();
        if (activity == null) {
            return;
        }
        activity.finishActivity(requestCode);
    }

    public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        WindowAndroid.IntentCallback callback = (WindowAndroid.IntentCallback)this.mOutstandingIntents.get(requestCode);
        this.mOutstandingIntents.delete(requestCode);
        String errorMessage = (String)this.mIntentErrors.remove(requestCode);
        if (callback != null) {
            callback.onIntentCompleted(this, resultCode, this.mApplicationContext.getContentResolver(), data);
            return true;
        }
        if (errorMessage != null) {
            this.showCallbackNonExistentError(errorMessage);
            return true;
        }
        return false;
    }

    private String getHasRequestedPermissionKey(String permission) {
        String permissionQueriedKey = permission;
        try {
            PermissionInfo permissionInfo = this.getApplicationContext().getPackageManager().getPermissionInfo(permission, 128);
            if (!TextUtils.isEmpty((CharSequence)permissionInfo.group)) {
                permissionQueriedKey = permissionInfo.group;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return PERMISSION_QUERIED_KEY_PREFIX + permissionQueriedKey;
    }

    @Override
    public boolean canRequestPermission(String permission) {
        if (!BuildInfo.isMncOrLater()) {
            return false;
        }
        Activity activity = (Activity)this.mActivityRef.get();
        if (activity == null) {
            return false;
        }
        String permissionQueriedKey = this.getHasRequestedPermissionKey(permission);
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)activity);
        return !prefs.getBoolean(permissionQueriedKey, false);
    }

    @Override
    public void requestPermissions(final String[] permissions, final WindowAndroid.PermissionCallback callback) {
        if (!this.requestPermissionsInternal(permissions, callback)) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    int[] results = new int[permissions.length];
                    for (int i = 0; i < permissions.length; ++i) {
                        results[i] = ActivityWindowAndroid.this.hasPermission(permissions[i]) ? 0 : -1;
                    }
                    callback.onRequestPermissionsResult(permissions, results);
                }
            });
        } else {
            Activity activity = (Activity)this.mActivityRef.get();
            SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences((Context)activity).edit();
            for (int i = 0; i < permissions.length; ++i) {
                editor.putBoolean(this.getHasRequestedPermissionKey(permissions[i]), true);
            }
            editor.apply();
        }
    }

    private boolean requestPermissionsInternal(String[] permissions, WindowAndroid.PermissionCallback callback) {
        if (!BuildInfo.isMncOrLater()) {
            return false;
        }
        Activity activity = (Activity)this.mActivityRef.get();
        if (activity == null) {
            return false;
        }
        if (this.mRequestPermissionsMethod == null) {
            try {
                this.mRequestPermissionsMethod = Activity.class.getMethod("requestPermissions", String[].class, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }
        int requestCode = this.generateNextRequestCode();
        this.mOutstandingPermissionRequests.put(requestCode, (Object)callback);
        try {
            this.mRequestPermissionsMethod.invoke((Object)activity, permissions, requestCode);
            return true;
        }
        catch (IllegalAccessException e) {
            this.mOutstandingPermissionRequests.delete(requestCode);
        }
        catch (IllegalArgumentException e) {
            this.mOutstandingPermissionRequests.delete(requestCode);
        }
        catch (InvocationTargetException e) {
            this.mOutstandingPermissionRequests.delete(requestCode);
        }
        return false;
    }

    public boolean onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        WindowAndroid.PermissionCallback callback = (WindowAndroid.PermissionCallback)this.mOutstandingPermissionRequests.get(requestCode);
        this.mOutstandingPermissionRequests.delete(requestCode);
        if (callback == null) {
            return false;
        }
        callback.onRequestPermissionsResult(permissions, grantResults);
        return true;
    }

    @Override
    public WeakReference<Activity> getActivity() {
        return new WeakReference<Activity>((Activity)this.mActivityRef.get());
    }

    @Override
    public void onActivityStateChange(Activity activity, int newState) {
        if (newState == 5) {
            this.onActivityStopped();
        } else if (newState == 2) {
            this.onActivityStarted();
        }
    }

    public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        this.keyboardVisibilityPossiblyChanged(UiUtils.isKeyboardShowing((Context)this.mActivityRef.get(), v));
    }

    private int generateNextRequestCode() {
        int requestCode = 1000 + this.mNextRequestCode;
        this.mNextRequestCode = (this.mNextRequestCode + 1) % 100;
        return requestCode;
    }

    private void storeCallbackData(int requestCode, WindowAndroid.IntentCallback callback, Integer errorId) {
        this.mOutstandingIntents.put(requestCode, (Object)callback);
        this.mIntentErrors.put(requestCode, errorId == null ? null : this.mApplicationContext.getString(errorId.intValue()));
    }
}

