/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.base;

import android.content.res.Configuration;
import java.util.Locale;
import org.chromium.base.ApiCompatibilityUtils;
import org.chromium.base.ApplicationStatus;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;

@JNINamespace(value="l10n_util")
public class LocalizationUtils {
    public static final int UNKNOWN_DIRECTION = 0;
    public static final int RIGHT_TO_LEFT = 1;
    public static final int LEFT_TO_RIGHT = 2;
    private static Boolean sIsLayoutRtl;

    private LocalizationUtils() {
    }

    @CalledByNative
    private static Locale getJavaLocale(String language, String country, String variant) {
        return new Locale(language, country, variant);
    }

    @CalledByNative
    private static String getDisplayNameForLocale(Locale locale, Locale displayLocale) {
        return locale.getDisplayName(displayLocale);
    }

    @CalledByNative
    public static boolean isLayoutRtl() {
        if (sIsLayoutRtl == null) {
            Configuration configuration = ApplicationStatus.getApplicationContext().getResources().getConfiguration();
            sIsLayoutRtl = ApiCompatibilityUtils.getLayoutDirection(configuration) == 1;
        }
        return sIsLayoutRtl;
    }

    public static int getFirstStrongCharacterDirection(String string2) {
        return LocalizationUtils.nativeGetFirstStrongCharacterDirection(string2);
    }

    public static String getDurationString(long timeInMillis) {
        return LocalizationUtils.nativeGetDurationString(timeInMillis);
    }

    private static native int nativeGetFirstStrongCharacterDirection(String var0);

    private static native String nativeGetDurationString(long var0);
}

