/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.base;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Process;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityManager;
import android.widget.Toast;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.ui.VSyncMonitor;

@JNINamespace(value="ui")
public class WindowAndroid {
    private static final String TAG = "WindowAndroid";
    private long mNativeWindowAndroid = 0L;
    private final VSyncMonitor mVSyncMonitor;
    static final String WINDOW_CALLBACK_ERRORS = "window_callback_errors";
    public static final int START_INTENT_FAILURE = -1;
    protected Context mApplicationContext;
    protected SparseArray<IntentCallback> mOutstandingIntents;
    protected HashMap<Integer, String> mIntentErrors;
    private HashSet<Animator> mAnimationsOverContent = new HashSet();
    private View mAnimationPlaceholderView;
    private ViewGroup mKeyboardAccessoryView;
    private boolean mIsKeyboardShowing = false;
    private final AccessibilityManager mAccessibilityManager;
    private boolean mIsTouchExplorationEnabled;
    private TouchExplorationMonitor mTouchExplorationMonitor;
    private LinkedList<KeyboardVisibilityListener> mKeyboardVisibilityListeners = new LinkedList();
    private final VSyncMonitor.Listener mVSyncListener = new VSyncMonitor.Listener(){

        @Override
        public void onVSync(VSyncMonitor monitor, long vsyncTimeMicros) {
            if (WindowAndroid.this.mNativeWindowAndroid != 0L) {
                WindowAndroid.this.nativeOnVSync(WindowAndroid.this.mNativeWindowAndroid, vsyncTimeMicros, WindowAndroid.this.mVSyncMonitor.getVSyncPeriodInMicroseconds());
            }
        }
    };

    public boolean isInsideVSync() {
        return this.mVSyncMonitor.isInsideVSync();
    }

    @SuppressLint(value={"UseSparseArrays"})
    public WindowAndroid(Context context) {
        assert (context == context.getApplicationContext());
        this.mApplicationContext = context;
        this.mOutstandingIntents = new SparseArray();
        this.mIntentErrors = new HashMap();
        this.mVSyncMonitor = new VSyncMonitor(context, this.mVSyncListener);
        this.mAccessibilityManager = (AccessibilityManager)context.getSystemService("accessibility");
    }

    public boolean showIntent(PendingIntent intent, IntentCallback callback, Integer errorId) {
        return this.showCancelableIntent(intent, callback, errorId) >= 0;
    }

    public boolean showIntent(Intent intent, IntentCallback callback, Integer errorId) {
        return this.showCancelableIntent(intent, callback, errorId) >= 0;
    }

    public int showCancelableIntent(PendingIntent intent, IntentCallback callback, Integer errorId) {
        Log.d((String)TAG, (String)("Can't show intent as context is not an Activity: " + intent));
        return -1;
    }

    public int showCancelableIntent(Intent intent, IntentCallback callback, Integer errorId) {
        Log.d((String)TAG, (String)("Can't show intent as context is not an Activity: " + intent));
        return -1;
    }

    public void cancelIntent(int requestCode) {
        Log.d((String)TAG, (String)("Can't cancel intent as context is not an Activity: " + requestCode));
    }

    public boolean removeIntentCallback(IntentCallback callback) {
        int requestCode = this.mOutstandingIntents.indexOfValue((Object)callback);
        if (requestCode < 0) {
            return false;
        }
        this.mOutstandingIntents.remove(requestCode);
        this.mIntentErrors.remove(requestCode);
        return true;
    }

    @CalledByNative
    public boolean hasPermission(String permission) {
        return this.mApplicationContext.checkPermission(permission, Process.myPid(), Process.myUid()) == 0;
    }

    @CalledByNative
    public boolean canRequestPermission(String permission) {
        Log.w((String)TAG, (String)"Cannot determine the request permission state as the context is not an Activity");
        assert (false) : "Failed to determine the request permission state using a WindowAndroid without an Activity";
        return false;
    }

    public void requestPermissions(String[] permissions, PermissionCallback callback) {
        Log.w((String)TAG, (String)"Cannot request permissions as the context is not an Activity");
        assert (false) : "Failed to request permissions using a WindowAndroid without an Activity";
    }

    public boolean hasFileAccess() {
        return true;
    }

    public void requestFileAccess(final FileAccessCallback callback) {
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                callback.onFileAccessResult(false);
            }
        });
    }

    public void showError(String error) {
        if (error != null) {
            Toast.makeText((Context)this.mApplicationContext, (CharSequence)error, (int)0).show();
        }
    }

    public void showError(int resId) {
        this.showError(this.mApplicationContext.getString(resId));
    }

    protected void showCallbackNonExistentError(String error) {
        this.showError(error);
    }

    public void sendBroadcast(Intent intent) {
        this.mApplicationContext.sendBroadcast(intent);
    }

    public WeakReference<Activity> getActivity() {
        return new WeakReference<Object>(null);
    }

    public Context getApplicationContext() {
        return this.mApplicationContext;
    }

    public void saveInstanceState(Bundle bundle) {
        bundle.putSerializable(WINDOW_CALLBACK_ERRORS, this.mIntentErrors);
    }

    public void restoreInstanceState(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        Serializable errors = bundle.getSerializable(WINDOW_CALLBACK_ERRORS);
        if (errors instanceof HashMap) {
            HashMap intentErrors;
            this.mIntentErrors = intentErrors = (HashMap)errors;
        }
    }

    public void onVisibilityChanged(boolean visible) {
        if (this.mNativeWindowAndroid == 0L) {
            return;
        }
        this.nativeOnVisibilityChanged(this.mNativeWindowAndroid, visible);
    }

    protected void onActivityStopped() {
        if (this.mNativeWindowAndroid == 0L) {
            return;
        }
        this.nativeOnActivityStopped(this.mNativeWindowAndroid);
    }

    protected void onActivityStarted() {
        if (this.mNativeWindowAndroid == 0L) {
            return;
        }
        this.nativeOnActivityStarted(this.mNativeWindowAndroid);
    }

    @CalledByNative
    private void requestVSyncUpdate() {
        this.mVSyncMonitor.requestUpdate();
    }

    public boolean canResolveActivity(Intent intent) {
        return this.mApplicationContext.getPackageManager().resolveActivity(intent, 0) != null;
    }

    public void destroy() {
        if (this.mNativeWindowAndroid != 0L) {
            this.nativeDestroy(this.mNativeWindowAndroid);
            this.mNativeWindowAndroid = 0L;
        }
        if (Build.VERSION.SDK_INT >= 19 && this.mTouchExplorationMonitor != null) {
            this.mTouchExplorationMonitor.destroy();
        }
    }

    public long getNativePointer() {
        if (this.mNativeWindowAndroid == 0L) {
            this.mNativeWindowAndroid = this.nativeInit();
        }
        return this.mNativeWindowAndroid;
    }

    public void setAnimationPlaceholderView(View view) {
        this.mAnimationPlaceholderView = view;
        this.mIsTouchExplorationEnabled = this.mAccessibilityManager.isTouchExplorationEnabled();
        this.refreshWillNotDraw();
        if (Build.VERSION.SDK_INT >= 19) {
            this.mTouchExplorationMonitor = new TouchExplorationMonitor();
        }
    }

    public void setKeyboardAccessoryView(ViewGroup view) {
        this.mKeyboardAccessoryView = view;
    }

    public ViewGroup getKeyboardAccessoryView() {
        return this.mKeyboardAccessoryView;
    }

    protected void registerKeyboardVisibilityCallbacks() {
    }

    protected void unregisterKeyboardVisibilityCallbacks() {
    }

    public void addKeyboardVisibilityListener(KeyboardVisibilityListener listener) {
        if (this.mKeyboardVisibilityListeners.isEmpty()) {
            this.registerKeyboardVisibilityCallbacks();
        }
        this.mKeyboardVisibilityListeners.add(listener);
    }

    public void removeKeyboardVisibilityListener(KeyboardVisibilityListener listener) {
        this.mKeyboardVisibilityListeners.remove(listener);
        if (this.mKeyboardVisibilityListeners.isEmpty()) {
            this.unregisterKeyboardVisibilityCallbacks();
        }
    }

    protected void keyboardVisibilityPossiblyChanged(boolean isShowing) {
        if (this.mIsKeyboardShowing == isShowing) {
            return;
        }
        this.mIsKeyboardShowing = isShowing;
        LinkedList<KeyboardVisibilityListener> listeners = new LinkedList<KeyboardVisibilityListener>(this.mKeyboardVisibilityListeners);
        for (KeyboardVisibilityListener listener : listeners) {
            listener.keyboardVisibilityChanged(isShowing);
        }
    }

    public void startAnimationOverContent(Animator animation) {
        if (this.mAnimationPlaceholderView == null) {
            return;
        }
        if (animation.isStarted()) {
            throw new IllegalArgumentException("Already started.");
        }
        boolean added = this.mAnimationsOverContent.add(animation);
        if (!added) {
            throw new IllegalArgumentException("Already Added.");
        }
        animation.start();
        this.refreshWillNotDraw();
        animation.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                animation.removeListener((Animator.AnimatorListener)this);
                WindowAndroid.this.mAnimationsOverContent.remove(animation);
                WindowAndroid.this.refreshWillNotDraw();
            }
        });
    }

    private void refreshWillNotDraw() {
        boolean willNotDraw;
        boolean bl = willNotDraw = !this.mIsTouchExplorationEnabled && this.mAnimationsOverContent.isEmpty();
        if (this.mAnimationPlaceholderView.willNotDraw() != willNotDraw) {
            this.mAnimationPlaceholderView.setWillNotDraw(willNotDraw);
        }
    }

    private native long nativeInit();

    private native void nativeOnVSync(long var1, long var3, long var5);

    private native void nativeOnVisibilityChanged(long var1, boolean var3);

    private native void nativeOnActivityStopped(long var1);

    private native void nativeOnActivityStarted(long var1);

    private native void nativeDestroy(long var1);

    public static interface FileAccessCallback {
        public void onFileAccessResult(boolean var1);
    }

    public static interface PermissionCallback {
        public void onRequestPermissionsResult(String[] var1, int[] var2);
    }

    public static interface IntentCallback {
        public void onIntentCompleted(WindowAndroid var1, int var2, ContentResolver var3, Intent var4);
    }

    public static interface KeyboardVisibilityListener {
        public void keyboardVisibilityChanged(boolean var1);
    }

    @TargetApi(value=19)
    private class TouchExplorationMonitor {
        private AccessibilityManager.TouchExplorationStateChangeListener mTouchExplorationListener;

        TouchExplorationMonitor() {
            this.mTouchExplorationListener = new AccessibilityManager.TouchExplorationStateChangeListener(){

                public void onTouchExplorationStateChanged(boolean enabled) {
                    WindowAndroid.this.mIsTouchExplorationEnabled = WindowAndroid.this.mAccessibilityManager.isTouchExplorationEnabled();
                    WindowAndroid.this.refreshWillNotDraw();
                }
            };
            WindowAndroid.this.mAccessibilityManager.addTouchExplorationStateChangeListener(this.mTouchExplorationListener);
        }

        void destroy() {
            WindowAndroid.this.mAccessibilityManager.removeTouchExplorationStateChangeListener(this.mTouchExplorationListener);
        }
    }
}

