/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.gfx;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.PixelFormat;
import android.graphics.Point;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;

@JNINamespace(value="gfx")
public class DeviceDisplayInfo {
    private final Context mAppContext;
    private final WindowManager mWinManager;
    private Point mTempPoint = new Point();
    private DisplayMetrics mTempMetrics = new DisplayMetrics();

    private DeviceDisplayInfo(Context context) {
        this.mAppContext = context.getApplicationContext();
        this.mWinManager = (WindowManager)this.mAppContext.getSystemService("window");
    }

    @CalledByNative
    public int getDisplayHeight() {
        this.getDisplay().getSize(this.mTempPoint);
        return this.mTempPoint.y;
    }

    @CalledByNative
    public int getDisplayWidth() {
        this.getDisplay().getSize(this.mTempPoint);
        return this.mTempPoint.x;
    }

    @TargetApi(value=17)
    @CalledByNative
    public int getPhysicalDisplayHeight() {
        if (Build.VERSION.SDK_INT < 17) {
            return 0;
        }
        this.getDisplay().getRealSize(this.mTempPoint);
        return this.mTempPoint.y;
    }

    @TargetApi(value=17)
    @CalledByNative
    public int getPhysicalDisplayWidth() {
        if (Build.VERSION.SDK_INT < 17) {
            return 0;
        }
        this.getDisplay().getRealSize(this.mTempPoint);
        return this.mTempPoint.x;
    }

    private int getPixelFormat() {
        if (Build.VERSION.SDK_INT < 17) {
            return this.getDisplay().getPixelFormat();
        }
        return 1;
    }

    @CalledByNative
    public int getBitsPerPixel() {
        int format = this.getPixelFormat();
        PixelFormat info = new PixelFormat();
        PixelFormat.getPixelFormatInfo((int)format, (PixelFormat)info);
        return info.bitsPerPixel;
    }

    @CalledByNative
    public int getBitsPerComponent() {
        int format = this.getPixelFormat();
        switch (format) {
            case 7: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 1: 
            case 2: 
            case 3: {
                return 8;
            }
            case 11: {
                return 2;
            }
            case 4: {
                return 5;
            }
            case 8: 
            case 9: 
            case 10: {
                return 0;
            }
        }
        return 8;
    }

    @CalledByNative
    public double getDIPScale() {
        this.getDisplay().getMetrics(this.mTempMetrics);
        return this.mTempMetrics.density;
    }

    @CalledByNative
    private int getSmallestDIPWidth() {
        return this.mAppContext.getResources().getConfiguration().smallestScreenWidthDp;
    }

    @CalledByNative
    public int getRotationDegrees() {
        switch (this.getDisplay().getRotation()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        assert (false);
        return 0;
    }

    public void updateNativeSharedDisplayInfo() {
        this.nativeUpdateSharedDeviceDisplayInfo(this.getDisplayHeight(), this.getDisplayWidth(), this.getPhysicalDisplayHeight(), this.getPhysicalDisplayWidth(), this.getBitsPerPixel(), this.getBitsPerComponent(), this.getDIPScale(), this.getSmallestDIPWidth(), this.getRotationDegrees());
    }

    private Display getDisplay() {
        return this.mWinManager.getDefaultDisplay();
    }

    @CalledByNative
    public static DeviceDisplayInfo create(Context context) {
        return new DeviceDisplayInfo(context);
    }

    private native void nativeUpdateSharedDeviceDisplayInfo(int var1, int var2, int var3, int var4, int var5, int var6, double var7, int var9, int var10);
}

