/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.gfx;

import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.ViewConfiguration;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.ui.R;

@JNINamespace(value="gfx")
public class ViewConfigurationHelper {
    private static final float MIN_SCALING_SPAN_MM = 27.0f;
    private static final float MIN_SCALING_TOUCH_MAJOR_DIP = 48.0f;
    private final Context mAppContext;
    private ViewConfiguration mViewConfiguration;
    private float mDensity;

    private ViewConfigurationHelper(Context context) {
        this.mAppContext = context.getApplicationContext();
        this.mViewConfiguration = ViewConfiguration.get((Context)this.mAppContext);
        this.mDensity = this.mAppContext.getResources().getDisplayMetrics().density;
        assert (this.mDensity > 0.0f);
    }

    private void registerListener() {
        this.mAppContext.registerComponentCallbacks(new ComponentCallbacks(){

            public void onConfigurationChanged(Configuration configuration) {
                ViewConfigurationHelper.this.updateNativeViewConfigurationIfNecessary();
            }

            public void onLowMemory() {
            }
        });
    }

    private void updateNativeViewConfigurationIfNecessary() {
        ViewConfiguration configuration = ViewConfiguration.get((Context)this.mAppContext);
        if (this.mViewConfiguration == configuration) {
            assert (this.mDensity == this.mAppContext.getResources().getDisplayMetrics().density);
            return;
        }
        this.mViewConfiguration = configuration;
        this.mDensity = this.mAppContext.getResources().getDisplayMetrics().density;
        assert (this.mDensity > 0.0f);
        this.nativeUpdateSharedViewConfiguration(this.getMaximumFlingVelocity(), this.getMinimumFlingVelocity(), this.getTouchSlop(), this.getDoubleTapSlop(), this.getMinScalingSpan(), this.getMinScalingTouchMajor());
    }

    @CalledByNative
    private static int getDoubleTapTimeout() {
        return ViewConfiguration.getDoubleTapTimeout();
    }

    @CalledByNative
    private static int getLongPressTimeout() {
        return ViewConfiguration.getLongPressTimeout();
    }

    @CalledByNative
    private static int getTapTimeout() {
        return ViewConfiguration.getTapTimeout();
    }

    @CalledByNative
    private static float getScrollFriction() {
        return ViewConfiguration.getScrollFriction();
    }

    @CalledByNative
    private float getMaximumFlingVelocity() {
        return this.toDips(this.mViewConfiguration.getScaledMaximumFlingVelocity());
    }

    @CalledByNative
    private float getMinimumFlingVelocity() {
        return this.toDips(this.mViewConfiguration.getScaledMinimumFlingVelocity());
    }

    @CalledByNative
    private float getTouchSlop() {
        return this.toDips(this.mViewConfiguration.getScaledTouchSlop());
    }

    @CalledByNative
    private float getDoubleTapSlop() {
        return this.toDips(this.mViewConfiguration.getScaledDoubleTapSlop());
    }

    @CalledByNative
    private float getMinScalingSpan() {
        return this.toDips(this.getScaledMinScalingSpan());
    }

    @CalledByNative
    private float getMinScalingTouchMajor() {
        return this.toDips(this.getScaledMinScalingTouchMajor());
    }

    private int getScaledMinScalingSpan() {
        Resources res = this.mAppContext.getResources();
        int id2 = res.getIdentifier("config_minScalingSpan", "dimen", "android");
        if (id2 == 0) {
            id2 = R.dimen.config_min_scaling_span;
        }
        try {
            return res.getDimensionPixelSize(id2);
        }
        catch (Resources.NotFoundException e) {
            assert (false) : "MinScalingSpan resource lookup failed.";
            return (int)TypedValue.applyDimension((int)5, (float)27.0f, (DisplayMetrics)res.getDisplayMetrics());
        }
    }

    private int getScaledMinScalingTouchMajor() {
        Resources res = this.mAppContext.getResources();
        int id2 = res.getIdentifier("config_minScalingTouchMajor", "dimen", "android");
        if (id2 == 0) {
            id2 = R.dimen.config_min_scaling_touch_major;
        }
        try {
            return res.getDimensionPixelSize(id2);
        }
        catch (Resources.NotFoundException e) {
            assert (false) : "MinScalingTouchMajor resource lookup failed.";
            return (int)TypedValue.applyDimension((int)1, (float)48.0f, (DisplayMetrics)res.getDisplayMetrics());
        }
    }

    private float toDips(int pixels) {
        return (float)pixels / this.mDensity;
    }

    @CalledByNative
    private static ViewConfigurationHelper createWithListener(Context context) {
        ViewConfigurationHelper viewConfigurationHelper = new ViewConfigurationHelper(context);
        viewConfigurationHelper.registerListener();
        return viewConfigurationHelper;
    }

    private native void nativeUpdateSharedViewConfiguration(float var1, float var2, float var3, float var4, float var5, float var6);
}

