/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.picker;

import android.app.AlertDialog;
import android.app.DatePickerDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.text.format.DateFormat;
import android.view.View;
import android.widget.AdapterView;
import android.widget.DatePicker;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TimePicker;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.chromium.ui.R;
import org.chromium.ui.picker.ChromeDatePickerDialog;
import org.chromium.ui.picker.DateDialogNormalizer;
import org.chromium.ui.picker.DateTimePickerDialog;
import org.chromium.ui.picker.DateTimeSuggestion;
import org.chromium.ui.picker.DateTimeSuggestionListAdapter;
import org.chromium.ui.picker.MonthPicker;
import org.chromium.ui.picker.MonthPickerDialog;
import org.chromium.ui.picker.MultiFieldTimePickerDialog;
import org.chromium.ui.picker.TwoFieldDatePickerDialog;
import org.chromium.ui.picker.WeekPicker;
import org.chromium.ui.picker.WeekPickerDialog;

public class InputDialogContainer {
    private final Context mContext;
    private boolean mDialogAlreadyDismissed;
    private AlertDialog mDialog;
    private final InputActionDelegate mInputActionDelegate;

    public static boolean isDialogInputType(int type) {
        return type == 8 || type == 12 || type == 9 || type == 10 || type == 11 || type == 13;
    }

    public InputDialogContainer(Context context, InputActionDelegate inputActionDelegate) {
        this.mContext = context;
        this.mInputActionDelegate = inputActionDelegate;
    }

    public void showPickerDialog(int dialogType, double dialogValue, double min, double max, double step) {
        Calendar cal;
        if (Double.isNaN(dialogValue)) {
            cal = Calendar.getInstance();
            cal.set(14, 0);
        } else if (dialogType == 11) {
            cal = MonthPicker.createDateFromValue(dialogValue);
        } else if (dialogType == 13) {
            cal = WeekPicker.createDateFromValue(dialogValue);
        } else {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            gregorianCalendar.setGregorianChange(new Date(Long.MIN_VALUE));
            gregorianCalendar.setTimeInMillis((long)dialogValue);
            cal = gregorianCalendar;
        }
        if (dialogType == 8) {
            this.showPickerDialog(dialogType, cal.get(1), cal.get(2), cal.get(5), 0, 0, 0, 0, 0, min, max, step);
        } else if (dialogType == 12) {
            this.showPickerDialog(dialogType, 0, 0, 0, cal.get(11), cal.get(12), 0, 0, 0, min, max, step);
        } else if (dialogType == 9 || dialogType == 10) {
            this.showPickerDialog(dialogType, cal.get(1), cal.get(2), cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14), 0, min, max, step);
        } else if (dialogType == 11) {
            this.showPickerDialog(dialogType, cal.get(1), cal.get(2), 0, 0, 0, 0, 0, 0, min, max, step);
        } else if (dialogType == 13) {
            int year = WeekPicker.getISOWeekYearForDate(cal);
            int week = WeekPicker.getWeekForDate(cal);
            this.showPickerDialog(dialogType, year, 0, 0, 0, 0, 0, 0, week, min, max, step);
        }
    }

    void showSuggestionDialog(final int dialogType, final double dialogValue, final double min, final double max, final double step, DateTimeSuggestion[] suggestions) {
        ListView suggestionListView = new ListView(this.mContext);
        final DateTimeSuggestionListAdapter adapter = new DateTimeSuggestionListAdapter(this.mContext, Arrays.asList(suggestions));
        suggestionListView.setAdapter((ListAdapter)adapter);
        suggestionListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (position == adapter.getCount() - 1) {
                    InputDialogContainer.this.dismissDialog();
                    InputDialogContainer.this.showPickerDialog(dialogType, dialogValue, min, max, step);
                } else {
                    double suggestionValue = ((DateTimeSuggestion)adapter.getItem(position)).value();
                    InputDialogContainer.this.mInputActionDelegate.replaceDateTime(suggestionValue);
                    InputDialogContainer.this.dismissDialog();
                    InputDialogContainer.this.mDialogAlreadyDismissed = true;
                }
            }
        });
        int dialogTitleId = R.string.date_picker_dialog_title;
        if (dialogType == 12) {
            dialogTitleId = R.string.time_picker_dialog_title;
        } else if (dialogType == 9 || dialogType == 10) {
            dialogTitleId = R.string.date_time_picker_dialog_title;
        } else if (dialogType == 11) {
            dialogTitleId = R.string.month_picker_dialog_title;
        } else if (dialogType == 13) {
            dialogTitleId = R.string.week_picker_dialog_title;
        }
        this.mDialog = new AlertDialog.Builder(this.mContext).setTitle(dialogTitleId).setView((View)suggestionListView).setNegativeButton(this.mContext.getText(0x1040000), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                InputDialogContainer.this.dismissDialog();
            }
        }).create();
        this.mDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                if (InputDialogContainer.this.mDialog == dialog && !InputDialogContainer.this.mDialogAlreadyDismissed) {
                    InputDialogContainer.this.mDialogAlreadyDismissed = true;
                    InputDialogContainer.this.mInputActionDelegate.cancelDateTimeDialog();
                }
            }
        });
        this.mDialogAlreadyDismissed = false;
        this.mDialog.show();
    }

    public void showDialog(int type, double value, double min, double max, double step, DateTimeSuggestion[] suggestions) {
        this.dismissDialog();
        if (suggestions == null) {
            this.showPickerDialog(type, value, min, max, step);
        } else {
            this.showSuggestionDialog(type, value, min, max, step, suggestions);
        }
    }

    protected void showPickerDialog(int dialogType, int year, int month, int monthDay, int hourOfDay, int minute, int second, int millis, int week, double min, double max, double step) {
        if (this.isDialogShowing()) {
            this.mDialog.dismiss();
        }
        int stepTime = (int)step;
        if (dialogType == 8) {
            ChromeDatePickerDialog dialog = new ChromeDatePickerDialog(this.mContext, new DateListener(dialogType), year, month, monthDay);
            DateDialogNormalizer.normalize(dialog.getDatePicker(), (DatePicker.OnDateChangedListener)dialog, year, month, monthDay, 0, 0, (long)min, (long)max);
            dialog.setTitle(this.mContext.getText(R.string.date_picker_dialog_title));
            this.mDialog = dialog;
        } else if (dialogType == 12) {
            this.mDialog = new MultiFieldTimePickerDialog(this.mContext, 0, hourOfDay, minute, second, millis, (int)min, (int)max, stepTime, DateFormat.is24HourFormat((Context)this.mContext), new FullTimeListener(dialogType));
        } else if (dialogType == 9 || dialogType == 10) {
            this.mDialog = new DateTimePickerDialog(this.mContext, new DateTimeListener(dialogType), year, month, monthDay, hourOfDay, minute, DateFormat.is24HourFormat((Context)this.mContext), min, max);
        } else if (dialogType == 11) {
            this.mDialog = new MonthPickerDialog(this.mContext, new MonthOrWeekListener(dialogType), year, month, min, max);
        } else if (dialogType == 13) {
            this.mDialog = new WeekPickerDialog(this.mContext, new MonthOrWeekListener(dialogType), year, week, min, max);
        }
        this.mDialog.setButton(-1, this.mContext.getText(R.string.date_picker_dialog_set), (DialogInterface.OnClickListener)this.mDialog);
        this.mDialog.setButton(-2, this.mContext.getText(0x1040000), (DialogInterface.OnClickListener)null);
        this.mDialog.setButton(-3, this.mContext.getText(R.string.date_picker_dialog_clear), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                InputDialogContainer.this.mDialogAlreadyDismissed = true;
                InputDialogContainer.this.mInputActionDelegate.replaceDateTime(Double.NaN);
            }
        });
        this.mDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                if (!InputDialogContainer.this.mDialogAlreadyDismissed) {
                    InputDialogContainer.this.mDialogAlreadyDismissed = true;
                    InputDialogContainer.this.mInputActionDelegate.cancelDateTimeDialog();
                }
            }
        });
        this.mDialogAlreadyDismissed = false;
        this.mDialog.show();
    }

    boolean isDialogShowing() {
        return this.mDialog != null && this.mDialog.isShowing();
    }

    void dismissDialog() {
        if (this.isDialogShowing()) {
            this.mDialog.dismiss();
        }
    }

    protected void setFieldDateTimeValue(int dialogType, int year, int month, int monthDay, int hourOfDay, int minute, int second, int millis, int week) {
        if (this.mDialogAlreadyDismissed) {
            return;
        }
        this.mDialogAlreadyDismissed = true;
        if (dialogType == 11) {
            this.mInputActionDelegate.replaceDateTime((year - 1970) * 12 + month);
        } else if (dialogType == 13) {
            this.mInputActionDelegate.replaceDateTime(WeekPicker.createDateFromWeek(year, week).getTimeInMillis());
        } else if (dialogType == 12) {
            this.mInputActionDelegate.replaceDateTime(TimeUnit.HOURS.toMillis(hourOfDay) + TimeUnit.MINUTES.toMillis(minute) + TimeUnit.SECONDS.toMillis(second) + (long)millis);
        } else {
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            cal.clear();
            cal.set(1, year);
            cal.set(2, month);
            cal.set(5, monthDay);
            cal.set(11, hourOfDay);
            cal.set(12, minute);
            cal.set(13, second);
            cal.set(14, millis);
            this.mInputActionDelegate.replaceDateTime(cal.getTimeInMillis());
        }
    }

    private class MonthOrWeekListener
    implements TwoFieldDatePickerDialog.OnValueSetListener {
        private final int mDialogType;

        MonthOrWeekListener(int dialogType) {
            this.mDialogType = dialogType;
        }

        @Override
        public void onValueSet(int year, int positionInYear) {
            if (this.mDialogType == 11) {
                InputDialogContainer.this.setFieldDateTimeValue(this.mDialogType, year, positionInYear, 0, 0, 0, 0, 0, 0);
            } else {
                InputDialogContainer.this.setFieldDateTimeValue(this.mDialogType, year, 0, 0, 0, 0, 0, 0, positionInYear);
            }
        }
    }

    private class DateTimeListener
    implements DateTimePickerDialog.OnDateTimeSetListener {
        private final boolean mLocal;
        private final int mDialogType;

        public DateTimeListener(int dialogType) {
            this.mLocal = dialogType == 10;
            this.mDialogType = dialogType;
        }

        @Override
        public void onDateTimeSet(DatePicker dateView, TimePicker timeView, int year, int month, int monthDay, int hourOfDay, int minute) {
            InputDialogContainer.this.setFieldDateTimeValue(this.mDialogType, year, month, monthDay, hourOfDay, minute, 0, 0, 0);
        }
    }

    private class FullTimeListener
    implements MultiFieldTimePickerDialog.OnMultiFieldTimeSetListener {
        private final int mDialogType;

        FullTimeListener(int dialogType) {
            this.mDialogType = dialogType;
        }

        @Override
        public void onTimeSet(int hourOfDay, int minute, int second, int milli) {
            InputDialogContainer.this.setFieldDateTimeValue(this.mDialogType, 0, 0, 0, hourOfDay, minute, second, milli, 0);
        }
    }

    private class DateListener
    implements DatePickerDialog.OnDateSetListener {
        private final int mDialogType;

        DateListener(int dialogType) {
            this.mDialogType = dialogType;
        }

        public void onDateSet(DatePicker view, int year, int month, int monthDay) {
            InputDialogContainer.this.setFieldDateTimeValue(this.mDialogType, year, month, monthDay, 0, 0, 0, 0, 0);
        }
    }

    public static interface InputActionDelegate {
        public void cancelDateTimeDialog();

        public void replaceDateTime(double var1);
    }
}

