/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.picker;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.text.format.DateFormat;
import android.text.format.DateUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.NumberPicker;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.chromium.ui.R;

public abstract class TwoFieldDatePicker
extends FrameLayout {
    private final NumberPicker mPositionInYearSpinner;
    private final NumberPicker mYearSpinner;
    private OnMonthOrWeekChangedListener mMonthOrWeekChangedListener;
    private Calendar mMinDate;
    private Calendar mMaxDate;
    private Calendar mCurrentDate;

    public TwoFieldDatePicker(Context context, double minValue, double maxValue) {
        super(context, null, 16843612);
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        inflater.inflate(R.layout.two_field_date_picker, (ViewGroup)this, true);
        NumberPicker.OnValueChangeListener onChangeListener = new NumberPicker.OnValueChangeListener(){

            public void onValueChange(NumberPicker picker, int oldVal, int newVal) {
                int year = TwoFieldDatePicker.this.getYear();
                int positionInYear = TwoFieldDatePicker.this.getPositionInYear();
                if (picker == TwoFieldDatePicker.this.mPositionInYearSpinner) {
                    positionInYear = newVal;
                    if (oldVal == picker.getMaxValue() && newVal == picker.getMinValue()) {
                        positionInYear = TwoFieldDatePicker.this.getMinPositionInYear(++year);
                    } else if (oldVal == picker.getMinValue() && newVal == picker.getMaxValue()) {
                        positionInYear = TwoFieldDatePicker.this.getMaxPositionInYear(--year);
                    }
                } else if (picker == TwoFieldDatePicker.this.mYearSpinner) {
                    year = newVal;
                } else {
                    throw new IllegalArgumentException();
                }
                TwoFieldDatePicker.this.setCurrentDate(year, positionInYear);
                TwoFieldDatePicker.this.updateSpinners();
                TwoFieldDatePicker.this.notifyDateChanged();
            }
        };
        this.mCurrentDate = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        if (minValue >= maxValue) {
            this.mMinDate = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            this.mMinDate.set(0, 0, 1);
            this.mMaxDate = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            this.mMaxDate.set(9999, 0, 1);
        } else {
            this.mMinDate = this.getDateForValue(minValue);
            this.mMaxDate = this.getDateForValue(maxValue);
        }
        this.mPositionInYearSpinner = (NumberPicker)this.findViewById(R.id.position_in_year);
        this.mPositionInYearSpinner.setOnLongPressUpdateInterval(200L);
        this.mPositionInYearSpinner.setOnValueChangedListener(onChangeListener);
        this.mYearSpinner = (NumberPicker)this.findViewById(R.id.year);
        this.mYearSpinner.setOnLongPressUpdateInterval(100L);
        this.mYearSpinner.setOnValueChangedListener(onChangeListener);
        this.reorderSpinners();
    }

    @TargetApi(value=18)
    private void reorderSpinners() {
        boolean posInserted = false;
        boolean yearInserted = false;
        LinearLayout pickers = (LinearLayout)this.findViewById(R.id.pickers);
        pickers.removeView((View)this.mPositionInYearSpinner);
        pickers.removeView((View)this.mYearSpinner);
        if (Build.VERSION.SDK_INT >= 18) {
            String pattern = DateFormat.getBestDateTimePattern((Locale)Locale.getDefault(), (String)"yyyyMMMdd");
            for (int i = 0; i < pattern.length(); ++i) {
                char ch = pattern.charAt(i);
                if (ch == '\'') {
                    if ((i = pattern.indexOf(39, i + 1)) != -1) continue;
                    throw new IllegalArgumentException("Bad quoting in " + pattern);
                }
                if (!(ch != 'M' && ch != 'L' || posInserted)) {
                    pickers.addView((View)this.mPositionInYearSpinner);
                    posInserted = true;
                    continue;
                }
                if (ch != 'y' || yearInserted) continue;
                pickers.addView((View)this.mYearSpinner);
                yearInserted = true;
            }
        } else {
            char[] order = DateFormat.getDateFormatOrder((Context)this.getContext());
            for (int i = 0; i < order.length; ++i) {
                if (order[i] == 'M') {
                    pickers.addView((View)this.mPositionInYearSpinner);
                    posInserted = true;
                    continue;
                }
                if (order[i] != 'y') continue;
                pickers.addView((View)this.mYearSpinner);
                yearInserted = true;
            }
        }
        if (!posInserted) {
            pickers.addView((View)this.mPositionInYearSpinner);
        }
        if (!yearInserted) {
            pickers.addView((View)this.mYearSpinner);
        }
    }

    public void init(int year, int positionInYear, OnMonthOrWeekChangedListener onMonthOrWeekChangedListener) {
        this.setCurrentDate(year, positionInYear);
        this.updateSpinners();
        this.mMonthOrWeekChangedListener = onMonthOrWeekChangedListener;
    }

    public boolean isNewDate(int year, int positionInYear) {
        return this.getYear() != year || this.getPositionInYear() != positionInYear;
    }

    protected abstract Calendar getDateForValue(double var1);

    public void updateDate(int year, int positionInYear) {
        if (!this.isNewDate(year, positionInYear)) {
            return;
        }
        this.setCurrentDate(year, positionInYear);
        this.updateSpinners();
        this.notifyDateChanged();
    }

    protected abstract void setCurrentDate(int var1, int var2);

    protected void setCurrentDate(Calendar date) {
        this.mCurrentDate = date;
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        this.onPopulateAccessibilityEvent(event);
        return true;
    }

    public void onPopulateAccessibilityEvent(AccessibilityEvent event) {
        super.onPopulateAccessibilityEvent(event);
        int flags = 20;
        String selectedDateUtterance = DateUtils.formatDateTime((Context)this.getContext(), (long)this.mCurrentDate.getTimeInMillis(), (int)20);
        event.getText().add(selectedDateUtterance);
    }

    public int getYear() {
        return this.mCurrentDate.get(1);
    }

    public abstract int getPositionInYear();

    protected abstract int getMaxYear();

    protected abstract int getMinYear();

    protected abstract int getMaxPositionInYear(int var1);

    protected abstract int getMinPositionInYear(int var1);

    protected Calendar getMaxDate() {
        return this.mMaxDate;
    }

    protected Calendar getMinDate() {
        return this.mMinDate;
    }

    protected Calendar getCurrentDate() {
        return this.mCurrentDate;
    }

    protected NumberPicker getPositionInYearSpinner() {
        return this.mPositionInYearSpinner;
    }

    protected NumberPicker getYearSpinner() {
        return this.mYearSpinner;
    }

    protected void updateSpinners() {
        this.mPositionInYearSpinner.setDisplayedValues(null);
        this.mPositionInYearSpinner.setMinValue(this.getMinPositionInYear(this.getYear()));
        this.mPositionInYearSpinner.setMaxValue(this.getMaxPositionInYear(this.getYear()));
        this.mPositionInYearSpinner.setWrapSelectorWheel(!this.mCurrentDate.equals(this.mMinDate) && !this.mCurrentDate.equals(this.mMaxDate));
        this.mYearSpinner.setMinValue(this.getMinYear());
        this.mYearSpinner.setMaxValue(this.getMaxYear());
        this.mYearSpinner.setWrapSelectorWheel(false);
        this.mYearSpinner.setValue(this.getYear());
        this.mPositionInYearSpinner.setValue(this.getPositionInYear());
    }

    protected void notifyDateChanged() {
        this.sendAccessibilityEvent(4);
        if (this.mMonthOrWeekChangedListener != null) {
            this.mMonthOrWeekChangedListener.onMonthOrWeekChanged(this, this.getYear(), this.getPositionInYear());
        }
    }

    public static interface OnMonthOrWeekChangedListener {
        public void onMonthOrWeekChanged(TwoFieldDatePicker var1, int var2, int var3);
    }
}

