/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.resources;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.util.SparseArray;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.ui.resources.LayoutResource;
import org.chromium.ui.resources.Resource;
import org.chromium.ui.resources.ResourceLoader;
import org.chromium.ui.resources.dynamics.DynamicResourceLoader;
import org.chromium.ui.resources.statics.StaticResourceLoader;
import org.chromium.ui.resources.system.SystemResourceLoader;

@JNINamespace(value="ui")
public class ResourceManager
implements ResourceLoader.ResourceLoaderCallback {
    private final SparseArray<ResourceLoader> mResourceLoaders = new SparseArray();
    private final SparseArray<SparseArray<LayoutResource>> mLoadedResources = new SparseArray();
    private final float mPxToDp;
    private long mNativeResourceManagerPtr;

    private ResourceManager(Context context, long staticResourceManagerPtr) {
        Resources resources = context.getResources();
        this.mPxToDp = 1.0f / resources.getDisplayMetrics().density;
        this.registerResourceLoader(new StaticResourceLoader(0, (ResourceLoader.ResourceLoaderCallback)this, resources));
        this.registerResourceLoader(new DynamicResourceLoader(1, this));
        this.registerResourceLoader(new DynamicResourceLoader(2, this));
        this.registerResourceLoader(new SystemResourceLoader(3, (ResourceLoader.ResourceLoaderCallback)this, context));
        this.mNativeResourceManagerPtr = staticResourceManagerPtr;
    }

    @CalledByNative
    private static ResourceManager create(Context context, long staticResourceManagerPtr) {
        return new ResourceManager(context, staticResourceManagerPtr);
    }

    public DynamicResourceLoader getDynamicResourceLoader() {
        return (DynamicResourceLoader)this.mResourceLoaders.get(1);
    }

    public DynamicResourceLoader getBitmapDynamicResourceLoader() {
        return (DynamicResourceLoader)this.mResourceLoaders.get(2);
    }

    public void preloadResources(int type, int[] syncIds, int[] asyncIds) {
        Integer resId;
        int i$;
        int len$;
        int[] arr$;
        ResourceLoader loader = (ResourceLoader)this.mResourceLoaders.get(type);
        if (asyncIds != null) {
            arr$ = asyncIds;
            len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                resId = arr$[i$];
                loader.preloadResource(resId);
            }
        }
        if (syncIds != null) {
            arr$ = syncIds;
            len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                resId = arr$[i$];
                loader.loadResource(resId);
            }
        }
    }

    public LayoutResource getResource(int resType, int resId) {
        SparseArray bucket = (SparseArray)this.mLoadedResources.get(resType);
        return bucket != null ? (LayoutResource)bucket.get(resId) : null;
    }

    @Override
    public void onResourceLoaded(int resType, int resId, Resource resource) {
        if (resource == null) {
            return;
        }
        this.saveMetadataForLoadedResource(resType, resId, resource);
        if (this.mNativeResourceManagerPtr == 0L) {
            return;
        }
        Rect padding = resource.getPadding();
        Rect aperture = resource.getAperture();
        this.nativeOnResourceReady(this.mNativeResourceManagerPtr, resType, resId, resource.getBitmap(), padding.left, padding.top, padding.right, padding.bottom, aperture.left, aperture.top, aperture.right, aperture.bottom);
    }

    private void saveMetadataForLoadedResource(int resType, int resId, Resource resource) {
        SparseArray bucket = (SparseArray)this.mLoadedResources.get(resType);
        if (bucket == null) {
            bucket = new SparseArray();
            this.mLoadedResources.put(resType, (Object)bucket);
        }
        bucket.put(resId, (Object)new LayoutResource(this.mPxToDp, resource));
    }

    @CalledByNative
    private void destroy() {
        assert (this.mNativeResourceManagerPtr != 0L);
        this.mNativeResourceManagerPtr = 0L;
    }

    @CalledByNative
    private void resourceRequested(int resType, int resId) {
        ResourceLoader loader = (ResourceLoader)this.mResourceLoaders.get(resType);
        if (loader != null) {
            loader.loadResource(resId);
        }
    }

    @CalledByNative
    private void preloadResource(int resType, int resId) {
        ResourceLoader loader = (ResourceLoader)this.mResourceLoaders.get(resType);
        if (loader != null) {
            loader.preloadResource(resId);
        }
    }

    @CalledByNative
    private long getNativePtr() {
        return this.mNativeResourceManagerPtr;
    }

    private void registerResourceLoader(ResourceLoader loader) {
        this.mResourceLoaders.put(loader.getResourceType(), (Object)loader);
    }

    private native void nativeOnResourceReady(long var1, int var3, int var4, Bitmap var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13);
}

