/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.resources.dynamics;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.view.View;
import org.chromium.base.TraceEvent;
import org.chromium.ui.resources.dynamics.DynamicResource;

public class ViewResourceAdapter
implements DynamicResource,
View.OnLayoutChangeListener {
    private final View mView;
    private final Rect mDirtyRect = new Rect();
    private final Rect mContentPadding = new Rect();
    private final Rect mContentAperture = new Rect();
    private Bitmap mBitmap;
    private Rect mBitmapSize = new Rect();

    public ViewResourceAdapter(View view) {
        this.mView = view;
        this.mView.addOnLayoutChangeListener((View.OnLayoutChangeListener)this);
    }

    @Override
    public Bitmap getBitmap() {
        if (!this.isDirty()) {
            return this.mBitmap;
        }
        TraceEvent.begin("ViewResourceAdapter:getBitmap");
        if (this.validateBitmap()) {
            Canvas canvas = new Canvas(this.mBitmap);
            this.onCaptureStart(canvas, this.mDirtyRect.isEmpty() ? null : this.mDirtyRect);
            if (!this.mDirtyRect.isEmpty()) {
                canvas.clipRect(this.mDirtyRect);
            }
            this.capture(canvas);
            this.onCaptureEnd();
        } else {
            assert (this.mBitmap.getWidth() == 1 && this.mBitmap.getHeight() == 1);
            this.mBitmap.setPixel(0, 0, 0);
        }
        this.mDirtyRect.setEmpty();
        TraceEvent.end("ViewResourceAdapter:getBitmap");
        return this.mBitmap;
    }

    @Override
    public Rect getBitmapSize() {
        return this.mBitmapSize;
    }

    @Override
    public Rect getPadding() {
        this.computeContentPadding(this.mContentPadding);
        return this.mContentPadding;
    }

    @Override
    public Rect getAperture() {
        this.computeContentAperture(this.mContentAperture);
        return this.mContentAperture;
    }

    @Override
    public boolean isDirty() {
        if (this.mBitmap == null) {
            this.mDirtyRect.set(0, 0, this.mView.getWidth(), this.mView.getHeight());
        }
        return !this.mDirtyRect.isEmpty();
    }

    public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        int width = right - left;
        int height = bottom - top;
        int oldWidth = oldRight - oldLeft;
        int oldHeight = oldBottom - oldTop;
        if (width != oldWidth || height != oldHeight) {
            this.mDirtyRect.set(0, 0, width, height);
        }
    }

    public void invalidate(Rect dirtyRect) {
        if (dirtyRect == null) {
            this.mDirtyRect.set(0, 0, this.mView.getWidth(), this.mView.getHeight());
        } else {
            this.mDirtyRect.union(dirtyRect);
        }
    }

    protected void onCaptureStart(Canvas canvas, Rect dirtyRect) {
    }

    protected void capture(Canvas canvas) {
        this.mView.draw(canvas);
    }

    protected void onCaptureEnd() {
    }

    protected void computeContentPadding(Rect outContentPadding) {
        outContentPadding.set(0, 0, this.mView.getWidth(), this.mView.getHeight());
    }

    protected void computeContentAperture(Rect outContentAperture) {
        outContentAperture.set(0, 0, this.mView.getWidth(), this.mView.getHeight());
    }

    private boolean validateBitmap() {
        boolean isEmpty;
        int viewWidth = this.mView.getWidth();
        int viewHeight = this.mView.getHeight();
        boolean bl = isEmpty = viewWidth == 0 || viewHeight == 0;
        if (isEmpty) {
            viewWidth = 1;
            viewHeight = 1;
        }
        if (this.mBitmap != null && (this.mBitmap.getWidth() != viewWidth || this.mBitmap.getHeight() != viewHeight)) {
            this.mBitmap.recycle();
            this.mBitmap = null;
        }
        if (this.mBitmap == null) {
            this.mBitmap = Bitmap.createBitmap((int)viewWidth, (int)viewHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.mBitmap.setHasAlpha(true);
            this.mDirtyRect.set(0, 0, viewWidth, viewHeight);
            this.mBitmapSize.set(0, 0, this.mBitmap.getWidth(), this.mBitmap.getHeight());
        }
        return !isEmpty;
    }
}

