/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.text;

import android.text.SpannableString;
import java.util.Arrays;

public class SpanApplier {
    public static SpannableString applySpans(String input, SpanInfo ... spans) {
        for (SpanInfo span : spans) {
            span.mStartTagIndex = input.indexOf(span.mStartTag);
            span.mEndTagIndex = input.indexOf(span.mEndTag, span.mStartTagIndex + span.mStartTag.length());
        }
        Arrays.sort(spans);
        int inputIndex = 0;
        StringBuilder output = new StringBuilder(input.length());
        for (SpanInfo span : spans) {
            if (span.mStartTagIndex == -1 || span.mEndTagIndex == -1 || span.mStartTagIndex < inputIndex) {
                span.mStartTagIndex = -1;
                String error = String.format("Input string is missing tags %s%s: %s", span.mStartTag, span.mEndTag, input);
                throw new IllegalArgumentException(error);
            }
            output.append(input, inputIndex, span.mStartTagIndex);
            inputIndex = span.mStartTagIndex + span.mStartTag.length();
            span.mStartTagIndex = output.length();
            output.append(input, inputIndex, span.mEndTagIndex);
            inputIndex = span.mEndTagIndex + span.mEndTag.length();
            span.mEndTagIndex = output.length();
        }
        output.append(input, inputIndex, input.length());
        SpannableString spannableString = new SpannableString((CharSequence)output);
        for (SpanInfo span : spans) {
            if (span.mStartTagIndex == -1) continue;
            spannableString.setSpan(span.mSpan, span.mStartTagIndex, span.mEndTagIndex, 0);
        }
        return spannableString;
    }

    public static final class SpanInfo
    implements Comparable<SpanInfo> {
        final String mStartTag;
        final String mEndTag;
        final Object mSpan;
        int mStartTagIndex;
        int mEndTagIndex;

        public SpanInfo(String startTag, String endTag, Object span) {
            this.mStartTag = startTag;
            this.mEndTag = endTag;
            this.mSpan = span;
        }

        @Override
        public int compareTo(SpanInfo other) {
            return this.mStartTagIndex < other.mStartTagIndex ? -1 : (this.mStartTagIndex == other.mStartTagIndex ? 0 : 1);
        }

        public boolean equals(Object other) {
            if (!(other instanceof SpanInfo)) {
                return false;
            }
            return this.compareTo((SpanInfo)other) == 0;
        }

        public int hashCode() {
            return 0;
        }
    }
}

