/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Bundle;
import android.text.Layout;
import android.text.SpannableString;
import android.text.style.ClickableSpan;
import android.util.AttributeSet;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.accessibility.AccessibilityManager;
import android.widget.PopupMenu;
import android.widget.TextView;

public class TextViewWithClickableSpans
extends TextView {
    private AccessibilityManager mAccessibilityManager;

    public TextViewWithClickableSpans(Context context) {
        super(context);
        this.init();
    }

    public TextViewWithClickableSpans(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public TextViewWithClickableSpans(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.mAccessibilityManager = (AccessibilityManager)this.getContext().getSystemService("accessibility");
        this.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (!TextViewWithClickableSpans.this.mAccessibilityManager.isTouchExplorationEnabled()) {
                    return false;
                }
                TextViewWithClickableSpans.this.openDisambiguationMenu();
                return true;
            }
        });
    }

    @TargetApi(value=16)
    public boolean performAccessibilityAction(int action, Bundle arguments) {
        if (action == 16) {
            this.handleAccessibilityClick();
            return true;
        }
        return super.performAccessibilityAction(action, arguments);
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean superResult = super.onTouchEvent(event);
        if (event.getAction() != 1 && this.mAccessibilityManager.isTouchExplorationEnabled() && !this.touchIntersectsAnyClickableSpans(event)) {
            this.handleAccessibilityClick();
            return true;
        }
        return superResult;
    }

    private boolean touchIntersectsAnyClickableSpans(MotionEvent event) {
        int line;
        CharSequence text = this.getText();
        if (!(text instanceof SpannableString)) {
            return false;
        }
        SpannableString spannable = (SpannableString)text;
        int x = (int)event.getX();
        int y = (int)event.getY();
        x -= this.getTotalPaddingLeft();
        y -= this.getTotalPaddingTop();
        Layout layout2 = this.getLayout();
        int off = layout2.getOffsetForHorizontal(line = layout2.getLineForVertical(y += this.getScrollY()), (float)(x += this.getScrollX()));
        ClickableSpan[] clickableSpans = (ClickableSpan[])spannable.getSpans(off, off, ClickableSpan.class);
        return clickableSpans.length > 0;
    }

    private ClickableSpan[] getClickableSpans() {
        CharSequence text = this.getText();
        if (!(text instanceof SpannableString)) {
            return null;
        }
        SpannableString spannable = (SpannableString)text;
        return (ClickableSpan[])spannable.getSpans(0, spannable.length(), ClickableSpan.class);
    }

    private void handleAccessibilityClick() {
        ClickableSpan[] clickableSpans = this.getClickableSpans();
        if (clickableSpans == null || clickableSpans.length == 0) {
            return;
        }
        if (clickableSpans.length == 1) {
            clickableSpans[0].onClick((View)this);
        } else {
            this.openDisambiguationMenu();
        }
    }

    private void openDisambiguationMenu() {
        ClickableSpan[] clickableSpans = this.getClickableSpans();
        if (clickableSpans == null || clickableSpans.length == 0) {
            return;
        }
        SpannableString spannable = (SpannableString)this.getText();
        PopupMenu popup = new PopupMenu(this.getContext(), (View)this);
        Menu menu2 = popup.getMenu();
        for (final ClickableSpan clickableSpan : clickableSpans) {
            CharSequence itemText = spannable.subSequence(spannable.getSpanStart((Object)clickableSpan), spannable.getSpanEnd((Object)clickableSpan));
            MenuItem menuItem = menu2.add(itemText);
            menuItem.setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

                public boolean onMenuItemClick(MenuItem menuItem) {
                    clickableSpan.onClick((View)TextViewWithClickableSpans.this);
                    return true;
                }
            });
        }
        popup.show();
    }
}

