/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.xwalk.core.ClientCertRequest;
import org.xwalk.core.ReflectMethod;
import org.xwalk.core.XWalkCoreWrapper;

public class ClientCertRequestHandler
implements ClientCertRequest {
    private ArrayList<Object> constructorTypes;
    private ArrayList<Object> constructorParams;
    private ReflectMethod postWrapperMethod;
    private XWalkCoreWrapper coreWrapper;
    private Object bridge;
    private ReflectMethod proceedPrivateKeyListMethod = new ReflectMethod(null, "proceed", new Class[0]);
    private ReflectMethod ignoreMethod = new ReflectMethod(null, "ignore", new Class[0]);
    private ReflectMethod cancelMethod = new ReflectMethod(null, "cancel", new Class[0]);
    private ReflectMethod getHostMethod = new ReflectMethod(null, "getHost", new Class[0]);
    private ReflectMethod getPortMethod = new ReflectMethod(null, "getPort", new Class[0]);

    Object getBridge() {
        return this.bridge;
    }

    public ClientCertRequestHandler(Object bridge) {
        this.bridge = bridge;
        this.reflectionInit();
    }

    @Override
    public void proceed(PrivateKey privateKey, List<X509Certificate> chain) {
        this.proceedPrivateKeyListMethod.invoke(privateKey, chain);
    }

    @Override
    public void ignore() {
        this.ignoreMethod.invoke(new Object[0]);
    }

    @Override
    public void cancel() {
        this.cancelMethod.invoke(new Object[0]);
    }

    @Override
    public String getHost() {
        return (String)this.getHostMethod.invoke(new Object[0]);
    }

    @Override
    public int getPort() {
        return (Integer)this.getPortMethod.invoke(new Object[0]);
    }

    void reflectionInit() {
        XWalkCoreWrapper.initEmbeddedMode();
        this.coreWrapper = XWalkCoreWrapper.getInstance();
        if (this.coreWrapper == null) {
            XWalkCoreWrapper.reserveReflectObject(this);
            return;
        }
        this.proceedPrivateKeyListMethod.init(this.bridge, null, "proceedSuper", PrivateKey.class, List.class);
        this.ignoreMethod.init(this.bridge, null, "ignoreSuper", new Class[0]);
        this.cancelMethod.init(this.bridge, null, "cancelSuper", new Class[0]);
        this.getHostMethod.init(this.bridge, null, "getHostSuper", new Class[0]);
        this.getPortMethod.init(this.bridge, null, "getPortSuper", new Class[0]);
    }
}

