/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import android.view.Window;
import org.xwalk.core.XWalkDialogManager;
import org.xwalk.core.XWalkLibraryLoader;
import org.xwalk.core.XWalkUpdater;

public class XWalkActivityDelegate
implements XWalkLibraryLoader.DecompressListener,
XWalkLibraryLoader.ActivateListener,
XWalkUpdater.XWalkUpdateListener {
    private static final String TAG = "XWalkActivity";
    private Activity mActivity;
    private XWalkDialogManager mDialogManager;
    private XWalkUpdater mXWalkUpdater;
    private Runnable mCancelCommand;
    private Runnable mCompleteCommand;
    private boolean mIsInitializing;
    private boolean mIsXWalkReady;
    private boolean mBackgroundDecorated;
    private boolean mWillDecompress;

    public XWalkActivityDelegate(Activity activity, Runnable cancelCommand, Runnable completeCommand) {
        this.mActivity = activity;
        this.mCancelCommand = cancelCommand;
        this.mCompleteCommand = completeCommand;
        this.mDialogManager = new XWalkDialogManager((Context)this.mActivity);
        this.mXWalkUpdater = new XWalkUpdater(this, this.mActivity, this.mDialogManager);
        XWalkLibraryLoader.prepareToInit(this.mActivity);
    }

    public boolean isXWalkReady() {
        return this.mIsXWalkReady;
    }

    public boolean isSharedMode() {
        return this.mIsXWalkReady && XWalkLibraryLoader.isSharedLibrary();
    }

    public void setXWalkApkUrl(String url) {
        this.mXWalkUpdater.setXWalkApkUrl(url);
    }

    public void onResume() {
        if (this.mIsInitializing || this.mIsXWalkReady) {
            return;
        }
        this.mIsInitializing = true;
        if (XWalkLibraryLoader.isLibraryReady()) {
            Log.d((String)TAG, (String)"Activate by XWalkActivity");
            XWalkLibraryLoader.startActivate(this, this.mActivity);
        } else {
            Log.d((String)TAG, (String)"Initialize by XWalkActivity");
            XWalkLibraryLoader.startDecompress(this, (Context)this.mActivity);
        }
    }

    @Override
    public void onDecompressStarted() {
        this.mDialogManager.showDecompressProgress(new Runnable(){

            @Override
            public void run() {
                Log.d((String)XWalkActivityDelegate.TAG, (String)"Cancel by XWalkActivity");
                XWalkLibraryLoader.cancelDecompress();
            }
        });
        this.mWillDecompress = true;
    }

    @Override
    public void onDecompressCancelled() {
        this.mDialogManager.dismissDialog();
        this.mWillDecompress = false;
        this.mIsInitializing = false;
        this.mCancelCommand.run();
    }

    @Override
    public void onDecompressCompleted() {
        if (this.mWillDecompress) {
            this.mDialogManager.dismissDialog();
            this.mWillDecompress = false;
        }
        XWalkLibraryLoader.startActivate(this, this.mActivity);
    }

    @Override
    public void onActivateStarted() {
    }

    @Override
    public void onActivateFailed() {
        Window window;
        this.mIsInitializing = false;
        if (this.mXWalkUpdater.updateXWalkRuntime() && (window = this.mActivity.getWindow()) != null && window.getDecorView().getBackground() == null) {
            Log.d((String)TAG, (String)"Set the background to screen_background_dark");
            window.setBackgroundDrawableResource(17301656);
            this.mBackgroundDecorated = true;
        }
    }

    @Override
    public void onActivateCompleted() {
        if (this.mDialogManager.isShowingDialog()) {
            this.mDialogManager.dismissDialog();
        }
        if (this.mBackgroundDecorated) {
            Log.d((String)TAG, (String)"Recover the background");
            this.mActivity.getWindow().setBackgroundDrawable(null);
            this.mBackgroundDecorated = false;
        }
        this.mIsInitializing = false;
        this.mIsXWalkReady = true;
        this.mCompleteCommand.run();
    }

    @Override
    public void onXWalkUpdateCancelled() {
        this.mCancelCommand.run();
    }
}

