/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core;

import android.app.AlertDialog;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import junit.framework.Assert;
import org.xwalk.core.R;

class XWalkDialogManager {
    private static final String TAG = "XWalkLib";
    private static final String PACKAGE_RE = "[a-z]+\\.[a-z0-9]+\\.[a-z0-9]+.*";
    private Context mContext;
    private Dialog mActiveDialog;
    private String mApplicationName;

    public XWalkDialogManager(Context context) {
        this.mContext = context;
    }

    private void showDialog(Dialog dialog) {
        this.mActiveDialog = dialog;
        this.mActiveDialog.show();
    }

    public void dismissDialog() {
        this.mActiveDialog.dismiss();
        this.mActiveDialog = null;
    }

    public boolean isShowingDialog() {
        return this.mActiveDialog != null && this.mActiveDialog.isShowing();
    }

    public boolean isShowingProgressDialog() {
        return this.isShowingDialog() && this.mActiveDialog instanceof ProgressDialog;
    }

    public void setProgress(int progress, int max) {
        ProgressDialog dialog = (ProgressDialog)this.mActiveDialog;
        dialog.setIndeterminate(false);
        dialog.setMax(max);
        dialog.setProgress(progress);
    }

    public void showInitializationError(int status, Runnable cancelCommand, Runnable downloadCommand) {
        AlertDialog dialog = this.buildAlertDialog();
        String cancelText = this.mContext.getString(R.string.xwalk_close);
        String downloadText = this.mContext.getString(R.string.xwalk_get_crosswalk);
        if (status == 2) {
            dialog.setTitle((CharSequence)this.mContext.getString(R.string.startup_not_found_title));
            dialog.setMessage((CharSequence)this.replaceApplicationName(this.mContext.getString(R.string.startup_not_found_message)));
            this.setPositiveButton(dialog, downloadText, downloadCommand);
            this.setNegativeButton(dialog, cancelText, cancelCommand);
        } else if (status == 3) {
            dialog.setTitle((CharSequence)this.mContext.getString(R.string.startup_older_version_title));
            dialog.setMessage((CharSequence)this.replaceApplicationName(this.mContext.getString(R.string.startup_older_version_message)));
            this.setPositiveButton(dialog, downloadText, downloadCommand);
            this.setNegativeButton(dialog, cancelText, cancelCommand);
        } else if (status == 4) {
            dialog.setTitle((CharSequence)this.mContext.getString(R.string.startup_newer_version_title));
            dialog.setMessage((CharSequence)this.replaceApplicationName(this.mContext.getString(R.string.startup_newer_version_message)));
            this.setNegativeButton(dialog, cancelText, cancelCommand);
        } else if (status == 5) {
            dialog.setTitle((CharSequence)this.mContext.getString(R.string.startup_incomplete_library_title));
            dialog.setMessage((CharSequence)this.replaceApplicationName(this.mContext.getString(R.string.startup_incomplete_library_message)));
            this.setNegativeButton(dialog, cancelText, cancelCommand);
        } else if (status == 6) {
            dialog.setTitle((CharSequence)this.mContext.getString(R.string.startup_architecture_mismatch_title));
            dialog.setMessage((CharSequence)this.replaceApplicationName(this.mContext.getString(R.string.startup_architecture_mismatch_message)));
            this.setPositiveButton(dialog, downloadText, downloadCommand);
            this.setNegativeButton(dialog, cancelText, cancelCommand);
        } else if (status == 7) {
            dialog.setTitle((CharSequence)this.mContext.getString(R.string.startup_signature_check_error_title));
            dialog.setMessage((CharSequence)this.replaceApplicationName(this.mContext.getString(R.string.startup_signature_check_error_message)));
            this.setNegativeButton(dialog, cancelText, cancelCommand);
        } else {
            Assert.fail((String)("Invalid status for alert dialog " + status));
        }
        this.showDialog((Dialog)dialog);
    }

    public void showMarketOpenError(Runnable cancelCommand) {
        AlertDialog dialog = this.buildAlertDialog();
        dialog.setTitle((CharSequence)this.mContext.getString(R.string.crosswalk_install_title));
        dialog.setMessage((CharSequence)this.mContext.getString(R.string.market_open_failed_message));
        this.setNegativeButton(dialog, this.mContext.getString(R.string.xwalk_close), cancelCommand);
        this.showDialog((Dialog)dialog);
    }

    public void showDecompressProgress(Runnable cancelCommand) {
        ProgressDialog dialog = this.buildProgressDialog();
        dialog.setTitle((CharSequence)this.mContext.getString(R.string.crosswalk_install_title));
        dialog.setMessage((CharSequence)this.mContext.getString(R.string.decompression_progress_message));
        this.setNegativeButton((AlertDialog)dialog, this.mContext.getString(R.string.xwalk_cancel), cancelCommand);
        this.showDialog((Dialog)dialog);
    }

    public void showDownloadProgress(Runnable cancelCommand) {
        ProgressDialog dialog = this.buildProgressDialog();
        dialog.setTitle((CharSequence)this.mContext.getString(R.string.crosswalk_install_title));
        dialog.setMessage((CharSequence)this.mContext.getString(R.string.download_progress_message));
        dialog.setProgressStyle(1);
        this.setNegativeButton((AlertDialog)dialog, this.mContext.getString(R.string.xwalk_cancel), cancelCommand);
        this.showDialog((Dialog)dialog);
    }

    public void showDownloadError(int status, int error, Runnable cancelCommand, Runnable downloadCommand) {
        String message = this.mContext.getString(R.string.download_failed_message);
        if (status == 16) {
            if (error == 1007) {
                message = this.mContext.getString(R.string.download_failed_device_not_found);
            } else if (error == 1006) {
                message = this.mContext.getString(R.string.download_failed_insufficient_space);
            }
        } else if (status == 4) {
            message = this.mContext.getString(R.string.download_failed_time_out);
        }
        AlertDialog dialog = this.buildAlertDialog();
        dialog.setTitle((CharSequence)this.mContext.getString(R.string.crosswalk_install_title));
        dialog.setMessage((CharSequence)message);
        this.setPositiveButton(dialog, this.mContext.getString(R.string.xwalk_retry), downloadCommand);
        this.setNegativeButton(dialog, this.mContext.getString(R.string.xwalk_cancel), cancelCommand);
        this.showDialog((Dialog)dialog);
    }

    private ProgressDialog buildProgressDialog() {
        ProgressDialog dialog = new ProgressDialog(this.mContext);
        dialog.setProgressStyle(0);
        dialog.setIndeterminate(true);
        dialog.setCancelable(false);
        dialog.setCanceledOnTouchOutside(false);
        return dialog;
    }

    private AlertDialog buildAlertDialog() {
        AlertDialog dialog = new AlertDialog.Builder(this.mContext).create();
        dialog.setIcon(17301543);
        dialog.setCancelable(false);
        dialog.setCanceledOnTouchOutside(false);
        return dialog;
    }

    private void setPositiveButton(AlertDialog dialog, String text, final Runnable command) {
        dialog.setButton(-1, (CharSequence)text, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                command.run();
            }
        });
    }

    private void setNegativeButton(AlertDialog dialog, String text, final Runnable command) {
        dialog.setButton(-2, (CharSequence)text, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                command.run();
            }
        });
    }

    private String replaceApplicationName(String text) {
        if (this.mApplicationName == null) {
            try {
                PackageManager packageManager = this.mContext.getPackageManager();
                ApplicationInfo appInfo = packageManager.getApplicationInfo(this.mContext.getPackageName(), 0);
                this.mApplicationName = (String)packageManager.getApplicationLabel(appInfo);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
            if (this.mApplicationName == null || this.mApplicationName.matches(PACKAGE_RE)) {
                this.mApplicationName = "this application";
            }
            Log.d((String)TAG, (String)("Crosswalk application name: " + this.mApplicationName));
        }
        if ((text = text.replaceAll("APP_NAME", this.mApplicationName)).startsWith("this")) {
            text = text.replaceFirst("this", "This");
        }
        return text;
    }
}

