/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import org.xwalk.core.XWalkLibraryLoader;

public class XWalkInitializer {
    private static final String TAG = "XWalkActivity";
    private XWalkInitListener mInitListener;
    private Activity mActivity;
    private boolean mIsInitializing;
    private boolean mIsXWalkReady;

    public XWalkInitializer(XWalkInitListener listener, Activity activity) {
        this.mInitListener = listener;
        this.mActivity = activity;
        XWalkLibraryLoader.prepareToInit(this.mActivity);
    }

    public boolean initAsync() {
        if (this.mIsInitializing || this.mIsXWalkReady) {
            return false;
        }
        this.mIsInitializing = true;
        this.mInitListener.onXWalkInitStarted();
        if (XWalkLibraryLoader.isLibraryReady()) {
            Log.d((String)TAG, (String)"Activate by XWalkInitializer");
            XWalkLibraryLoader.startActivate(new XWalkLibraryListener(), this.mActivity);
        } else {
            Log.d((String)TAG, (String)"Initialize by XWalkInitializer");
            XWalkLibraryLoader.startDecompress(new XWalkLibraryListener(), (Context)this.mActivity);
        }
        return true;
    }

    public boolean cancelInit() {
        Log.d((String)TAG, (String)"Cancel by XWalkInitializer");
        return this.mIsInitializing && XWalkLibraryLoader.cancelDecompress();
    }

    private class XWalkLibraryListener
    implements XWalkLibraryLoader.DecompressListener,
    XWalkLibraryLoader.ActivateListener {
        private XWalkLibraryListener() {
        }

        @Override
        public void onDecompressStarted() {
        }

        @Override
        public void onDecompressCancelled() {
            XWalkInitializer.this.mIsInitializing = false;
            XWalkInitializer.this.mInitListener.onXWalkInitCancelled();
        }

        @Override
        public void onDecompressCompleted() {
            XWalkLibraryLoader.startActivate(this, XWalkInitializer.this.mActivity);
        }

        @Override
        public void onActivateStarted() {
        }

        @Override
        public void onActivateFailed() {
            XWalkInitializer.this.mIsInitializing = false;
            XWalkInitializer.this.mInitListener.onXWalkInitFailed();
        }

        @Override
        public void onActivateCompleted() {
            XWalkInitializer.this.mIsInitializing = false;
            XWalkInitializer.this.mIsXWalkReady = true;
            XWalkInitializer.this.mInitListener.onXWalkInitCompleted();
        }
    }

    public static interface XWalkInitListener {
        public void onXWalkInitStarted();

        public void onXWalkInitCancelled();

        public void onXWalkInitFailed();

        public void onXWalkInitCompleted();
    }
}

