/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core;

import SevenZip.Compression.LZMA.Decoder;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class XWalkLibraryDecompressor {
    private static final String[] MANDATORY_LIBRARIES = new String[]{"libxwalkcore.so"};
    private static final String TAG = "XWalkLib";

    XWalkLibraryDecompressor() {
    }

    public static boolean isCompressed(Context context) {
        for (String library : MANDATORY_LIBRARIES) {
            try {
                InputStream inputStream = XWalkLibraryDecompressor.openRawResource(context, library);
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("Closing " + library + "has failed: " + e.getMessage()));
                }
            }
            catch (Resources.NotFoundException e) {
                return false;
            }
        }
        return true;
    }

    public static boolean isDecompressed(Context context) {
        int version = XWalkLibraryDecompressor.getLocalVersion(context);
        return version > 0 && version == 5;
    }

    public static boolean decompressLibrary(Context context) {
        String libDir = context.getDir("xwalkcore", 0).toString();
        long start = System.currentTimeMillis();
        boolean success = XWalkLibraryDecompressor.decompress(context, libDir);
        long end = System.currentTimeMillis();
        Log.d((String)TAG, (String)("Decompress library cost: " + (end - start) + " milliseconds."));
        if (success) {
            XWalkLibraryDecompressor.setLocalVersion(context, 5);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean decompress(Context context, String libDir) {
        File f = new File(libDir);
        if (f.exists() && f.isFile()) {
            f.delete();
        }
        if (!f.exists() && !f.mkdirs()) {
            return false;
        }
        for (String library : MANDATORY_LIBRARIES) {
            File tmpfile = null;
            InputStream input = null;
            OutputStream output = null;
            try {
                File outfile = new File(libDir, library);
                tmpfile = new File(libDir, library + ".tmp");
                input = new BufferedInputStream(XWalkLibraryDecompressor.openRawResource(context, library));
                output = new BufferedOutputStream(new FileOutputStream(tmpfile));
                XWalkLibraryDecompressor.decodeWithLzma(input, output);
                tmpfile.renameTo(outfile);
            }
            catch (Resources.NotFoundException e) {
                Log.d((String)TAG, (String)("Could not find resource: " + e.getMessage()));
                boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                Log.d((String)TAG, (String)("Decompress failed: " + e.getMessage()));
                boolean bl = false;
                return bl;
            }
            finally {
                if (output != null) {
                    try {
                        output.flush();
                    }
                    catch (IOException iOException) {}
                    try {
                        output.close();
                    }
                    catch (IOException iOException) {}
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
                tmpfile.delete();
            }
        }
        return true;
    }

    private static void decodeWithLzma(InputStream input, OutputStream output) throws IOException {
        int propSize = 5;
        int outSizeLength = 8;
        byte[] properties = new byte[5];
        if (input.read(properties, 0, 5) != 5) {
            throw new EOFException("Input .lzma file is too short");
        }
        Decoder decoder = new Decoder();
        if (!decoder.SetDecoderProperties(properties)) {
            Log.w((String)TAG, (String)"Incorrect stream properties");
        }
        long outSize = 0L;
        for (int i = 0; i < 8; ++i) {
            int v = input.read();
            if (v < 0) {
                Log.w((String)TAG, (String)"Can't read stream size");
            }
            outSize |= (long)v << 8 * i;
        }
        if (!decoder.Code(input, output, outSize)) {
            Log.w((String)TAG, (String)"Error in data stream");
        }
    }

    private static InputStream openRawResource(Context context, String library) throws Resources.NotFoundException {
        Resources res = context.getResources();
        String libraryName = library.split("\\.")[0];
        int id2 = res.getIdentifier(libraryName, "raw", context.getPackageName());
        return res.openRawResource(id2);
    }

    private static int getLocalVersion(Context context) {
        SharedPreferences sp = context.getSharedPreferences("libxwalkcore", 0);
        return sp.getInt("version", 0);
    }

    private static void setLocalVersion(Context context, int version) {
        SharedPreferences sp = context.getSharedPreferences("libxwalkcore", 0);
        sp.edit().putInt("version", version).apply();
    }
}

