/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core;

import android.app.Activity;
import android.app.DownloadManager;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Environment;
import android.util.Log;
import junit.framework.Assert;
import org.xwalk.core.XWalkCoreWrapper;
import org.xwalk.core.XWalkLibraryDecompressor;

class XWalkLibraryLoader {
    private static final String XWALK_APK_NAME = "XWalkRuntimeLib.apk";
    private static final String TAG = "XWalkLib";
    private static AsyncTask<Void, Integer, Integer> sActiveTask;

    XWalkLibraryLoader() {
    }

    public static boolean isSharedLibrary() {
        return XWalkCoreWrapper.getInstance().isSharedMode();
    }

    public static boolean isLibraryReady() {
        return XWalkCoreWrapper.getInstance() != null;
    }

    public static int getLibraryStatus() {
        return XWalkCoreWrapper.getCoreStatus();
    }

    public static void prepareToInit(Activity activity) {
        XWalkCoreWrapper.handlePreInit(activity.getClass().getName());
    }

    public static void startDecompress(DecompressListener listener, Context context) {
        new DecompressTask(listener, context).execute(new Void[0]);
    }

    public static boolean cancelDecompress() {
        DecompressTask task = (DecompressTask)sActiveTask;
        return task != null && task.cancel(true);
    }

    public static void startActivate(ActivateListener listener, Activity activity) {
        new ActivateTask(listener, activity).execute(new Void[0]);
    }

    public static void startDownload(DownloadListener listener, Context context, String url) {
        new DownloadTask(listener, context, url).execute(new Void[0]);
    }

    public static boolean cancelDownload() {
        DownloadTask task = (DownloadTask)sActiveTask;
        return task != null && task.cancel(true);
    }

    private static class DownloadTask
    extends AsyncTask<Void, Integer, Integer> {
        private static final int QUERY_INTERVAL_MS = 100;
        private static final int MAX_PAUSED_COUNT = 6000;
        private DownloadListener mListener;
        private String mDownloadUrl;
        private DownloadManager mDownloadManager;
        private long mDownloadId;

        DownloadTask(DownloadListener listener, Context context, String url) {
            this.mListener = listener;
            this.mDownloadUrl = url;
            this.mDownloadManager = (DownloadManager)context.getSystemService("download");
        }

        protected void onPreExecute() {
            Log.d((String)XWalkLibraryLoader.TAG, (String)("DownloadTask started, " + this.mDownloadUrl));
            sActiveTask = this;
            DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)this.mDownloadUrl));
            request.setDestinationInExternalPublicDir(Environment.DIRECTORY_DOWNLOADS, XWalkLibraryLoader.XWALK_APK_NAME);
            this.mDownloadId = this.mDownloadManager.enqueue(request);
            this.mListener.onDownloadStarted();
        }

        protected Integer doInBackground(Void ... params) {
            DownloadManager.Query query = new DownloadManager.Query().setFilterById(new long[]{this.mDownloadId});
            int pausedCount = 0;
            while (!this.isCancelled()) {
                int statusIdx;
                int status;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    break;
                }
                Cursor cursor = this.mDownloadManager.query(query);
                if (cursor == null || !cursor.moveToFirst()) continue;
                int totalIdx = cursor.getColumnIndex("total_size");
                int downloadIdx = cursor.getColumnIndex("bytes_so_far");
                int totalSize = cursor.getInt(totalIdx);
                int downloadSize = cursor.getInt(downloadIdx);
                if (totalSize > 0) {
                    this.publishProgress(new Integer[]{downloadSize, totalSize});
                }
                if ((status = cursor.getInt(statusIdx = cursor.getColumnIndex("status"))) == 16 || status == 8) {
                    return status;
                }
                if (status != 4 || ++pausedCount != 6000) continue;
                return status;
            }
            return 2;
        }

        protected void onProgressUpdate(Integer ... progress) {
            Log.d((String)XWalkLibraryLoader.TAG, (String)("DownloadTask updated: " + progress[0] + "/" + progress[1]));
            int percentage = 0;
            if (progress[1] > 0) {
                percentage = (int)((double)progress[0].intValue() * 100.0 / (double)progress[1].intValue());
            }
            this.mListener.onDownloadUpdated(percentage);
        }

        protected void onCancelled(Integer result) {
            this.mDownloadManager.remove(new long[]{this.mDownloadId});
            Log.d((String)XWalkLibraryLoader.TAG, (String)"DownloadTask cancelled");
            sActiveTask = null;
            this.mListener.onDownloadCancelled();
        }

        protected void onPostExecute(Integer result) {
            Log.d((String)XWalkLibraryLoader.TAG, (String)("DownloadTask finished, " + result));
            sActiveTask = null;
            if (result == 8) {
                Uri uri = this.mDownloadManager.getUriForDownloadedFile(this.mDownloadId);
                this.mListener.onDownloadCompleted(uri);
            } else {
                DownloadManager.Query query;
                Cursor cursor;
                int error = -1;
                if (result == 16 && (cursor = this.mDownloadManager.query(query = new DownloadManager.Query().setFilterById(new long[]{this.mDownloadId}))) != null && cursor.moveToFirst()) {
                    int reasonIdx = cursor.getColumnIndex("reason");
                    error = cursor.getInt(reasonIdx);
                }
                this.mListener.onDownloadFailed(result, error);
            }
        }
    }

    private static class ActivateTask
    extends AsyncTask<Void, Integer, Integer> {
        ActivateListener mListener;
        Activity mActivity;

        ActivateTask(ActivateListener listener, Activity activity) {
            this.mListener = listener;
            this.mActivity = activity;
        }

        protected void onPreExecute() {
            Log.d((String)XWalkLibraryLoader.TAG, (String)"ActivateTask started");
            sActiveTask = this;
            this.mListener.onActivateStarted();
        }

        protected Integer doInBackground(Void ... params) {
            if (XWalkCoreWrapper.getInstance() != null) {
                return -1;
            }
            return XWalkCoreWrapper.attachXWalkCore((Context)this.mActivity);
        }

        protected void onPostExecute(Integer result) {
            if (result == 1) {
                XWalkCoreWrapper.dockXWalkCore();
            }
            if (XWalkCoreWrapper.getInstance() != null) {
                XWalkCoreWrapper.handlePostInit(this.mActivity.getClass().getName());
            }
            Log.d((String)XWalkLibraryLoader.TAG, (String)("ActivateTask finished, " + result));
            sActiveTask = null;
            if (result > 1) {
                this.mListener.onActivateFailed();
            } else {
                this.mListener.onActivateCompleted();
            }
        }
    }

    private static class DecompressTask
    extends AsyncTask<Void, Integer, Integer> {
        DecompressListener mListener;
        Context mContext;
        boolean mIsCompressed;
        boolean mIsDecompressed;

        DecompressTask(DecompressListener listener, Context context) {
            this.mListener = listener;
            this.mContext = context;
        }

        protected void onPreExecute() {
            Log.d((String)XWalkLibraryLoader.TAG, (String)"DecompressTask started");
            sActiveTask = this;
            this.mIsCompressed = XWalkLibraryDecompressor.isCompressed(this.mContext);
            if (this.mIsCompressed) {
                this.mIsDecompressed = XWalkLibraryDecompressor.isDecompressed(this.mContext);
            }
            if (this.mIsCompressed && !this.mIsDecompressed) {
                this.mListener.onDecompressStarted();
            }
        }

        protected Integer doInBackground(Void ... params) {
            if (!this.mIsCompressed || this.mIsDecompressed) {
                return 0;
            }
            if (!XWalkLibraryDecompressor.decompressLibrary(this.mContext)) {
                return 1;
            }
            return 0;
        }

        protected void onCancelled(Integer result) {
            Log.d((String)XWalkLibraryLoader.TAG, (String)"DecompressTask cancelled");
            sActiveTask = null;
            this.mListener.onDecompressCancelled();
        }

        protected void onPostExecute(Integer result) {
            Log.d((String)XWalkLibraryLoader.TAG, (String)("DecompressTask finished, " + result));
            Assert.assertEquals((int)result, (int)0);
            sActiveTask = null;
            this.mListener.onDecompressCompleted();
        }
    }

    public static interface DownloadListener {
        public void onDownloadStarted();

        public void onDownloadUpdated(int var1);

        public void onDownloadCancelled();

        public void onDownloadCompleted(Uri var1);

        public void onDownloadFailed(int var1, int var2);
    }

    public static interface ActivateListener {
        public void onActivateStarted();

        public void onActivateFailed();

        public void onActivateCompleted();
    }

    public static interface DecompressListener {
        public void onDecompressStarted();

        public void onDecompressCancelled();

        public void onDecompressCompleted();
    }
}

