/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core;

import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.util.TypedValue;

class XWalkMixedResources
extends Resources {
    private Resources mLibraryResource;

    private boolean isCalledInLibrary() {
        StackTraceElement[] stacks;
        for (StackTraceElement stack : stacks = Thread.currentThread().getStackTrace()) {
            String className = stack.getClassName();
            if (className.startsWith("org.chromium") || className.startsWith("org.xwalk.core.internal")) {
                return true;
            }
            if (!className.startsWith("org.xwalk.core") || className.endsWith("XWalkMixedResources")) continue;
            return false;
        }
        return false;
    }

    XWalkMixedResources(Resources base, Resources libraryResources) {
        super(base.getAssets(), base.getDisplayMetrics(), base.getConfiguration());
        this.mLibraryResource = libraryResources;
    }

    public CharSequence getText(int id2) throws Resources.NotFoundException {
        boolean calledInLibrary = this.isCalledInLibrary();
        try {
            if (calledInLibrary) {
                return this.mLibraryResource.getText(id2);
            }
            return super.getText(id2);
        }
        catch (Resources.NotFoundException e) {
            if (calledInLibrary) {
                return super.getText(id2);
            }
            return this.mLibraryResource.getText(id2);
        }
    }

    public XmlResourceParser getLayout(int id2) throws Resources.NotFoundException {
        boolean calledInLibrary = this.isCalledInLibrary();
        try {
            if (calledInLibrary) {
                return this.mLibraryResource.getLayout(id2);
            }
            return super.getLayout(id2);
        }
        catch (Resources.NotFoundException e) {
            if (calledInLibrary) {
                return super.getLayout(id2);
            }
            return this.mLibraryResource.getLayout(id2);
        }
    }

    public void getValue(int id2, TypedValue outValue, boolean resolveRefs) {
        boolean calledInLibrary = this.isCalledInLibrary();
        try {
            if (calledInLibrary) {
                this.mLibraryResource.getValue(id2, outValue, resolveRefs);
            } else {
                super.getValue(id2, outValue, resolveRefs);
            }
        }
        catch (Resources.NotFoundException e) {
            if (calledInLibrary) {
                super.getValue(id2, outValue, resolveRefs);
            }
            this.mLibraryResource.getValue(id2, outValue, resolveRefs);
        }
    }

    public void getValueForDensity(int id2, int density, TypedValue outValue, boolean resolveRefs) {
        boolean calledInLibrary = this.isCalledInLibrary();
        try {
            if (calledInLibrary) {
                this.mLibraryResource.getValueForDensity(id2, density, outValue, resolveRefs);
            } else {
                super.getValueForDensity(id2, density, outValue, resolveRefs);
            }
        }
        catch (Resources.NotFoundException e) {
            if (calledInLibrary) {
                super.getValueForDensity(id2, density, outValue, resolveRefs);
            }
            this.mLibraryResource.getValueForDensity(id2, density, outValue, resolveRefs);
        }
    }

    public int getIdentifier(String name, String defType, String defPackage) {
        boolean calledInLibrary = this.isCalledInLibrary();
        if (calledInLibrary) {
            int id2 = this.mLibraryResource.getIdentifier(name, defType, defPackage);
            return id2 != 0 ? id2 : super.getIdentifier(name, defType, defPackage);
        }
        int id3 = super.getIdentifier(name, defType, defPackage);
        return id3 != 0 ? id3 : this.mLibraryResource.getIdentifier(name, defType, defPackage);
    }

    public Drawable getDrawable(int id2) {
        boolean calledInLibrary = this.isCalledInLibrary();
        try {
            if (calledInLibrary) {
                return this.mLibraryResource.getDrawable(id2);
            }
            return super.getDrawable(id2);
        }
        catch (Resources.NotFoundException e) {
            if (calledInLibrary) {
                return super.getDrawable(id2);
            }
            return this.mLibraryResource.getDrawable(id2);
        }
    }
}

