/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core;

import org.xwalk.core.ReflectMethod;
import org.xwalk.core.XWalkCoreWrapper;

public class XWalkPreferences {
    public static final String REMOTE_DEBUGGING = "remote-debugging";
    public static final String ANIMATABLE_XWALK_VIEW = "animatable-xwalk-view";
    public static final String JAVASCRIPT_CAN_OPEN_WINDOW = "javascript-can-open-window";
    public static final String ALLOW_UNIVERSAL_ACCESS_FROM_FILE = "allow-universal-access-from-file";
    public static final String SUPPORT_MULTIPLE_WINDOWS = "support-multiple-windows";
    public static final String PROFILE_NAME = "profile-name";
    private static XWalkCoreWrapper coreWrapper;
    private static ReflectMethod setValueStringbooleanMethod;
    private static ReflectMethod setValueStringintMethod;
    private static ReflectMethod setValueStringStringMethod;
    private static ReflectMethod getValueStringMethod;
    private static ReflectMethod getBooleanValueStringMethod;
    private static ReflectMethod getIntegerValueStringMethod;
    private static ReflectMethod getStringValueStringMethod;

    public static void setValue(String key, boolean enabled) {
        XWalkPreferences.reflectionInit();
        if (setValueStringbooleanMethod.isNull()) {
            setValueStringbooleanMethod.setArguments(key, enabled);
            XWalkCoreWrapper.reserveReflectMethod(setValueStringbooleanMethod);
            return;
        }
        setValueStringbooleanMethod.invoke(key, enabled);
    }

    public static void setValue(String key, int value) {
        XWalkPreferences.reflectionInit();
        if (setValueStringintMethod.isNull()) {
            setValueStringintMethod.setArguments(key, value);
            XWalkCoreWrapper.reserveReflectMethod(setValueStringintMethod);
            return;
        }
        setValueStringintMethod.invoke(key, value);
    }

    public static void setValue(String key, String value) {
        XWalkPreferences.reflectionInit();
        if (setValueStringStringMethod.isNull()) {
            setValueStringStringMethod.setArguments(key, value);
            XWalkCoreWrapper.reserveReflectMethod(setValueStringStringMethod);
            return;
        }
        setValueStringStringMethod.invoke(key, value);
    }

    public static boolean getValue(String key) {
        XWalkPreferences.reflectionInit();
        return (Boolean)getValueStringMethod.invoke(key);
    }

    public static boolean getBooleanValue(String key) {
        XWalkPreferences.reflectionInit();
        return (Boolean)getBooleanValueStringMethod.invoke(key);
    }

    public static int getIntegerValue(String key) {
        XWalkPreferences.reflectionInit();
        return (Integer)getIntegerValueStringMethod.invoke(key);
    }

    public static String getStringValue(String key) {
        XWalkPreferences.reflectionInit();
        return (String)getStringValueStringMethod.invoke(key);
    }

    static void reflectionInit() {
        if (coreWrapper != null) {
            return;
        }
        XWalkCoreWrapper.initEmbeddedMode();
        coreWrapper = XWalkCoreWrapper.getInstance();
        if (coreWrapper == null) {
            XWalkCoreWrapper.reserveReflectClass(XWalkPreferences.class);
            return;
        }
        Class<?> bridgeClass = coreWrapper.getBridgeClass("XWalkPreferencesBridge");
        setValueStringbooleanMethod.init(null, bridgeClass, "setValue", String.class, Boolean.TYPE);
        setValueStringintMethod.init(null, bridgeClass, "setValue", String.class, Integer.TYPE);
        setValueStringStringMethod.init(null, bridgeClass, "setValue", String.class, String.class);
        getValueStringMethod.init(null, bridgeClass, "getValue", String.class);
        getBooleanValueStringMethod.init(null, bridgeClass, "getBooleanValue", String.class);
        getIntegerValueStringMethod.init(null, bridgeClass, "getIntegerValue", String.class);
        getStringValueStringMethod.init(null, bridgeClass, "getStringValue", String.class);
    }

    static {
        setValueStringbooleanMethod = new ReflectMethod(null, "setValue", new Class[0]);
        setValueStringintMethod = new ReflectMethod(null, "setValue", new Class[0]);
        setValueStringStringMethod = new ReflectMethod(null, "setValue", new Class[0]);
        getValueStringMethod = new ReflectMethod(null, "getValue", new Class[0]);
        getBooleanValueStringMethod = new ReflectMethod(null, "getBooleanValue", new Class[0]);
        getIntegerValueStringMethod = new ReflectMethod(null, "getIntegerValue", new Class[0]);
        getStringValueStringMethod = new ReflectMethod(null, "getStringValue", new Class[0]);
    }
}

