/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.util.Log;
import org.xwalk.core.XWalkDialogManager;
import org.xwalk.core.XWalkLibraryLoader;

public class XWalkUpdater {
    private static final String XWALK_APK_MARKET_URL = "market://details?id=org.xwalk.core";
    private static final String TAG = "XWalkActivity";
    private XWalkUpdateListener mUpdateListener;
    private Activity mActivity;
    private XWalkDialogManager mDialogManager;
    private Runnable mDownloadCommand;
    private Runnable mCancelCommand;
    private String mXWalkApkUrl;

    public XWalkUpdater(XWalkUpdateListener listener, Activity activity) {
        this(listener, activity, new XWalkDialogManager((Context)activity));
    }

    XWalkUpdater(XWalkUpdateListener listener, Activity activity, XWalkDialogManager dialogManager) {
        this.mUpdateListener = listener;
        this.mActivity = activity;
        this.mDialogManager = dialogManager;
        this.mDownloadCommand = new Runnable(){

            @Override
            public void run() {
                XWalkUpdater.this.downloadXWalkApk();
            }
        };
        this.mCancelCommand = new Runnable(){

            @Override
            public void run() {
                Log.d((String)XWalkUpdater.TAG, (String)"XWalkUpdater cancelled");
                XWalkUpdater.this.mUpdateListener.onXWalkUpdateCancelled();
            }
        };
    }

    public boolean updateXWalkRuntime() {
        if (this.mDialogManager.isShowingDialog()) {
            return false;
        }
        int status = XWalkLibraryLoader.getLibraryStatus();
        if (status == 0 || status == 1) {
            return false;
        }
        Log.d((String)TAG, (String)("Update the Crosswalk runtime with status " + status));
        this.mDialogManager.showInitializationError(status, this.mCancelCommand, this.mDownloadCommand);
        return true;
    }

    public boolean dismissDialog() {
        if (!this.mDialogManager.isShowingDialog()) {
            return false;
        }
        this.mDialogManager.dismissDialog();
        return true;
    }

    public void setXWalkApkUrl(String url) {
        this.mXWalkApkUrl = url;
    }

    private void downloadXWalkApk() {
        String downloadUrl = this.getXWalkApkUrl();
        if (!downloadUrl.isEmpty()) {
            XWalkLibraryLoader.startDownload(new XWalkLibraryListener(), (Context)this.mActivity, downloadUrl);
            return;
        }
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            this.mActivity.startActivity(intent.setData(Uri.parse((String)XWALK_APK_MARKET_URL)));
            Log.d((String)TAG, (String)"Market opened");
            this.mDialogManager.dismissDialog();
        }
        catch (ActivityNotFoundException e) {
            Log.d((String)TAG, (String)"Market open failed");
            this.mDialogManager.showMarketOpenError(this.mCancelCommand);
        }
    }

    private String getXWalkApkUrl() {
        if (this.mXWalkApkUrl != null) {
            return this.mXWalkApkUrl;
        }
        try {
            PackageManager packageManager = this.mActivity.getPackageManager();
            ApplicationInfo appInfo = packageManager.getApplicationInfo(this.mActivity.getPackageName(), 128);
            this.mXWalkApkUrl = appInfo.metaData.getString("xwalk_apk_url");
        }
        catch (PackageManager.NameNotFoundException | NullPointerException throwable) {
            // empty catch block
        }
        if (this.mXWalkApkUrl == null) {
            this.mXWalkApkUrl = "";
        }
        Log.d((String)TAG, (String)("Crosswalk APK download URL: " + this.mXWalkApkUrl));
        return this.mXWalkApkUrl;
    }

    private class XWalkLibraryListener
    implements XWalkLibraryLoader.DownloadListener {
        private XWalkLibraryListener() {
        }

        @Override
        public void onDownloadStarted() {
            XWalkUpdater.this.mDialogManager.showDownloadProgress(new Runnable(){

                @Override
                public void run() {
                    XWalkLibraryLoader.cancelDownload();
                }
            });
        }

        @Override
        public void onDownloadUpdated(int percentage) {
            XWalkUpdater.this.mDialogManager.setProgress(percentage, 100);
        }

        @Override
        public void onDownloadCancelled() {
            XWalkUpdater.this.mUpdateListener.onXWalkUpdateCancelled();
        }

        @Override
        public void onDownloadCompleted(Uri uri) {
            XWalkUpdater.this.mDialogManager.dismissDialog();
            Log.d((String)XWalkUpdater.TAG, (String)("Install the Crosswalk runtime: " + uri.toString()));
            Intent install = new Intent("android.intent.action.VIEW");
            install.setDataAndType(uri, "application/vnd.android.package-archive");
            XWalkUpdater.this.mActivity.startActivity(install);
        }

        @Override
        public void onDownloadFailed(int status, int error) {
            XWalkUpdater.this.mDialogManager.dismissDialog();
            XWalkUpdater.this.mDialogManager.showDownloadError(status, error, XWalkUpdater.this.mCancelCommand, XWalkUpdater.this.mDownloadCommand);
        }
    }

    public static interface XWalkUpdateListener {
        public void onXWalkUpdateCancelled();
    }
}

