/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import org.xwalk.core.internal.ClientCertRequestHandlerInternal;
import org.xwalk.core.internal.ReflectConstructor;
import org.xwalk.core.internal.ReflectMethod;
import org.xwalk.core.internal.XWalkCoreBridge;

public class ClientCertRequestHandlerBridge
extends ClientCertRequestHandlerInternal {
    private XWalkCoreBridge coreBridge;
    private Object wrapper;
    private ClientCertRequestHandlerInternal internal;
    private ReflectMethod proceedPrivateKeyListMethod = new ReflectMethod(null, "proceed", new Class[0]);
    private ReflectMethod ignoreMethod = new ReflectMethod(null, "ignore", new Class[0]);
    private ReflectMethod cancelMethod = new ReflectMethod(null, "cancel", new Class[0]);
    private ReflectMethod getHostMethod = new ReflectMethod(null, "getHost", new Class[0]);
    private ReflectMethod getPortMethod = new ReflectMethod(null, "getPort", new Class[0]);

    public Object getWrapper() {
        return this.wrapper;
    }

    ClientCertRequestHandlerBridge(ClientCertRequestHandlerInternal internal) {
        this.internal = internal;
        this.reflectionInit();
    }

    @Override
    public void proceed(PrivateKey privateKey, List<X509Certificate> chain) {
        if (this.proceedPrivateKeyListMethod.isNull()) {
            this.proceedSuper(privateKey, chain);
        } else {
            this.proceedPrivateKeyListMethod.invoke(privateKey, chain);
        }
    }

    public void proceedSuper(PrivateKey privateKey, List<X509Certificate> chain) {
        if (this.internal == null) {
            super.proceed(privateKey, chain);
        } else {
            this.internal.proceed(privateKey, chain);
        }
    }

    @Override
    public void ignore() {
        if (this.ignoreMethod.isNull()) {
            this.ignoreSuper();
        } else {
            this.ignoreMethod.invoke(new Object[0]);
        }
    }

    public void ignoreSuper() {
        if (this.internal == null) {
            super.ignore();
        } else {
            this.internal.ignore();
        }
    }

    @Override
    public void cancel() {
        if (this.cancelMethod.isNull()) {
            this.cancelSuper();
        } else {
            this.cancelMethod.invoke(new Object[0]);
        }
    }

    public void cancelSuper() {
        if (this.internal == null) {
            super.cancel();
        } else {
            this.internal.cancel();
        }
    }

    @Override
    public String getHost() {
        if (this.getHostMethod.isNull()) {
            return this.getHostSuper();
        }
        return (String)this.getHostMethod.invoke(new Object[0]);
    }

    public String getHostSuper() {
        String ret = this.internal == null ? super.getHost() : this.internal.getHost();
        if (ret == null) {
            return null;
        }
        return ret;
    }

    @Override
    public int getPort() {
        if (this.getPortMethod.isNull()) {
            return this.getPortSuper();
        }
        return (Integer)this.getPortMethod.invoke(new Object[0]);
    }

    public int getPortSuper() {
        int ret = this.internal == null ? super.getPort() : this.internal.getPort();
        return ret;
    }

    void reflectionInit() {
        this.coreBridge = XWalkCoreBridge.getInstance();
        if (this.coreBridge == null) {
            return;
        }
        ReflectConstructor constructor = new ReflectConstructor(this.coreBridge.getWrapperClass("ClientCertRequestHandler"), Object.class);
        if (constructor.isNull()) {
            return;
        }
        this.wrapper = constructor.newInstance(this);
        this.proceedPrivateKeyListMethod.init(this.wrapper, null, "proceed", PrivateKey.class, List.class);
        this.ignoreMethod.init(this.wrapper, null, "ignore", new Class[0]);
        this.cancelMethod.init(this.wrapper, null, "cancel", new Class[0]);
        this.getHostMethod.init(this.wrapper, null, "getHost", new Class[0]);
        this.getPortMethod.init(this.wrapper, null, "getPort", new Class[0]);
    }
}

