/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import android.util.Log;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.List;
import org.chromium.base.ThreadUtils;
import org.chromium.net.AndroidPrivateKey;
import org.xwalk.core.internal.ClientCertRequestInternal;
import org.xwalk.core.internal.XWalkAPI;
import org.xwalk.core.internal.XWalkContentsClientBridge;

@XWalkAPI(impl=ClientCertRequestInternal.class, createInternally=true)
public class ClientCertRequestHandlerInternal
implements ClientCertRequestInternal {
    private static final String TAG = "ClientCertRequestHandlerInternal";
    private XWalkContentsClientBridge mContentsClient;
    private int mId;
    private String mHost;
    private int mPort;
    private boolean mIsCalled;

    ClientCertRequestHandlerInternal(XWalkContentsClientBridge contentsClient, int id2, String host, int port) {
        this.mId = id2;
        this.mHost = host;
        this.mPort = port;
        this.mContentsClient = contentsClient;
    }

    ClientCertRequestHandlerInternal() {
        this.mId = -1;
        this.mHost = "";
        this.mPort = -1;
        this.mContentsClient = null;
    }

    @Override
    @XWalkAPI
    public void proceed(final PrivateKey privateKey, final List<X509Certificate> chain) {
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                X509Certificate[] chains = null;
                if (chain != null) {
                    chains = chain.toArray(new X509Certificate[chain.size()]);
                }
                ClientCertRequestHandlerInternal.this.proceedOnUiThread(privateKey, chains);
            }
        });
    }

    @Override
    @XWalkAPI
    public void ignore() {
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ClientCertRequestHandlerInternal.this.ignoreOnUiThread();
            }
        });
    }

    @Override
    @XWalkAPI
    public void cancel() {
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ClientCertRequestHandlerInternal.this.cancelOnUiThread();
            }
        });
    }

    @Override
    @XWalkAPI
    public String getHost() {
        return this.mHost;
    }

    @Override
    @XWalkAPI
    public int getPort() {
        return this.mPort;
    }

    private void proceedOnUiThread(PrivateKey privateKey, X509Certificate[] chain) {
        this.checkIfCalled();
        AndroidPrivateKey key = this.mContentsClient.mLocalKeyStore.createKey(privateKey);
        if (key == null || chain == null || chain.length == 0) {
            Log.w((String)TAG, (String)"Empty client certificate chain?");
            this.provideResponse(null, null);
            return;
        }
        byte[][] encodedChain = new byte[chain.length][];
        try {
            for (int i = 0; i < chain.length; ++i) {
                encodedChain[i] = chain[i].getEncoded();
            }
        }
        catch (CertificateEncodingException e) {
            Log.w((String)TAG, (String)("Could not retrieve encoded certificate chain: " + e));
            this.provideResponse(null, null);
            return;
        }
        this.mContentsClient.mLookupTable.allow(this.mHost, this.mPort, key, encodedChain);
        this.provideResponse(key, encodedChain);
    }

    private void ignoreOnUiThread() {
        this.checkIfCalled();
        this.provideResponse(null, null);
    }

    private void cancelOnUiThread() {
        this.checkIfCalled();
        this.mContentsClient.mLookupTable.deny(this.mHost, this.mPort);
        this.provideResponse(null, null);
    }

    private void checkIfCalled() {
        if (this.mIsCalled) {
            throw new IllegalStateException("The callback was already called.");
        }
        this.mIsCalled = true;
    }

    private void provideResponse(AndroidPrivateKey androidKey, byte[][] certChain) {
        this.mContentsClient.provideClientCertificateResponse(this.mId, certChain, androidKey);
    }
}

