/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Base64;
import android.util.Log;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.webkit.ValueCallback;
import android.webkit.WebResourceResponse;
import android.widget.FrameLayout;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.util.Locale;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.base.ThreadUtils;
import org.chromium.components.navigation_interception.InterceptNavigationDelegate;
import org.chromium.content.browser.ContentViewCore;
import org.chromium.content.browser.ContentViewRenderView;
import org.chromium.content.browser.ContentViewStatics;
import org.chromium.content.common.CleanupReference;
import org.chromium.content_public.browser.JavaScriptCallback;
import org.chromium.content_public.browser.LoadUrlParams;
import org.chromium.content_public.browser.NavigationController;
import org.chromium.content_public.browser.NavigationHistory;
import org.chromium.content_public.browser.WebContents;
import org.chromium.media.MediaPlayerBridge;
import org.chromium.ui.base.ActivityWindowAndroid;
import org.chromium.ui.gfx.DeviceDisplayInfo;
import org.xwalk.core.internal.AndroidProtocolHandler;
import org.xwalk.core.internal.InMemorySharedPreferences;
import org.xwalk.core.internal.InterceptedRequestData;
import org.xwalk.core.internal.XWalkAutofillClient;
import org.xwalk.core.internal.XWalkClient;
import org.xwalk.core.internal.XWalkContentView;
import org.xwalk.core.internal.XWalkContentsClient;
import org.xwalk.core.internal.XWalkContentsClientBridge;
import org.xwalk.core.internal.XWalkContentsIoThreadClient;
import org.xwalk.core.internal.XWalkDevToolsServer;
import org.xwalk.core.internal.XWalkDownloadListenerInternal;
import org.xwalk.core.internal.XWalkGeolocationPermissions;
import org.xwalk.core.internal.XWalkLaunchScreenManager;
import org.xwalk.core.internal.XWalkMediaPlayerResourceLoadingFilter;
import org.xwalk.core.internal.XWalkNavigationHandler;
import org.xwalk.core.internal.XWalkNavigationHistoryInternal;
import org.xwalk.core.internal.XWalkNotificationService;
import org.xwalk.core.internal.XWalkPreferencesInternal;
import org.xwalk.core.internal.XWalkResourceClientInternal;
import org.xwalk.core.internal.XWalkSettings;
import org.xwalk.core.internal.XWalkUIClientInternal;
import org.xwalk.core.internal.XWalkViewInternal;
import org.xwalk.core.internal.XWalkWebChromeClient;
import org.xwalk.core.internal.XWalkWebContentsDelegateAdapter;

@JNINamespace(value="xwalk")
class XWalkContent
implements XWalkPreferencesInternal.KeyValueChangeListener {
    private static String TAG = "XWalkContent";
    private static Class<? extends Annotation> javascriptInterfaceClass = null;
    private ContentViewCore mContentViewCore;
    private Context mViewContext;
    private XWalkContentView mContentView;
    private ContentViewRenderView mContentViewRenderView;
    private ActivityWindowAndroid mWindow;
    private XWalkDevToolsServer mDevToolsServer;
    private XWalkViewInternal mXWalkView;
    private XWalkContentsClientBridge mContentsClientBridge;
    private XWalkContentsIoThreadClient mIoThreadClient;
    private XWalkWebContentsDelegateAdapter mXWalkContentsDelegateAdapter;
    private XWalkSettings mSettings;
    private XWalkGeolocationPermissions mGeolocationPermissions;
    private XWalkLaunchScreenManager mLaunchScreenManager;
    private NavigationController mNavigationController;
    private WebContents mWebContents;
    private boolean mIsLoaded = false;
    private XWalkAutofillClient mXWalkAutofillClient;
    long mNativeContent;
    long mNativeWebContents;
    private double mDIPScale;
    private CleanupReference mCleanupReference;
    private static boolean timerPaused = false;
    public static final String SAVE_RESTORE_STATE_KEY = "XWALKVIEW_STATE";

    static void setJavascriptInterfaceClass(Class<? extends Annotation> clazz) {
        assert (javascriptInterfaceClass == null);
        javascriptInterfaceClass = clazz;
    }

    public XWalkContent(Context context, AttributeSet attrs, XWalkViewInternal xwView) {
        this.mXWalkView = xwView;
        this.mViewContext = this.mXWalkView.getContext();
        this.mContentsClientBridge = new XWalkContentsClientBridge(this.mXWalkView);
        this.mXWalkContentsDelegateAdapter = new XWalkWebContentsDelegateAdapter(this.mContentsClientBridge);
        this.mIoThreadClient = new XWalkIoThreadClientImpl();
        this.mWindow = new ActivityWindowAndroid(xwView.getActivity());
        InMemorySharedPreferences sharedPreferences = new InMemorySharedPreferences();
        this.mGeolocationPermissions = new XWalkGeolocationPermissions(sharedPreferences);
        MediaPlayerBridge.setResourceLoadingFilter(new XWalkMediaPlayerResourceLoadingFilter());
        this.setNativeContent(this.nativeInit());
        XWalkPreferencesInternal.load(this);
    }

    private void setNativeContent(long newNativeContent) {
        if (this.mNativeContent != 0L) {
            this.destroy();
            this.mContentViewCore = null;
        }
        assert (this.mNativeContent == 0L && this.mCleanupReference == null && this.mContentViewCore == null);
        boolean animated = XWalkPreferencesInternal.getValue("animatable-xwalk-view");
        ContentViewRenderView.CompositingSurfaceType surfaceType = animated ? ContentViewRenderView.CompositingSurfaceType.TEXTURE_VIEW : ContentViewRenderView.CompositingSurfaceType.SURFACE_VIEW;
        this.mContentViewRenderView = new ContentViewRenderView(this.mViewContext, surfaceType){

            @Override
            protected void onReadyToRender() {
            }
        };
        this.mContentViewRenderView.onNativeLibraryLoaded(this.mWindow);
        this.mLaunchScreenManager = new XWalkLaunchScreenManager(this.mViewContext, this.mXWalkView);
        this.mContentViewRenderView.registerFirstRenderedFrameListener(this.mLaunchScreenManager);
        this.mXWalkView.addView((View)this.mContentViewRenderView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mNativeContent = newNativeContent;
        this.mCleanupReference = new CleanupReference(this, new DestroyRunnable(this.mNativeContent));
        WebContents webContents = this.nativeGetWebContents(this.mNativeContent);
        this.mContentViewCore = new ContentViewCore(this.mViewContext);
        this.mContentView = new XWalkContentView(this.mViewContext, this.mContentViewCore, this.mXWalkView);
        this.mContentViewCore.initialize((ViewGroup)this.mContentView, this.mContentView, webContents, this.mWindow);
        this.mWebContents = this.mContentViewCore.getWebContents();
        this.mNavigationController = this.mWebContents.getNavigationController();
        this.mXWalkView.addView((View)this.mContentView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mContentViewCore.setContentViewClient(this.mContentsClientBridge);
        this.mContentViewRenderView.setCurrentContentViewCore(this.mContentViewCore);
        this.mContentsClientBridge.installWebContentsObserver(this.mWebContents);
        this.mSettings = new XWalkSettings(this.mViewContext, webContents, false);
        this.mSettings.setAllowFileAccessFromFileURLs(true);
        this.mDIPScale = DeviceDisplayInfo.create(this.mViewContext).getDIPScale();
        this.mContentsClientBridge.setDIPScale(this.mDIPScale);
        this.mSettings.setDIPScale(this.mDIPScale);
        this.mContentViewCore.setDownloadDelegate(this.mContentsClientBridge);
        String language = Locale.getDefault().toString().replaceAll("_", "-").toLowerCase();
        if (language.isEmpty()) {
            language = "en";
        }
        this.mSettings.setAcceptLanguages(language);
        this.nativeSetJavaPeers(this.mNativeContent, this, this.mXWalkContentsDelegateAdapter, this.mContentsClientBridge, this.mIoThreadClient, this.mContentsClientBridge.getInterceptNavigationDelegate());
    }

    public void supplyContentsForPopup(XWalkContent newContents) {
        if (this.mNativeContent == 0L) {
            return;
        }
        long popupNativeXWalkContent = this.nativeReleasePopupXWalkContent(this.mNativeContent);
        if (popupNativeXWalkContent == 0L) {
            Log.w((String)TAG, (String)"Popup XWalkView bind failed: no pending content.");
            if (newContents != null) {
                newContents.destroy();
            }
            return;
        }
        if (newContents == null) {
            XWalkContent.nativeDestroy(popupNativeXWalkContent);
            return;
        }
        newContents.receivePopupContents(popupNativeXWalkContent);
    }

    private void receivePopupContents(long popupNativeXWalkContents) {
        this.setNativeContent(popupNativeXWalkContents);
        this.mContentViewCore.onShow();
    }

    void doLoadUrl(String url, String content) {
        if (url != null && !url.isEmpty() && TextUtils.equals((CharSequence)url, (CharSequence)this.mWebContents.getUrl())) {
            this.mNavigationController.reload(true);
        } else {
            LoadUrlParams params = null;
            if (content == null || content.isEmpty()) {
                params = new LoadUrlParams(url);
            } else {
                try {
                    params = LoadUrlParams.createLoadDataParamsWithBaseUrl(Base64.encodeToString((byte[])content.getBytes("utf-8"), (int)0), "text/html", true, url, null, "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    Log.w((String)TAG, (String)("Unable to load data string " + content), (Throwable)e);
                    return;
                }
            }
            params.setOverrideUserAgent(2);
            this.mNavigationController.loadUrl(params);
        }
        this.mContentView.requestFocus();
    }

    public void loadUrl(String url, String data) {
        if (this.mNativeContent == 0L) {
            return;
        }
        if ((url == null || url.isEmpty()) && (data == null || data.isEmpty())) {
            return;
        }
        this.doLoadUrl(url, data);
        this.mIsLoaded = true;
    }

    public void reload(int mode) {
        if (this.mNativeContent == 0L) {
            return;
        }
        switch (mode) {
            case 1: {
                this.mNavigationController.reloadIgnoringCache(true);
                break;
            }
            default: {
                this.mNavigationController.reload(true);
            }
        }
        this.mIsLoaded = true;
    }

    public String getUrl() {
        if (this.mNativeContent == 0L) {
            return null;
        }
        String url = this.mWebContents.getUrl();
        if (url == null || url.trim().isEmpty()) {
            return null;
        }
        return url;
    }

    public String getTitle() {
        if (this.mNativeContent == 0L) {
            return null;
        }
        String title = this.mWebContents.getTitle().trim();
        if (title == null) {
            title = "";
        }
        return title;
    }

    public void addJavascriptInterface(Object object, String name) {
        if (this.mNativeContent == 0L) {
            return;
        }
        this.mContentViewCore.addPossiblyUnsafeJavascriptInterface(object, name, javascriptInterfaceClass);
    }

    public void evaluateJavascript(String script, ValueCallback<String> callback) {
        if (this.mNativeContent == 0L) {
            return;
        }
        final ValueCallback<String> fCallback = callback;
        JavaScriptCallback coreCallback = null;
        if (fCallback != null) {
            coreCallback = new JavaScriptCallback(){

                @Override
                public void handleJavaScriptResult(String jsonResult) {
                    fCallback.onReceiveValue((Object)jsonResult);
                }
            };
        }
        this.mContentViewCore.getWebContents().evaluateJavaScript(script, coreCallback);
    }

    public void setUIClient(XWalkUIClientInternal client) {
        if (this.mNativeContent == 0L) {
            return;
        }
        this.mContentsClientBridge.setUIClient(client);
    }

    public void setResourceClient(XWalkResourceClientInternal client) {
        if (this.mNativeContent == 0L) {
            return;
        }
        this.mContentsClientBridge.setResourceClient(client);
    }

    public void setXWalkWebChromeClient(XWalkWebChromeClient client) {
        if (this.mNativeContent == 0L) {
            return;
        }
        this.mContentsClientBridge.setXWalkWebChromeClient(client);
    }

    public XWalkWebChromeClient getXWalkWebChromeClient() {
        if (this.mNativeContent == 0L) {
            return null;
        }
        return this.mContentsClientBridge.getXWalkWebChromeClient();
    }

    public void setXWalkClient(XWalkClient client) {
        if (this.mNativeContent == 0L) {
            return;
        }
        this.mContentsClientBridge.setXWalkClient(client);
    }

    public void setDownloadListener(XWalkDownloadListenerInternal listener) {
        if (this.mNativeContent == 0L) {
            return;
        }
        this.mContentsClientBridge.setDownloadListener(listener);
    }

    public void setNavigationHandler(XWalkNavigationHandler handler) {
        if (this.mNativeContent == 0L) {
            return;
        }
        this.mContentsClientBridge.setNavigationHandler(handler);
    }

    public void setNotificationService(XWalkNotificationService service) {
        if (this.mNativeContent == 0L) {
            return;
        }
        this.mContentsClientBridge.setNotificationService(service);
    }

    public void onPause() {
        if (this.mNativeContent == 0L) {
            return;
        }
        this.mContentViewCore.onHide();
    }

    public void onResume() {
        if (this.mNativeContent == 0L) {
            return;
        }
        this.mContentViewCore.onShow();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.mNativeContent == 0L) {
            return;
        }
        this.mWindow.onActivityResult(requestCode, resultCode, data);
    }

    public boolean onNewIntent(Intent intent) {
        if (this.mNativeContent == 0L) {
            return false;
        }
        return this.mContentsClientBridge.onNewIntent(intent);
    }

    public void clearCache(boolean includeDiskFiles) {
        if (this.mNativeContent == 0L) {
            return;
        }
        this.nativeClearCache(this.mNativeContent, includeDiskFiles);
    }

    public void clearCacheForSingleFile(final String url) {
        if (this.mNativeContent == 0L) {
            return;
        }
        if (!this.mIsLoaded) {
            this.mXWalkView.post(new Runnable(){

                @Override
                public void run() {
                    XWalkContent.this.clearCacheForSingleFile(url);
                }
            });
            return;
        }
        this.nativeClearCacheForSingleFile(this.mNativeContent, url);
    }

    public void clearHistory() {
        if (this.mNativeContent == 0L) {
            return;
        }
        this.mNavigationController.clearHistory();
    }

    public boolean canGoBack() {
        return this.mNativeContent == 0L ? false : this.mNavigationController.canGoBack();
    }

    public void goBack() {
        if (this.mNativeContent == 0L) {
            return;
        }
        this.mNavigationController.goBack();
    }

    public boolean canGoForward() {
        return this.mNativeContent == 0L ? false : this.mNavigationController.canGoForward();
    }

    public void goForward() {
        if (this.mNativeContent == 0L) {
            return;
        }
        this.mNavigationController.goForward();
    }

    void navigateTo(int offset) {
        this.mNavigationController.goToOffset(offset);
    }

    public void stopLoading() {
        if (this.mNativeContent == 0L) {
            return;
        }
        this.mWebContents.stop();
        this.mContentsClientBridge.onStopLoading();
    }

    public void pauseTimers() {
        if (timerPaused || this.mNativeContent == 0L) {
            return;
        }
        ContentViewStatics.setWebKitSharedTimersSuspended(true);
        timerPaused = true;
    }

    public void resumeTimers() {
        if (!timerPaused || this.mNativeContent == 0L) {
            return;
        }
        ContentViewStatics.setWebKitSharedTimersSuspended(false);
        timerPaused = false;
    }

    public String getOriginalUrl() {
        if (this.mNativeContent == 0L) {
            return null;
        }
        NavigationHistory history = this.mNavigationController.getNavigationHistory();
        int currentIndex = history.getCurrentEntryIndex();
        if (currentIndex >= 0 && currentIndex < history.getEntryCount()) {
            return history.getEntryAtIndex(currentIndex).getOriginalUrl();
        }
        return null;
    }

    public String getXWalkVersion() {
        if (this.mNativeContent == 0L) {
            return "";
        }
        return this.nativeGetVersion(this.mNativeContent);
    }

    private boolean isOpaque(int color2) {
        return (color2 >> 24 & 0xFF) == 255;
    }

    @CalledByNative
    public void setBackgroundColor(final int color2) {
        if (this.mNativeContent == 0L) {
            return;
        }
        if (!this.mIsLoaded) {
            this.mXWalkView.post(new Runnable(){

                @Override
                public void run() {
                    XWalkContent.this.setBackgroundColor(color2);
                }
            });
            return;
        }
        if (!this.isOpaque(color2)) {
            this.setOverlayVideoMode(true);
            this.mContentViewRenderView.setSurfaceViewBackgroundColor(color2);
            this.mContentViewCore.setBackgroundOpaque(false);
        }
        this.nativeSetBackgroundColor(this.mNativeContent, color2);
    }

    public void setNetworkAvailable(boolean networkUp) {
        if (this.mNativeContent == 0L) {
            return;
        }
        this.nativeSetJsOnlineProperty(this.mNativeContent, networkUp);
    }

    public ContentViewCore getContentViewCoreForTest() {
        return this.mContentViewCore;
    }

    public void installWebContentsObserverForTest(XWalkContentsClient contentClient) {
        if (this.mNativeContent == 0L) {
            return;
        }
        contentClient.installWebContentsObserver(this.mContentViewCore.getWebContents());
    }

    public String devToolsAgentId() {
        if (this.mNativeContent == 0L) {
            return "";
        }
        return this.nativeDevToolsAgentId(this.mNativeContent);
    }

    public XWalkSettings getSettings() {
        return this.mSettings;
    }

    public void loadAppFromManifest(String url, String data) {
        if (this.mNativeContent == 0L || (url == null || url.isEmpty()) && (data == null || data.isEmpty())) {
            return;
        }
        String content = data;
        if (data == null || data.isEmpty()) {
            try {
                content = AndroidProtocolHandler.getUrlContent((Context)this.mXWalkView.getActivity(), url);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read the manifest: " + url);
            }
        }
        String baseUrl = url;
        int position = url.lastIndexOf("/");
        if (position != -1) {
            baseUrl = url.substring(0, position + 1);
        } else {
            Log.w((String)TAG, (String)"The url of manifest.json is probably not set correctly.");
        }
        if (!this.nativeSetManifest(this.mNativeContent, baseUrl, content)) {
            throw new RuntimeException("Failed to parse the manifest file: " + url);
        }
        this.mIsLoaded = true;
    }

    public XWalkNavigationHistoryInternal getNavigationHistory() {
        if (this.mNativeContent == 0L) {
            return null;
        }
        return new XWalkNavigationHistoryInternal(this.mXWalkView, this.mNavigationController.getNavigationHistory());
    }

    public XWalkNavigationHistoryInternal saveState(Bundle outState) {
        if (this.mNativeContent == 0L || outState == null) {
            return null;
        }
        byte[] state = this.nativeGetState(this.mNativeContent);
        if (state == null) {
            return null;
        }
        outState.putByteArray(SAVE_RESTORE_STATE_KEY, state);
        return this.getNavigationHistory();
    }

    public XWalkNavigationHistoryInternal restoreState(Bundle inState) {
        if (this.mNativeContent == 0L || inState == null) {
            return null;
        }
        byte[] state = inState.getByteArray(SAVE_RESTORE_STATE_KEY);
        if (state == null) {
            return null;
        }
        boolean result = this.nativeSetState(this.mNativeContent, state);
        if (result) {
            this.mContentsClientBridge.onUpdateTitle(this.mWebContents.getTitle());
        }
        return result ? this.getNavigationHistory() : null;
    }

    boolean hasEnteredFullscreen() {
        return this.mContentsClientBridge.hasEnteredFullscreen();
    }

    void exitFullscreen() {
        if (this.hasEnteredFullscreen()) {
            this.mContentsClientBridge.exitFullscreen(this.mNativeWebContents);
        }
    }

    @CalledByNative
    public void onGetUrlFromManifest(String url) {
        if (url != null && !url.isEmpty()) {
            this.loadUrl(url, null);
        }
    }

    @CalledByNative
    public void onGetUrlAndLaunchScreenFromManifest(String url, String readyWhen, String imageBorder) {
        if (url == null || url.isEmpty()) {
            return;
        }
        this.mLaunchScreenManager.displayLaunchScreen(readyWhen, imageBorder);
        this.mContentsClientBridge.registerPageLoadListener(this.mLaunchScreenManager);
        this.loadUrl(url, null);
    }

    @CalledByNative
    public void onGetFullscreenFlagFromManifest(boolean enterFullscreen) {
        if (enterFullscreen) {
            if (Build.VERSION.SDK_INT >= 19) {
                View decorView = this.mXWalkView.getActivity().getWindow().getDecorView();
                decorView.setSystemUiVisibility(5894);
            } else {
                this.mXWalkView.getActivity().getWindow().addFlags(1024);
            }
        }
    }

    public void destroy() {
        if (this.mNativeContent == 0L) {
            return;
        }
        XWalkPreferencesInternal.unload(this);
        this.setNotificationService(null);
        this.mXWalkView.removeView((View)this.mContentView);
        this.mXWalkView.removeView((View)this.mContentViewRenderView);
        this.mContentViewRenderView.setCurrentContentViewCore(null);
        this.mContentViewRenderView.destroy();
        this.mContentViewCore.destroy();
        this.mCleanupReference.cleanupNow();
        this.mCleanupReference = null;
        this.mNativeContent = 0L;
    }

    public int getRoutingID() {
        return this.nativeGetRoutingID(this.mNativeContent);
    }

    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        return this.mContentView.onCreateInputConnectionSuper(outAttrs);
    }

    public boolean onTouchEvent(MotionEvent event) {
        return this.mContentViewCore.onTouchEvent(event);
    }

    @CalledByNative
    private void onGeolocationPermissionsShowPrompt(String origin) {
        if (this.mNativeContent == 0L) {
            return;
        }
        if (!this.mSettings.getGeolocationEnabled()) {
            this.nativeInvokeGeolocationCallback(this.mNativeContent, false, origin);
            return;
        }
        if (this.mGeolocationPermissions.hasOrigin(origin)) {
            this.nativeInvokeGeolocationCallback(this.mNativeContent, this.mGeolocationPermissions.isOriginAllowed(origin), origin);
            return;
        }
        this.mContentsClientBridge.onGeolocationPermissionsShowPrompt(origin, new XWalkGeolocationCallback());
    }

    @CalledByNative
    public void onGeolocationPermissionsHidePrompt() {
        this.mContentsClientBridge.onGeolocationPermissionsHidePrompt();
    }

    public void enableRemoteDebugging() {
        String socketName = this.mViewContext.getApplicationContext().getPackageName() + "_devtools_remote";
        if (this.mDevToolsServer == null) {
            this.mDevToolsServer = new XWalkDevToolsServer(socketName);
            this.mDevToolsServer.setRemoteDebuggingEnabled(true, XWalkDevToolsServer.Security.ALLOW_SOCKET_ACCESS);
        }
    }

    void disableRemoteDebugging() {
        if (this.mDevToolsServer == null) {
            return;
        }
        if (this.mDevToolsServer.isRemoteDebuggingEnabled()) {
            this.mDevToolsServer.setRemoteDebuggingEnabled(false);
        }
        this.mDevToolsServer.destroy();
        this.mDevToolsServer = null;
    }

    public String getRemoteDebuggingUrl() {
        if (this.mDevToolsServer == null) {
            return "";
        }
        return "ws://" + this.mDevToolsServer.getSocketName() + "/devtools/page/" + this.devToolsAgentId();
    }

    @Override
    public void onKeyValueChanged(String key, XWalkPreferencesInternal.PreferenceValue value) {
        if (key == null) {
            return;
        }
        if (key.equals("remote-debugging")) {
            if (value.getBooleanValue()) {
                this.enableRemoteDebugging();
            } else {
                this.disableRemoteDebugging();
            }
        } else if (key.equals("enable-javascript")) {
            if (this.mSettings != null) {
                this.mSettings.setJavaScriptEnabled(value.getBooleanValue());
            }
        } else if (key.equals("javascript-can-open-window")) {
            if (this.mSettings != null) {
                this.mSettings.setJavaScriptCanOpenWindowsAutomatically(value.getBooleanValue());
            }
        } else if (key.equals("allow-universal-access-from-file")) {
            if (this.mSettings != null) {
                this.mSettings.setAllowUniversalAccessFromFileURLs(value.getBooleanValue());
            }
        } else if (key.equals("support-multiple-windows") && this.mSettings != null) {
            this.mSettings.setSupportMultipleWindows(value.getBooleanValue());
        }
    }

    public void setOverlayVideoMode(boolean enabled) {
        if (this.mContentViewRenderView != null) {
            this.mContentViewRenderView.setOverlayVideoMode(enabled);
        }
    }

    public void setZOrderOnTop(boolean onTop) {
        if (this.mContentViewRenderView == null) {
            return;
        }
        this.mContentViewRenderView.setZOrderOnTop(onTop);
    }

    public boolean zoomIn() {
        if (this.mNativeContent == 0L) {
            return false;
        }
        return this.mContentViewCore.zoomIn();
    }

    public boolean zoomOut() {
        if (this.mNativeContent == 0L) {
            return false;
        }
        return this.mContentViewCore.zoomOut();
    }

    public void zoomBy(float delta) {
        if (this.mNativeContent == 0L) {
            return;
        }
        if (delta < 0.01f || delta > 100.0f) {
            throw new IllegalStateException("zoom delta value outside [0.01, 100] range.");
        }
        this.mContentViewCore.pinchByDelta(delta);
    }

    public boolean canZoomIn() {
        if (this.mNativeContent == 0L) {
            return false;
        }
        return this.mContentViewCore.canZoomIn();
    }

    public boolean canZoomOut() {
        if (this.mNativeContent == 0L) {
            return false;
        }
        return this.mContentViewCore.canZoomOut();
    }

    public void hideAutofillPopup() {
        if (this.mNativeContent == 0L) {
            return;
        }
        if (!this.mIsLoaded) {
            this.mXWalkView.post(new Runnable(){

                @Override
                public void run() {
                    XWalkContent.this.hideAutofillPopup();
                }
            });
            return;
        }
        if (this.mXWalkAutofillClient != null) {
            this.mXWalkAutofillClient.hideAutofillPopup();
        }
    }

    public void setVisibility(int visibility) {
        SurfaceView surfaceView = this.mContentViewRenderView.getSurfaceView();
        if (surfaceView == null) {
            return;
        }
        surfaceView.setVisibility(visibility);
    }

    @CalledByNative
    private void setXWalkAutofillClient(XWalkAutofillClient client) {
        this.mXWalkAutofillClient = client;
        client.init(this.mContentViewCore);
    }

    private native long nativeInit();

    private static native void nativeDestroy(long var0);

    private native WebContents nativeGetWebContents(long var1);

    private native long nativeReleasePopupXWalkContent(long var1);

    private native void nativeSetJavaPeers(long var1, XWalkContent var3, XWalkWebContentsDelegateAdapter var4, XWalkContentsClientBridge var5, XWalkContentsIoThreadClient var6, InterceptNavigationDelegate var7);

    private native void nativeClearCache(long var1, boolean var3);

    private native void nativeClearCacheForSingleFile(long var1, String var3);

    private native String nativeDevToolsAgentId(long var1);

    private native String nativeGetVersion(long var1);

    private native void nativeSetJsOnlineProperty(long var1, boolean var3);

    private native boolean nativeSetManifest(long var1, String var3, String var4);

    private native int nativeGetRoutingID(long var1);

    private native void nativeInvokeGeolocationCallback(long var1, boolean var3, String var4);

    private native byte[] nativeGetState(long var1);

    private native boolean nativeSetState(long var1, byte[] var3);

    private native void nativeSetBackgroundColor(long var1, int var3);

    private class XWalkGeolocationCallback
    implements XWalkGeolocationPermissions.Callback {
        private XWalkGeolocationCallback() {
        }

        @Override
        public void invoke(final String origin, final boolean allow, final boolean retain) {
            ThreadUtils.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (retain) {
                        if (allow) {
                            XWalkContent.this.mGeolocationPermissions.allow(origin);
                        } else {
                            XWalkContent.this.mGeolocationPermissions.deny(origin);
                        }
                    }
                    XWalkContent.this.nativeInvokeGeolocationCallback(XWalkContent.this.mNativeContent, allow, origin);
                }
            });
        }
    }

    private class XWalkIoThreadClientImpl
    implements XWalkContentsIoThreadClient {
        private XWalkIoThreadClientImpl() {
        }

        @Override
        public int getCacheMode() {
            return XWalkContent.this.mSettings.getCacheMode();
        }

        @Override
        public InterceptedRequestData shouldInterceptRequest(String url, boolean isMainFrame) {
            XWalkContent.this.mContentsClientBridge.getCallbackHelper().postOnResourceLoadStarted(url);
            WebResourceResponse webResourceResponse = XWalkContent.this.mContentsClientBridge.shouldInterceptRequest(url);
            InterceptedRequestData interceptedRequestData = null;
            if (webResourceResponse == null) {
                XWalkContent.this.mContentsClientBridge.getCallbackHelper().postOnLoadResource(url);
            } else {
                if (isMainFrame && webResourceResponse.getData() == null) {
                    XWalkContent.this.mContentsClientBridge.getCallbackHelper().postOnReceivedError(-1, null, url);
                }
                interceptedRequestData = new InterceptedRequestData(webResourceResponse.getMimeType(), webResourceResponse.getEncoding(), webResourceResponse.getData());
            }
            return interceptedRequestData;
        }

        @Override
        public boolean shouldBlockContentUrls() {
            return !XWalkContent.this.mSettings.getAllowContentAccess();
        }

        @Override
        public boolean shouldBlockFileUrls() {
            return !XWalkContent.this.mSettings.getAllowFileAccess();
        }

        @Override
        public boolean shouldBlockNetworkLoads() {
            return XWalkContent.this.mSettings.getBlockNetworkLoads();
        }

        @Override
        public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimeType, long contentLength) {
            XWalkContent.this.mContentsClientBridge.getCallbackHelper().postOnDownloadStart(url, userAgent, contentDisposition, mimeType, contentLength);
        }

        @Override
        public void newLoginRequest(String realm, String account, String args) {
            XWalkContent.this.mContentsClientBridge.getCallbackHelper().postOnReceivedLoginRequest(realm, account, args);
        }
    }

    private static final class DestroyRunnable
    implements Runnable {
        private final long mNativeContent;

        private DestroyRunnable(long nativeXWalkContent) {
            this.mNativeContent = nativeXWalkContent;
        }

        @Override
        public void run() {
            XWalkContent.nativeDestroy(this.mNativeContent);
        }
    }
}

