/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import android.graphics.Bitmap;
import android.graphics.Picture;
import android.net.http.SslError;
import android.os.Message;
import android.view.KeyEvent;
import android.view.View;
import android.webkit.ConsoleMessage;
import android.webkit.ValueCallback;
import android.webkit.WebResourceResponse;
import org.chromium.content.browser.ContentViewClient;
import org.chromium.content_public.browser.WebContents;
import org.chromium.content_public.browser.WebContentsObserver;
import org.chromium.net.AndroidPrivateKey;
import org.chromium.net.DefaultAndroidKeyStore;
import org.xwalk.core.internal.ClientCertLookupTable;
import org.xwalk.core.internal.ClientCertRequestInternal;
import org.xwalk.core.internal.ErrorCodeConversionHelper;
import org.xwalk.core.internal.XWalkContentsClientCallbackHelper;
import org.xwalk.core.internal.XWalkGeolocationPermissions;
import org.xwalk.core.internal.XWalkHttpAuthHandlerInternal;
import org.xwalk.core.internal.XWalkWebChromeClient;

abstract class XWalkContentsClient
extends ContentViewClient {
    private static final String TAG = "XWalkContentsClient";
    private final XWalkContentsClientCallbackHelper mCallbackHelper = new XWalkContentsClientCallbackHelper(this);
    private XWalkWebContentsObserver mWebContentsObserver;
    private double mDIPScale;
    protected DefaultAndroidKeyStore mLocalKeyStore;
    protected ClientCertLookupTable mLookupTable;

    XWalkContentsClient() {
    }

    @Override
    public final void onUpdateTitle(String title) {
        this.onTitleChanged(title);
    }

    @Override
    public boolean shouldOverrideKeyEvent(KeyEvent event) {
        return super.shouldOverrideKeyEvent(event);
    }

    void installWebContentsObserver(WebContents webContents) {
        if (this.mWebContentsObserver != null) {
            this.mWebContentsObserver.destroy();
        }
        this.mWebContentsObserver = new XWalkWebContentsObserver(webContents);
    }

    void setDIPScale(double dipScale) {
        this.mDIPScale = dipScale;
    }

    final XWalkContentsClientCallbackHelper getCallbackHelper() {
        return this.mCallbackHelper;
    }

    public abstract void getVisitedHistory(ValueCallback<String[]> var1);

    public abstract void doUpdateVisitedHistory(String var1, boolean var2);

    public abstract void onProgressChanged(int var1);

    public abstract WebResourceResponse shouldInterceptRequest(String var1);

    public abstract void onResourceLoadStarted(String var1);

    public abstract void onResourceLoadFinished(String var1);

    public abstract void onLoadResource(String var1);

    public abstract boolean shouldOverrideUrlLoading(String var1);

    public abstract void onUnhandledKeyEvent(KeyEvent var1);

    public abstract boolean onConsoleMessage(ConsoleMessage var1);

    public abstract void onReceivedHttpAuthRequest(XWalkHttpAuthHandlerInternal var1, String var2, String var3);

    public abstract void onReceivedSslError(ValueCallback<Boolean> var1, SslError var2);

    public abstract void onReceivedClientCertRequest(ClientCertRequestInternal var1);

    public abstract void onReceivedLoginRequest(String var1, String var2, String var3);

    public abstract void onFormResubmission(Message var1, Message var2);

    public abstract void onDownloadStart(String var1, String var2, String var3, String var4, long var5);

    public abstract void onGeolocationPermissionsShowPrompt(String var1, XWalkGeolocationPermissions.Callback var2);

    public abstract void onGeolocationPermissionsHidePrompt();

    public final void onScaleChanged(float oldScaleFactor, float newScaleFactor) {
        this.onScaleChangedScaled((float)((double)oldScaleFactor * this.mDIPScale), (float)((double)newScaleFactor * this.mDIPScale));
    }

    public abstract void onScaleChangedScaled(float var1, float var2);

    protected abstract boolean onCreateWindow(boolean var1, boolean var2);

    protected abstract void onCloseWindow();

    public abstract void onDidChangeThemeColor(int var1);

    public abstract void onDocumentLoadedInFrame(long var1);

    public abstract void onReceivedIcon(Bitmap var1);

    protected abstract void onRequestFocus();

    public abstract void onPageStarted(String var1);

    public abstract void onPageFinished(String var1);

    protected abstract void onStopLoading();

    public abstract void onReceivedError(int var1, String var2, String var3);

    public abstract void onRendererUnresponsive();

    public abstract void onRendererResponsive();

    public abstract void onTitleChanged(String var1);

    public abstract void onToggleFullscreen(boolean var1);

    public abstract boolean hasEnteredFullscreen();

    public abstract boolean shouldOverrideRunFileChooser(int var1, int var2, int var3, String var4, boolean var5);

    public abstract void onShowCustomView(View var1, int var2, XWalkWebChromeClient.CustomViewCallback var3);

    public void onShowCustomView(View view, XWalkWebChromeClient.CustomViewCallback callback) {
        this.onShowCustomView(view, -1, callback);
    }

    public abstract void onHideCustomView();

    public abstract void didFinishLoad(String var1);

    public abstract void provideClientCertificateResponse(int var1, byte[][] var2, AndroidPrivateKey var3);

    public abstract void onFindResultReceived(int var1, int var2, boolean var3);

    public abstract void onNewPicture(Picture var1);

    public abstract boolean shouldCreateWebContents(String var1);

    public class XWalkWebContentsObserver
    extends WebContentsObserver {
        public XWalkWebContentsObserver(WebContents webContents) {
            super(webContents);
        }

        @Override
        public void didChangeThemeColor(int color2) {
            XWalkContentsClient.this.onDidChangeThemeColor(color2);
        }

        @Override
        public void didStopLoading(String url) {
            XWalkContentsClient.this.mCallbackHelper.postOnPageFinished(url);
        }

        @Override
        public void didFailLoad(boolean isProvisionalLoad, boolean isMainFrame, int errorCode, String description, String failingUrl, boolean wasIgnoredByHandler) {
            if (errorCode == -3 || !isMainFrame) {
                return;
            }
            XWalkContentsClient.this.onReceivedError(ErrorCodeConversionHelper.convertErrorCode(errorCode), description, failingUrl);
        }

        @Override
        public void didNavigateAnyFrame(String url, String baseUrl, boolean isReload) {
            XWalkContentsClient.this.doUpdateVisitedHistory(url, isReload);
        }

        @Override
        public void didFinishLoad(long frameId, String validatedUrl, boolean isMainFrame) {
        }

        @Override
        public void documentLoadedInFrame(long frameId) {
            XWalkContentsClient.this.onDocumentLoadedInFrame(frameId);
        }
    }
}

