/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import org.chromium.base.JNINamespace;
import org.xwalk.core.internal.XWalkAPI;

@JNINamespace(value="xwalk")
@XWalkAPI(createExternally=true)
public class XWalkCookieManagerInternal {
    @XWalkAPI
    public void setAcceptCookie(boolean accept) {
        this.nativeSetAcceptCookie(accept);
    }

    @XWalkAPI
    public boolean acceptCookie() {
        return this.nativeAcceptCookie();
    }

    @XWalkAPI
    public void setCookie(String url, String value) {
        this.nativeSetCookie(url, value);
    }

    @XWalkAPI
    public String getCookie(String url) {
        String cookie = this.nativeGetCookie(url.toString());
        return cookie == null || cookie.trim().isEmpty() ? null : cookie;
    }

    @XWalkAPI
    public void removeSessionCookie() {
        this.nativeRemoveSessionCookie();
    }

    @XWalkAPI
    public void removeAllCookie() {
        this.nativeRemoveAllCookie();
    }

    @XWalkAPI
    public boolean hasCookies() {
        return this.nativeHasCookies();
    }

    @XWalkAPI
    public void removeExpiredCookie() {
        this.nativeRemoveExpiredCookie();
    }

    @XWalkAPI
    public void flushCookieStore() {
        this.nativeFlushCookieStore();
    }

    @XWalkAPI
    public boolean allowFileSchemeCookies() {
        return this.nativeAllowFileSchemeCookies();
    }

    @XWalkAPI
    public void setAcceptFileSchemeCookies(boolean accept) {
        this.nativeSetAcceptFileSchemeCookies(accept);
    }

    private native void nativeSetAcceptCookie(boolean var1);

    private native boolean nativeAcceptCookie();

    private native void nativeSetCookie(String var1, String var2);

    private native String nativeGetCookie(String var1);

    private native void nativeRemoveSessionCookie();

    private native void nativeRemoveAllCookie();

    private native void nativeRemoveExpiredCookie();

    private native void nativeFlushCookieStore();

    private native boolean nativeHasCookies();

    private native boolean nativeAllowFileSchemeCookies();

    private native void nativeSetAcceptFileSchemeCookies(boolean var1);
}

