/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import android.content.Context;
import android.util.Log;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

class XWalkInternalResources {
    private static final String TAG = "XWalkInternalResources";
    private static boolean loaded = false;
    private static final String[] INTERNAL_RESOURCE_CLASSES = new String[]{"org.chromium.components.web_contents_delegate_android.R", "org.chromium.content.R", "org.chromium.ui.R", "org.xwalk.core.internal.R"};
    private static final String GENERATED_RESOURCE_CLASS = "org.xwalk.core.R";

    XWalkInternalResources() {
    }

    private static void doResetIds(Context context) {
        ClassLoader classLoader = context.getClassLoader();
        ClassLoader appClassLoader = context.getApplicationContext().getClassLoader();
        for (String resourceClass : INTERNAL_RESOURCE_CLASSES) {
            try {
                Class<?>[] innerClazzs;
                Class<?> internalResource = classLoader.loadClass(resourceClass);
                for (Class<?> innerClazz : innerClazzs = internalResource.getClasses()) {
                    Field[] fields;
                    Class<?> generatedInnerClazz;
                    String generatedInnerClassName = innerClazz.getName().replace(resourceClass, GENERATED_RESOURCE_CLASS);
                    try {
                        generatedInnerClazz = appClassLoader.loadClass(generatedInnerClassName);
                    }
                    catch (ClassNotFoundException e) {
                        Log.w((String)TAG, (String)(generatedInnerClassName + "is not found."));
                        continue;
                    }
                    for (Field field : fields = innerClazz.getFields()) {
                        if (Modifier.isFinal(field.getModifiers())) {
                            field.setAccessible(true);
                        }
                        try {
                            int value = generatedInnerClazz.getField(field.getName()).getInt(null);
                            field.setInt(null, value);
                        }
                        catch (IllegalAccessException e) {
                            Log.w((String)TAG, (String)(generatedInnerClazz.getName() + "." + field.getName() + " is not accessable."));
                        }
                        catch (IllegalArgumentException e) {
                            Log.w((String)TAG, (String)(generatedInnerClazz.getName() + "." + field.getName() + " is not int."));
                        }
                        catch (NoSuchFieldException e) {
                            Log.w((String)TAG, (String)(generatedInnerClazz.getName() + "." + field.getName() + " is not found."));
                        }
                        if (!Modifier.isFinal(field.getModifiers())) continue;
                        field.setAccessible(false);
                    }
                }
            }
            catch (ClassNotFoundException e) {
                Log.w((String)TAG, (String)(resourceClass + "is not found."));
            }
        }
    }

    static void resetIds(Context context) {
        if (!loaded) {
            XWalkInternalResources.doResetIds(context);
            loaded = true;
        }
    }
}

