/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.util.Log;
import android.webkit.MimeTypeMap;
import org.chromium.components.navigation_interception.NavigationParams;
import org.xwalk.core.internal.XWalkNavigationHandler;

public class XWalkNavigationHandlerImpl
implements XWalkNavigationHandler {
    private static final String TAG = "XWalkNavigationHandlerImpl";
    private static final String PROTOCOL_WTAI_PREFIX = "wtai://";
    private static final String PROTOCOL_WTAI_MC_PREFIX = "wtai://wp/mc;";
    private static final String ACTION_TEL_PREFIX = "tel:";
    private static final String ACTION_SMS_PREFIX = "sms:";
    private static final String ACTION_MAIL_PREFIX = "mailto:";
    private static final String ACTION_GEO_PREFIX = "geo:";
    private static final String ACTION_MARKET_PREFIX = "market:";
    private Context mContext;

    public XWalkNavigationHandlerImpl(Context context) {
        this.mContext = context;
    }

    @Override
    public boolean handleNavigation(NavigationParams params) {
        String url = params.url;
        Intent intent = null;
        intent = url.startsWith(PROTOCOL_WTAI_PREFIX) ? this.createIntentForWTAI(url) : this.createIntentForActionUri(url);
        if (intent != null && this.startActivity(intent)) {
            return true;
        }
        return this.handleUrlByMimeType(url);
    }

    protected boolean startActivity(Intent intent) {
        try {
            if (!(this.mContext instanceof Activity)) {
                intent.addFlags(0x10000000);
            }
            this.mContext.startActivity(intent);
        }
        catch (ActivityNotFoundException exception) {
            Log.w((String)TAG, (String)"Activity not found for Intent:");
            Log.w((String)TAG, (String)intent.toUri(0));
            return false;
        }
        return true;
    }

    private Intent createIntentForWTAI(String url) {
        Intent intent = null;
        if (url.startsWith(PROTOCOL_WTAI_MC_PREFIX)) {
            String number = url.substring(PROTOCOL_WTAI_MC_PREFIX.length());
            String mcUrl = ACTION_TEL_PREFIX + number;
            intent = new Intent("android.intent.action.DIAL");
            intent.setData(Uri.parse((String)mcUrl));
        }
        return intent;
    }

    private Intent createIntentForActionUri(String url) {
        Intent intent = null;
        if (url.startsWith(ACTION_TEL_PREFIX)) {
            intent = new Intent("android.intent.action.DIAL");
            intent.setData(Uri.parse((String)url));
        } else if (url.startsWith(ACTION_GEO_PREFIX)) {
            intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)url));
        } else if (url.startsWith(ACTION_MAIL_PREFIX)) {
            intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)url));
        } else if (url.startsWith(ACTION_SMS_PREFIX)) {
            intent = new Intent("android.intent.action.VIEW");
            String address = null;
            int parmIndex = url.indexOf(63);
            if (parmIndex == -1) {
                address = url.substring(4);
            } else {
                address = url.substring(4, parmIndex);
                Uri uri = Uri.parse((String)url);
                String query = uri.getQuery();
                if (query != null && query.startsWith("body=")) {
                    intent.putExtra("sms_body", query.substring(5));
                }
            }
            intent.setData(Uri.parse((String)(ACTION_SMS_PREFIX + address)));
            intent.putExtra("address", address);
            intent.setType("vnd.android-dir/mms-sms");
        } else if (url.startsWith(ACTION_MARKET_PREFIX)) {
            intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)url));
        }
        return intent;
    }

    private boolean handleUrlByMimeType(String url) {
        String extenstion;
        MimeTypeMap map = MimeTypeMap.getSingleton();
        String mimeType = map.getMimeTypeFromExtension(extenstion = MimeTypeMap.getFileExtensionFromUrl((String)url));
        if (this.shouldHandleMimeType(mimeType)) {
            Intent sendIntent = new Intent();
            sendIntent.setAction("android.intent.action.VIEW");
            sendIntent.setDataAndType(Uri.parse((String)url), mimeType);
            if (sendIntent.resolveActivity(this.mContext.getPackageManager()) != null) {
                this.startActivity(sendIntent);
                return true;
            }
        }
        return false;
    }

    private boolean shouldHandleMimeType(String mimeType) {
        if (mimeType != null && mimeType.startsWith("application/")) {
            return mimeType != "application/xhtml+xml" && mimeType != "application/xml";
        }
        return false;
    }
}

