/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.xwalk.core.internal.XWalkAPI;

@XWalkAPI(noInstance=true)
public class XWalkPreferencesInternal {
    private static HashMap<String, PreferenceValue> sPrefMap = new HashMap();
    private static ArrayList<WeakReference<KeyValueChangeListener>> sListeners = new ArrayList();
    private static ReferenceQueue<KeyValueChangeListener> sRefQueue = new ReferenceQueue();
    @XWalkAPI
    public static final String REMOTE_DEBUGGING = "remote-debugging";
    @XWalkAPI
    public static final String ANIMATABLE_XWALK_VIEW = "animatable-xwalk-view";
    @XWalkAPI
    public static final String JAVASCRIPT_CAN_OPEN_WINDOW = "javascript-can-open-window";
    @XWalkAPI
    public static final String ALLOW_UNIVERSAL_ACCESS_FROM_FILE = "allow-universal-access-from-file";
    @XWalkAPI
    public static final String SUPPORT_MULTIPLE_WINDOWS = "support-multiple-windows";
    @XWalkAPI
    public static final String PROFILE_NAME = "profile-name";
    static final String ENABLE_JAVASCRIPT = "enable-javascript";
    static final String ENABLE_EXTENSIONS = "enable-extensions";

    @XWalkAPI(reservable=true)
    public static synchronized void setValue(String key, boolean enabled) throws RuntimeException {
        XWalkPreferencesInternal.checkKey(key);
        if (key == ANIMATABLE_XWALK_VIEW && !sListeners.isEmpty()) {
            throw new RuntimeException("Warning: the preference key " + key + " can not be set if the preference is already loaded by Crosswalk");
        }
        if (sPrefMap.get(key).getBooleanValue() != enabled) {
            PreferenceValue v = new PreferenceValue(enabled);
            sPrefMap.put(key, v);
            XWalkPreferencesInternal.onKeyValueChanged(key, v);
        }
    }

    @XWalkAPI(reservable=true)
    public static synchronized void setValue(String key, int value) throws RuntimeException {
        XWalkPreferencesInternal.checkKey(key);
        if (key == ANIMATABLE_XWALK_VIEW && !sListeners.isEmpty()) {
            throw new RuntimeException("Warning: the preference key " + key + " can not be set if the preference is already loaded by Crosswalk");
        }
        if (sPrefMap.get(key).getIntegerValue() != value) {
            PreferenceValue v = new PreferenceValue(value);
            sPrefMap.put(key, v);
            XWalkPreferencesInternal.onKeyValueChanged(key, v);
        }
    }

    @XWalkAPI(reservable=true)
    public static synchronized void setValue(String key, String value) throws RuntimeException {
        XWalkPreferencesInternal.checkKey(key);
        if (key == ANIMATABLE_XWALK_VIEW && !sListeners.isEmpty()) {
            throw new RuntimeException("Warning: the preference key " + key + " can not be set if the preference is already loaded by Crosswalk");
        }
        if (value != null && !value.equals(sPrefMap.get(key).getStringValue())) {
            PreferenceValue v = new PreferenceValue(value);
            sPrefMap.put(key, v);
            XWalkPreferencesInternal.onKeyValueChanged(key, v);
        }
    }

    @XWalkAPI
    public static synchronized boolean getValue(String key) throws RuntimeException {
        XWalkPreferencesInternal.checkKey(key);
        return sPrefMap.get(key).getBooleanValue();
    }

    @XWalkAPI
    public static synchronized boolean getBooleanValue(String key) throws RuntimeException {
        XWalkPreferencesInternal.checkKey(key);
        return sPrefMap.get(key).getBooleanValue();
    }

    @XWalkAPI
    public static synchronized int getIntegerValue(String key) throws RuntimeException {
        XWalkPreferencesInternal.checkKey(key);
        return sPrefMap.get(key).getIntegerValue();
    }

    @XWalkAPI
    public static synchronized String getStringValue(String key) throws RuntimeException {
        XWalkPreferencesInternal.checkKey(key);
        return sPrefMap.get(key).getStringValue();
    }

    static synchronized void load(KeyValueChangeListener listener) {
        for (Map.Entry<String, PreferenceValue> entry : sPrefMap.entrySet()) {
            listener.onKeyValueChanged(entry.getKey(), entry.getValue());
        }
        XWalkPreferencesInternal.registerListener(listener);
    }

    static synchronized void unload(KeyValueChangeListener listener) {
        XWalkPreferencesInternal.unregisterListener(listener);
    }

    private static synchronized void registerListener(KeyValueChangeListener listener) {
        XWalkPreferencesInternal.removeEnqueuedReference();
        WeakReference<KeyValueChangeListener> weakListener = new WeakReference<KeyValueChangeListener>(listener, sRefQueue);
        sListeners.add(weakListener);
    }

    private static synchronized void unregisterListener(KeyValueChangeListener listener) {
        XWalkPreferencesInternal.removeEnqueuedReference();
        for (WeakReference<KeyValueChangeListener> weakListener : sListeners) {
            if (weakListener.get() != listener) continue;
            sListeners.remove(weakListener);
            break;
        }
    }

    private static void onKeyValueChanged(String key, PreferenceValue value) {
        for (WeakReference<KeyValueChangeListener> weakListener : sListeners) {
            KeyValueChangeListener listener = (KeyValueChangeListener)weakListener.get();
            if (listener == null) continue;
            listener.onKeyValueChanged(key, value);
        }
    }

    private static void checkKey(String key) throws RuntimeException {
        XWalkPreferencesInternal.removeEnqueuedReference();
        if (!sPrefMap.containsKey(key)) {
            throw new RuntimeException("Warning: the preference key " + key + " is not supported by Crosswalk.");
        }
    }

    private static void removeEnqueuedReference() {
        WeakReference toRemove;
        while ((toRemove = (WeakReference)sRefQueue.poll()) != null) {
            sListeners.remove(toRemove);
        }
    }

    static {
        sPrefMap.put(REMOTE_DEBUGGING, new PreferenceValue(false));
        sPrefMap.put(ANIMATABLE_XWALK_VIEW, new PreferenceValue(false));
        sPrefMap.put(ENABLE_JAVASCRIPT, new PreferenceValue(true));
        sPrefMap.put(JAVASCRIPT_CAN_OPEN_WINDOW, new PreferenceValue(true));
        sPrefMap.put(ALLOW_UNIVERSAL_ACCESS_FROM_FILE, new PreferenceValue(false));
        sPrefMap.put(SUPPORT_MULTIPLE_WINDOWS, new PreferenceValue(false));
        sPrefMap.put(ENABLE_EXTENSIONS, new PreferenceValue(true));
        sPrefMap.put(PROFILE_NAME, new PreferenceValue("Default"));
    }

    static interface KeyValueChangeListener {
        public void onKeyValueChanged(String var1, PreferenceValue var2);
    }

    static class PreferenceValue {
        static final int PREFERENCE_TYPE_BOOLEAN = 1;
        static final int PREFERENCE_TYPE_INTEGER = 2;
        static final int PREFERENCE_TYPE_STRING = 3;
        int mType;
        Object mValue;

        PreferenceValue(boolean value) {
            this.mType = 1;
            this.mValue = value;
        }

        PreferenceValue(int value) {
            this.mType = 2;
            this.mValue = value;
        }

        PreferenceValue(String value) {
            this.mType = 3;
            this.mValue = value;
        }

        int getType() {
            return this.mType;
        }

        boolean getBooleanValue() {
            if (this.mType != 1) {
                return false;
            }
            return (Boolean)this.mValue;
        }

        int getIntegerValue() {
            if (this.mType != 2) {
                return -1;
            }
            return (Integer)this.mValue;
        }

        String getStringValue() {
            if (this.mType != 3) {
                return null;
            }
            return (String)this.mValue;
        }
    }
}

