/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Paint;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Looper;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.webkit.ValueCallback;
import android.widget.FrameLayout;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.chromium.base.ApplicationStatus;
import org.chromium.base.ApplicationStatusManager;
import org.chromium.base.CommandLine;
import org.chromium.content.browser.ContentViewCore;
import org.chromium.net.NetworkChangeNotifier;
import org.xwalk.core.internal.XWalkAPI;
import org.xwalk.core.internal.XWalkClient;
import org.xwalk.core.internal.XWalkContent;
import org.xwalk.core.internal.XWalkDownloadListenerImpl;
import org.xwalk.core.internal.XWalkDownloadListenerInternal;
import org.xwalk.core.internal.XWalkNavigationHandler;
import org.xwalk.core.internal.XWalkNavigationHandlerImpl;
import org.xwalk.core.internal.XWalkNavigationHistoryInternal;
import org.xwalk.core.internal.XWalkNotificationService;
import org.xwalk.core.internal.XWalkNotificationServiceImpl;
import org.xwalk.core.internal.XWalkPathHelper;
import org.xwalk.core.internal.XWalkPreferencesInternal;
import org.xwalk.core.internal.XWalkResourceClientInternal;
import org.xwalk.core.internal.XWalkSettings;
import org.xwalk.core.internal.XWalkUIClientInternal;
import org.xwalk.core.internal.XWalkViewDelegate;
import org.xwalk.core.internal.XWalkWebChromeClient;
import org.xwalk.core.internal.extension.BuiltinXWalkExtensions;

@XWalkAPI(extendClass=FrameLayout.class, createExternally=true)
public class XWalkViewInternal
extends FrameLayout {
    static final String PLAYSTORE_DETAIL_URI = "market://details?id=";
    public static final int INPUT_FILE_REQUEST_CODE = 1;
    private static final String TAG = XWalkViewInternal.class.getSimpleName();
    private static final String PATH_PREFIX = "file:";
    private static boolean sInitialized = false;
    private XWalkContent mContent;
    private Activity mActivity;
    private Context mContext;
    private boolean mIsHidden;
    private XWalkActivityStateListener mActivityStateListener;
    private ValueCallback<Uri> mFilePathCallback;
    private String mCameraPhotoPath;
    @XWalkAPI
    public static final int RELOAD_NORMAL = 0;
    @XWalkAPI
    public static final int RELOAD_IGNORE_CACHE = 1;

    @XWalkAPI(preWrapperLines={"        super(${param1}, null);", "        SurfaceView surfaceView = new SurfaceView(${param1});", "        surfaceView.setLayoutParams(new ViewGroup.LayoutParams(0, 0));", "        addView(surfaceView);"}, postWrapperLines={"        addView((FrameLayout)bridge, new FrameLayout.LayoutParams(", "                FrameLayout.LayoutParams.MATCH_PARENT,", "                FrameLayout.LayoutParams.MATCH_PARENT));", "        removeViewAt(0);"})
    public XWalkViewInternal(Context context) {
        super(context, null);
        XWalkViewInternal.checkThreadSafety();
        this.mActivity = (Activity)context;
        this.mContext = this.getContext();
        XWalkViewInternal.init(this.getContext(), this.getActivity());
        this.initXWalkContent(this.mContext, null);
    }

    @XWalkAPI(preWrapperLines={"        super(${param1}, ${param2});", "        SurfaceView surfaceView = new SurfaceView(${param1});", "        surfaceView.setLayoutParams(new ViewGroup.LayoutParams(0, 0));", "        addView(surfaceView);"}, postWrapperLines={"        addView((FrameLayout)bridge, new FrameLayout.LayoutParams(", "                FrameLayout.LayoutParams.MATCH_PARENT,", "                FrameLayout.LayoutParams.MATCH_PARENT));", "        removeViewAt(0);"})
    public XWalkViewInternal(Context context, AttributeSet attrs) {
        super(context, attrs);
        XWalkViewInternal.checkThreadSafety();
        this.mActivity = (Activity)context;
        this.mContext = this.getContext();
        XWalkViewInternal.init(this.getContext(), this.getActivity());
        this.initXWalkContent(this.mContext, attrs);
    }

    @XWalkAPI(preWrapperLines={"        super(${param1}, null);", "        SurfaceView surfaceView = new SurfaceView(${param1});", "        surfaceView.setLayoutParams(new ViewGroup.LayoutParams(0, 0));", "        addView(surfaceView);"}, postWrapperLines={"        addView((FrameLayout)bridge, new FrameLayout.LayoutParams(", "                FrameLayout.LayoutParams.MATCH_PARENT,", "                FrameLayout.LayoutParams.MATCH_PARENT));", "        removeViewAt(0);"})
    public XWalkViewInternal(Context context, Activity activity) {
        super(context, null);
        XWalkViewInternal.checkThreadSafety();
        this.mActivity = activity;
        this.mContext = this.getContext();
        XWalkViewInternal.init(this.getContext(), this.getActivity());
        this.initXWalkContent(this.mContext, null);
    }

    private static void init(Context context, Activity activity) {
        if (sInitialized) {
            return;
        }
        XWalkViewDelegate.init(null, (Context)activity);
        ApplicationStatusManager.init(activity.getApplication());
        NetworkChangeNotifier.init((Context)activity);
        NetworkChangeNotifier.setAutoDetectConnectivityState(true);
        ApplicationStatusManager.informActivityStarted(activity);
        sInitialized = true;
    }

    public Activity getActivity() {
        if (this.mActivity != null) {
            return this.mActivity;
        }
        if (this.getContext() instanceof Activity) {
            return (Activity)this.getContext();
        }
        assert (false);
        return null;
    }

    public Context getViewContext() {
        return this.mContext;
    }

    public void completeWindowCreation(XWalkViewInternal newXWalkView) {
        this.mContent.supplyContentsForPopup(newXWalkView == null ? null : newXWalkView.mContent);
    }

    private void initXWalkContent(Context context, AttributeSet attrs) {
        File extCacheDir;
        this.mActivityStateListener = new XWalkActivityStateListener(this);
        ApplicationStatus.registerStateListenerForActivity(this.mActivityStateListener, this.getActivity());
        this.mIsHidden = false;
        this.mContent = new XWalkContent(context, attrs, this);
        this.mContent.resumeTimers();
        this.setXWalkClient(new XWalkClient(this));
        this.setXWalkWebChromeClient(new XWalkWebChromeClient(this));
        this.setUIClient(new XWalkUIClientInternal(this));
        this.setResourceClient(new XWalkResourceClientInternal(this));
        this.setDownloadListener(new XWalkDownloadListenerImpl(context));
        this.setNavigationHandler(new XWalkNavigationHandlerImpl(context));
        this.setNotificationService(new XWalkNotificationServiceImpl(context, this));
        if (!CommandLine.getInstance().hasSwitch("disable-xwalk-extensions")) {
            BuiltinXWalkExtensions.load(context, this.getActivity());
        } else {
            XWalkPreferencesInternal.setValue("enable-extensions", false);
        }
        XWalkPathHelper.initialize();
        XWalkPathHelper.setCacheDirectory(this.mContext.getApplicationContext().getCacheDir().getPath());
        String state = Environment.getExternalStorageState();
        if (("mounted".equals(state) || "mounted_ro".equals(state)) && null != (extCacheDir = this.mContext.getApplicationContext().getExternalCacheDir())) {
            XWalkPathHelper.setExternalCacheDirectory(extCacheDir.getPath());
        }
    }

    @XWalkAPI
    public void load(String url, String content) {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.loadUrl(url, content);
    }

    @XWalkAPI
    public void loadAppFromManifest(String url, String content) {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.loadAppFromManifest(url, content);
    }

    @XWalkAPI
    public void reload(int mode) {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.reload(mode);
    }

    @XWalkAPI
    public void stopLoading() {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.stopLoading();
    }

    @XWalkAPI
    public String getUrl() {
        if (this.mContent == null) {
            return null;
        }
        XWalkViewInternal.checkThreadSafety();
        return this.mContent.getUrl();
    }

    @XWalkAPI
    public String getTitle() {
        if (this.mContent == null) {
            return null;
        }
        XWalkViewInternal.checkThreadSafety();
        return this.mContent.getTitle();
    }

    @XWalkAPI
    public String getOriginalUrl() {
        if (this.mContent == null) {
            return null;
        }
        XWalkViewInternal.checkThreadSafety();
        return this.mContent.getOriginalUrl();
    }

    @XWalkAPI
    public XWalkNavigationHistoryInternal getNavigationHistory() {
        if (this.mContent == null) {
            return null;
        }
        XWalkViewInternal.checkThreadSafety();
        return this.mContent.getNavigationHistory();
    }

    @XWalkAPI
    public void addJavascriptInterface(Object object, String name) {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.addJavascriptInterface(object, name);
    }

    @XWalkAPI
    public void evaluateJavascript(String script, ValueCallback<String> callback) {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.evaluateJavascript(script, callback);
    }

    @XWalkAPI
    public void clearCache(boolean includeDiskFiles) {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.clearCache(includeDiskFiles);
    }

    @XWalkAPI
    public void clearCacheForSingleFile(String url) {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.clearCacheForSingleFile(url);
    }

    @XWalkAPI
    public boolean hasEnteredFullscreen() {
        if (this.mContent == null) {
            return false;
        }
        XWalkViewInternal.checkThreadSafety();
        return this.mContent.hasEnteredFullscreen();
    }

    @XWalkAPI
    public void leaveFullscreen() {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.exitFullscreen();
    }

    @XWalkAPI
    public void pauseTimers() {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.pauseTimers();
    }

    @XWalkAPI
    public void resumeTimers() {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.resumeTimers();
    }

    @XWalkAPI
    public void onHide() {
        if (this.mContent == null || this.mIsHidden) {
            return;
        }
        this.mContent.onPause();
        this.mIsHidden = true;
    }

    @XWalkAPI
    public void onShow() {
        if (this.mContent == null || !this.mIsHidden) {
            return;
        }
        this.mContent.onResume();
        this.mIsHidden = false;
    }

    @XWalkAPI
    public void onDestroy() {
        this.destroy();
    }

    @XWalkAPI
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.mContent == null) {
            return;
        }
        if (requestCode == 1 && this.mFilePathCallback != null) {
            Uri results = null;
            if (-1 == resultCode) {
                if (data == null || data.getAction() == null && data.getData() == null) {
                    if (this.mCameraPhotoPath != null) {
                        results = Uri.parse((String)this.mCameraPhotoPath);
                    }
                } else {
                    String dataString = data.getDataString();
                    if (dataString != null) {
                        results = Uri.parse((String)dataString);
                    }
                    this.deleteImageFile();
                }
            } else if (0 == resultCode) {
                this.deleteImageFile();
            }
            this.mFilePathCallback.onReceiveValue(results);
            this.mFilePathCallback = null;
            return;
        }
        this.mContent.onActivityResult(requestCode, resultCode, data);
    }

    @XWalkAPI
    public boolean onNewIntent(Intent intent) {
        if (this.mContent == null) {
            return false;
        }
        return this.mContent.onNewIntent(intent);
    }

    @XWalkAPI
    public boolean saveState(Bundle outState) {
        if (this.mContent == null) {
            return false;
        }
        this.mContent.saveState(outState);
        return true;
    }

    @XWalkAPI
    public boolean restoreState(Bundle inState) {
        if (this.mContent == null) {
            return false;
        }
        return this.mContent.restoreState(inState) != null;
    }

    @XWalkAPI
    public String getAPIVersion() {
        return "5.0";
    }

    @XWalkAPI
    public String getXWalkVersion() {
        if (this.mContent == null) {
            return null;
        }
        return this.mContent.getXWalkVersion();
    }

    @XWalkAPI(reservable=true)
    public void setUIClient(XWalkUIClientInternal client) {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.setUIClient(client);
    }

    @XWalkAPI(reservable=true)
    public void setResourceClient(XWalkResourceClientInternal client) {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.setResourceClient(client);
    }

    @XWalkAPI
    public void setBackgroundColor(int color2) {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.setBackgroundColor(color2);
    }

    @XWalkAPI
    public void setLayerType(int layerType, Paint paint) {
        if (layerType != 1) {
            super.setLayerType(layerType, paint);
        } else {
            Log.w((String)TAG, (String)"LAYER_TYPE_SOFTWARE is not supported by XwalkView");
        }
    }

    @XWalkAPI
    public void setUserAgentString(String userAgent) {
        XWalkSettings settings = this.getSettings();
        if (settings == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        settings.setUserAgentString(userAgent);
    }

    @XWalkAPI
    public String getUserAgentString() {
        XWalkSettings settings = this.getSettings();
        if (settings == null) {
            return null;
        }
        XWalkViewInternal.checkThreadSafety();
        return settings.getUserAgentString();
    }

    @XWalkAPI
    public void setAcceptLanguages(String acceptLanguages) {
        XWalkSettings settings = this.getSettings();
        if (settings == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        settings.setAcceptLanguages(acceptLanguages);
    }

    public XWalkSettings getSettings() {
        if (this.mContent == null) {
            return null;
        }
        XWalkViewInternal.checkThreadSafety();
        return this.mContent.getSettings();
    }

    @XWalkAPI
    public void setNetworkAvailable(boolean networkUp) {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.setNetworkAvailable(networkUp);
    }

    public void enableRemoteDebugging() {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.enableRemoteDebugging();
    }

    @XWalkAPI
    public Uri getRemoteDebuggingUrl() {
        if (this.mContent == null) {
            return null;
        }
        XWalkViewInternal.checkThreadSafety();
        String wsUrl = this.mContent.getRemoteDebuggingUrl();
        if (wsUrl == null || wsUrl.isEmpty()) {
            return null;
        }
        return Uri.parse((String)wsUrl);
    }

    @XWalkAPI
    public boolean zoomIn() {
        if (this.mContent == null) {
            return false;
        }
        XWalkViewInternal.checkThreadSafety();
        return this.mContent.zoomIn();
    }

    @XWalkAPI
    public boolean zoomOut() {
        if (this.mContent == null) {
            return false;
        }
        XWalkViewInternal.checkThreadSafety();
        return this.mContent.zoomOut();
    }

    @XWalkAPI
    public void zoomBy(float factor) {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.zoomBy(factor);
    }

    @XWalkAPI
    public boolean canZoomIn() {
        if (this.mContent == null) {
            return false;
        }
        XWalkViewInternal.checkThreadSafety();
        return this.mContent.canZoomIn();
    }

    @XWalkAPI
    public boolean canZoomOut() {
        if (this.mContent == null) {
            return false;
        }
        XWalkViewInternal.checkThreadSafety();
        return this.mContent.canZoomOut();
    }

    @XWalkAPI
    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        return this.mContent.onCreateInputConnection(outAttrs);
    }

    @XWalkAPI
    public void setInitialScale(int scaleInPercent) {
        XWalkViewInternal.checkThreadSafety();
        XWalkSettings settings = this.getSettings();
        if (settings == null) {
            return;
        }
        settings.setInitialPageScale(scaleInPercent);
    }

    public int getContentID() {
        if (this.mContent == null) {
            return -1;
        }
        return this.mContent.getRoutingID();
    }

    boolean canGoBack() {
        if (this.mContent == null) {
            return false;
        }
        XWalkViewInternal.checkThreadSafety();
        return this.mContent.canGoBack();
    }

    void goBack() {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.goBack();
    }

    boolean canGoForward() {
        if (this.mContent == null) {
            return false;
        }
        XWalkViewInternal.checkThreadSafety();
        return this.mContent.canGoForward();
    }

    void goForward() {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.goForward();
    }

    void clearHistory() {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.clearHistory();
    }

    void destroy() {
        if (this.mContent == null) {
            return;
        }
        ApplicationStatus.unregisterActivityStateListener(this.mActivityStateListener);
        this.mActivityStateListener = null;
        this.mContent.destroy();
        this.disableRemoteDebugging();
    }

    void disableRemoteDebugging() {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.disableRemoteDebugging();
    }

    private static void checkThreadSafety() {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            Throwable throwable = new Throwable("Warning: A XWalkViewInternal method was called on thread '" + Thread.currentThread().getName() + "'. " + "All XWalkViewInternal methods must be called on the UI thread. ");
            throw new RuntimeException(throwable);
        }
    }

    boolean isOwnerActivityRunning() {
        int status = ApplicationStatus.getStateForActivity(this.getActivity());
        return status != 6;
    }

    void navigateTo(int offset) {
        if (this.mContent == null) {
            return;
        }
        this.mContent.navigateTo(offset);
    }

    void setOverlayVideoMode(boolean enabled) {
        this.mContent.setOverlayVideoMode(enabled);
    }

    @XWalkAPI
    public void setZOrderOnTop(boolean onTop) {
        if (this.mContent == null) {
            return;
        }
        this.mContent.setZOrderOnTop(onTop);
    }

    @XWalkAPI
    public void clearFormData() {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.hideAutofillPopup();
    }

    @XWalkAPI(disableReflectMethod=true, preWrapperLines={"        if (visibility == View.INVISIBLE) visibility = View.GONE;", "        super.setVisibility(visibility);", "        setSurfaceViewVisibility(visibility);"})
    public void setVisibility(int visibility) {
    }

    @XWalkAPI(reservable=true)
    public void setSurfaceViewVisibility(int visibility) {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.setVisibility(visibility);
    }

    public void setXWalkClient(XWalkClient client) {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.setXWalkClient(client);
    }

    public void setXWalkWebChromeClient(XWalkWebChromeClient client) {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.setXWalkWebChromeClient(client);
    }

    @XWalkAPI
    public void setDownloadListener(XWalkDownloadListenerInternal listener) {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.setDownloadListener(listener);
    }

    public void setNavigationHandler(XWalkNavigationHandler handler) {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.setNavigationHandler(handler);
    }

    public void setNotificationService(XWalkNotificationService service) {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.setNotificationService(service);
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (event.getAction() == 1 && event.getKeyCode() == 4) {
            if (this.hasEnteredFullscreen()) {
                this.leaveFullscreen();
                return true;
            }
            if (this.canGoBack()) {
                this.goBack();
                return true;
            }
        }
        return super.dispatchKeyEvent(event);
    }

    private void onActivityStateChange(Activity activity, int newState) {
        assert (this.getActivity() == activity);
        switch (newState) {
            case 2: {
                this.onShow();
                break;
            }
            case 4: {
                this.pauseTimers();
                break;
            }
            case 3: {
                this.resumeTimers();
                break;
            }
            case 6: {
                this.onDestroy();
                break;
            }
            case 5: {
                this.onHide();
                break;
            }
        }
    }

    public boolean showFileChooser(ValueCallback<Uri> uploadFile, String acceptType, String capture) {
        this.mFilePathCallback = uploadFile;
        Intent takePictureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (takePictureIntent.resolveActivity(this.getActivity().getPackageManager()) != null) {
            File photoFile = this.createImageFile();
            if (photoFile != null) {
                this.mCameraPhotoPath = PATH_PREFIX + photoFile.getAbsolutePath();
                takePictureIntent.putExtra("PhotoPath", this.mCameraPhotoPath);
                takePictureIntent.putExtra("output", (Parcelable)Uri.fromFile((File)photoFile));
            } else {
                takePictureIntent = null;
            }
        }
        Intent contentSelectionIntent = new Intent("android.intent.action.GET_CONTENT");
        contentSelectionIntent.addCategory("android.intent.category.OPENABLE");
        contentSelectionIntent.setType("*/*");
        Intent camcorder = new Intent("android.media.action.VIDEO_CAPTURE");
        Intent soundRecorder = new Intent("android.provider.MediaStore.RECORD_SOUND");
        ArrayList<Intent> extraIntents = new ArrayList<Intent>();
        if (takePictureIntent != null) {
            extraIntents.add(takePictureIntent);
        }
        extraIntents.add(camcorder);
        extraIntents.add(soundRecorder);
        Intent chooserIntent = new Intent("android.intent.action.CHOOSER");
        chooserIntent.putExtra("android.intent.extra.INTENT", (Parcelable)contentSelectionIntent);
        chooserIntent.putExtra("android.intent.extra.INITIAL_INTENTS", (Parcelable[])extraIntents.toArray(new Intent[0]));
        this.getActivity().startActivityForResult(chooserIntent, 1);
        return true;
    }

    private File createImageFile() {
        String state = Environment.getExternalStorageState();
        if (!state.equals("mounted")) {
            Log.e((String)TAG, (String)"External storage is not mounted.");
            return null;
        }
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String imageFileName = "JPEG_" + timeStamp + "_";
        File storageDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
        if (!storageDir.exists()) {
            storageDir.mkdirs();
        }
        try {
            return File.createTempFile(imageFileName, ".jpg", storageDir);
        }
        catch (IOException ex) {
            Log.e((String)TAG, (String)"Unable to create Image File", (Throwable)ex);
            return null;
        }
    }

    private boolean deleteImageFile() {
        if (this.mCameraPhotoPath == null || !this.mCameraPhotoPath.contains(PATH_PREFIX)) {
            return false;
        }
        String filePath = this.mCameraPhotoPath.split(PATH_PREFIX)[1];
        File file = new File(filePath);
        return file.delete();
    }

    public ContentViewCore getXWalkContentForTest() {
        return this.mContent.getContentViewCoreForTest();
    }

    @XWalkAPI(delegate=true, preWrapperLines={"return performLongClick();"})
    public boolean performLongClickDelegate() {
        return false;
    }

    @XWalkAPI(delegate=true, preWrapperLines={"return onTouchEvent(event);"})
    public boolean onTouchEventDelegate(MotionEvent event) {
        return false;
    }

    @XWalkAPI
    public boolean onTouchEvent(MotionEvent event) {
        return this.mContent.onTouchEvent(event);
    }

    @XWalkAPI(delegate=true, preWrapperLines={"onScrollChanged(l, t, oldl, oldt);"})
    public void onScrollChangedDelegate(int l, int t, int oldl, int oldt) {
    }

    @XWalkAPI(delegate=true, preWrapperLines={"onFocusChanged(gainFocus, direction, previouslyFocusedRect);"})
    public void onFocusChangedDelegate(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
    }

    private class XWalkActivityStateListener
    implements ApplicationStatus.ActivityStateListener {
        WeakReference<XWalkViewInternal> mXWalkViewRef;

        XWalkActivityStateListener(XWalkViewInternal view) {
            this.mXWalkViewRef = new WeakReference<XWalkViewInternal>(view);
        }

        @Override
        public void onActivityStateChange(Activity activity, int newState) {
            XWalkViewInternal view = (XWalkViewInternal)((Object)this.mXWalkViewRef.get());
            if (view == null) {
                return;
            }
            view.onActivityStateChange(activity, newState);
        }
    }
}

