/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal.extension;

import android.app.Activity;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.xwalk.core.internal.XWalkExtensionInternal;
import org.xwalk.core.internal.extension.api.contacts.Contacts;
import org.xwalk.core.internal.extension.api.device_capabilities.DeviceCapabilities;
import org.xwalk.core.internal.extension.api.launchscreen.LaunchScreenExtension;
import org.xwalk.core.internal.extension.api.messaging.Messaging;
import org.xwalk.core.internal.extension.api.presentation.PresentationExtension;

public class BuiltinXWalkExtensions {
    private static final String TAG = "BuiltinXWalkExtension";
    private static HashMap<String, XWalkExtensionInternal> sBuiltinExtensions = new HashMap();

    public static void load(Context context, Activity activity) {
        String jsApiContent = "";
        try {
            jsApiContent = BuiltinXWalkExtensions.getExtensionJSFileContent(context, "jsapi/presentation_api.js", true);
            sBuiltinExtensions.put("jsapi/presentation_api.js", new PresentationExtension(jsApiContent, activity));
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)"Failed to read JS API file: jsapi/presentation_api.js");
        }
        jsApiContent = "";
        try {
            jsApiContent = BuiltinXWalkExtensions.getExtensionJSFileContent(context, "jsapi/launch_screen_api.js", true);
            sBuiltinExtensions.put("jsapi/launch_screen_api.js", new LaunchScreenExtension(jsApiContent, (Context)activity));
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)"Failed to read JS API file: jsapi/launch_screen_api.js");
        }
        jsApiContent = "";
        try {
            jsApiContent = BuiltinXWalkExtensions.getExtensionJSFileContent(context, "jsapi/contacts_api.js", true);
            sBuiltinExtensions.put("jsapi/contacts_api.js", new Contacts(jsApiContent, activity));
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)"Failed to read JS API file: jsapi/contacts_api.js");
        }
        jsApiContent = "";
        try {
            jsApiContent = BuiltinXWalkExtensions.getExtensionJSFileContent(context, "jsapi/device_capabilities_api.js", true);
            sBuiltinExtensions.put("jsapi/device_capabilities_api.js", new DeviceCapabilities(jsApiContent, activity));
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)"Failed to read JS API file: jsapi/device_capabilities_api.js");
        }
        jsApiContent = "";
        try {
            jsApiContent = BuiltinXWalkExtensions.getExtensionJSFileContent(context, "jsapi/messaging_api.js", true);
            sBuiltinExtensions.put("jsapi/messaging_api.js", new Messaging(jsApiContent, activity));
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)"Failed to read JS API file: jsapi/messaging_api.js");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getExtensionJSFileContent(Context context, String fileName, boolean fromRaw) throws IOException {
        String result = "";
        try (InputStream inputStream = null;){
            String resName;
            Resources resource;
            int resId;
            if (fromRaw && (resId = (resource = context.getResources()).getIdentifier(resName = new File(fileName).getName().split("\\.")[0], "raw", context.getPackageName())) > 0) {
                try {
                    inputStream = resource.openRawResource(resId);
                }
                catch (Resources.NotFoundException e) {
                    Log.w((String)TAG, (String)("Inputstream failed to open for R.raw." + resName + ", try to find it in assets"));
                }
            }
            if (inputStream == null) {
                AssetManager assetManager = context.getAssets();
                inputStream = assetManager.open(fileName);
            }
            int size = inputStream.available();
            byte[] buffer = new byte[size];
            inputStream.read(buffer);
            result = new String(buffer);
        }
        return result;
    }
}

