/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal.extension;

import android.app.Activity;
import java.lang.ref.WeakReference;
import org.chromium.base.ApplicationStatus;
import org.xwalk.core.internal.XWalkExtensionInternal;

public abstract class XWalkExtensionWithActivityStateListener
extends XWalkExtensionInternal {
    private XWalkActivityStateListener mActivityStateListener;

    private void initActivityStateListener(Activity activity) {
        this.mActivityStateListener = new XWalkActivityStateListener(this);
        ApplicationStatus.registerStateListenerForActivity(this.mActivityStateListener, activity);
    }

    public abstract void onActivityStateChange(Activity var1, int var2);

    public XWalkExtensionWithActivityStateListener(String name, String jsApi, Activity activity) {
        super(name, jsApi);
        this.initActivityStateListener(activity);
    }

    public XWalkExtensionWithActivityStateListener(String name, String jsApi, String[] entryPoints, Activity activity) {
        super(name, jsApi, entryPoints);
        this.initActivityStateListener(activity);
    }

    private class XWalkActivityStateListener
    implements ApplicationStatus.ActivityStateListener {
        WeakReference<XWalkExtensionWithActivityStateListener> mExtensionRef;

        XWalkActivityStateListener(XWalkExtensionWithActivityStateListener extension) {
            this.mExtensionRef = new WeakReference<XWalkExtensionWithActivityStateListener>(extension);
        }

        @Override
        public void onActivityStateChange(Activity activity, int newState) {
            XWalkExtensionWithActivityStateListener extension = (XWalkExtensionWithActivityStateListener)this.mExtensionRef.get();
            if (extension == null) {
                return;
            }
            extension.onActivityStateChange(activity, newState);
        }
    }
}

