/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal.extension.api.contacts;

import android.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContactConstants {
    public static final String CUSTOM_MIMETYPE_LASTUPDATED = "vnd.android.cursor.item/contact_custom_lastupdated";
    public static final String CUSTOM_MIMETYPE_GENDER = "vnd.android.cursor.item/contact_custom_gender";
    public static final Map<String, String> findFieldMap = ContactConstants.createStringMap(new String[]{"familyName", "familyNames", "givenNames", "givenNames", "middleName", "middleNames", "additionalName", "additionalNames", "honorificPrefix", "honorificPrefixes", "honorificSuffix", "honorificSuffixes", "nickName", "nickNames", "email", "emails", "photo", "photos", "url", "urls", "phoneNumber", "phoneNumbers", "organization", "organizations", "jobTitle", "jobTitles", "note", "notes"});
    public static final Map<String, Pair<String, String>> contactDataMap = ContactConstants.createTripleMap(new String[]{"id", "contact_id", null, "displayName", "data1", "vnd.android.cursor.item/name", "familyNames", "data3", "vnd.android.cursor.item/name", "givenNames", "data2", "vnd.android.cursor.item/name", "middleNames", "data5", "vnd.android.cursor.item/name", "additionalNames", "data5", "vnd.android.cursor.item/name", "honorificPrefixes", "data4", "vnd.android.cursor.item/name", "honorificSuffixes", "data6", "vnd.android.cursor.item/name", "nickNames", "data1", "vnd.android.cursor.item/nickname", "categories", "data1", "vnd.android.cursor.item/group_membership", "gender", "data1", "vnd.android.cursor.item/contact_custom_gender", "lastUpdated", "data1", "vnd.android.cursor.item/contact_custom_lastupdated", "birthday", "data1", "vnd.android.cursor.item/contact_event", "anniversary", "data1", "vnd.android.cursor.item/contact_event", "emails", "data1", "vnd.android.cursor.item/email_v2", "photos", "data15", "vnd.android.cursor.item/photo", "urls", "data1", "vnd.android.cursor.item/website", "phoneNumbers", "data1", "vnd.android.cursor.item/phone_v2", "addresses", null, "vnd.android.cursor.item/postal-address_v2", "streetAddress", "data4", "vnd.android.cursor.item/postal-address_v2", "locality", "data6", "vnd.android.cursor.item/postal-address_v2", "region", "data8", "vnd.android.cursor.item/postal-address_v2", "postalCode", "data9", "vnd.android.cursor.item/postal-address_v2", "countryName", "data10", "vnd.android.cursor.item/postal-address_v2", "organizations", "data1", "vnd.android.cursor.item/organization", "jobTitles", "data4", "vnd.android.cursor.item/organization", "notes", "data1", "vnd.android.cursor.item/note", "impp", "data1", "vnd.android.cursor.item/im"});
    public static final Map<String, String> photoDataMap = ContactConstants.createDataMap("data15");
    public static final Map<String, String> companyDataMap = ContactConstants.createDataMap("data1");
    public static final Map<String, String> jobtitleDataMap = ContactConstants.createDataMap("data4");
    public static final Map<String, String> noteDataMap = ContactConstants.createDataMap("data1");
    public static final Map<String, String> emailDataMap = ContactConstants.createValueMap("data1");
    public static final Map<String, String> websiteDataMap = ContactConstants.createValueMap("data1");
    public static final Map<String, String> phoneDataMap = ContactConstants.createValueMap("data1");
    public static final Map<String, String> imDataMap = ContactConstants.createValueMap("data1");
    public static final Map<String, String> addressDataMap = ContactConstants.createStringMap(new String[]{"data4", "streetAddress", "data6", "locality", "data8", "region", "data9", "postalCode", "data10", "countryName"});
    public static final Map<String, String> emailTypeMap = new HashMap<String, String>(){
        {
            this.put("type", "data2");
            this.put("isPrimary", "is_primary");
            this.put("isSuperPrimary", "is_super_primary");
        }
    };
    public static final Map<String, String> websiteTypeMap = new HashMap<String, String>(){
        {
            this.put("type", "data2");
            this.put("isPrimary", "is_primary");
            this.put("isSuperPrimary", "is_super_primary");
        }
    };
    public static final Map<String, String> addressTypeMap = new HashMap<String, String>(){
        {
            this.put("type", "data2");
            this.put("isPrimary", "is_primary");
            this.put("isSuperPrimary", "is_super_primary");
        }
    };
    public static final Map<String, String> phoneTypeMap = new HashMap<String, String>(){
        {
            this.put("type", "data2");
            this.put("isPrimary", "is_primary");
            this.put("isSuperPrimary", "is_super_primary");
        }
    };
    public static final Map<String, String> imTypeMap = new HashMap<String, String>(){
        {
            this.put("type", "data2");
            this.put("isPrimary", "is_primary");
            this.put("isSuperPrimary", "is_super_primary");
        }
    };
    public static final Map<String, Integer> emailTypeValuesMap = new HashMap<String, Integer>(){
        {
            this.put("work", 2);
            this.put("home", 1);
            this.put("mobile", 4);
        }
    };
    public static final Map<String, Integer> websiteTypeValuesMap = new HashMap<String, Integer>(){
        {
            this.put("blog", 2);
            this.put("ftp", 6);
            this.put("home", 4);
            this.put("homepage", 1);
            this.put("other", 7);
            this.put("profile", 3);
            this.put("work", 5);
        }
    };
    public static final Map<String, Integer> addressTypeValuesMap = new HashMap<String, Integer>(){
        {
            this.put("work", 2);
            this.put("home", 1);
            this.put("other", 3);
        }
    };
    public static final Map<String, Integer> phoneTypeValuesMap = new HashMap<String, Integer>(){
        {
            this.put("home", 1);
            this.put("mobile", 2);
            this.put("work", 3);
            this.put("fax_work", 4);
            this.put("fax_home", 5);
            this.put("pager", 6);
            this.put("other", 7);
            this.put("callback", 8);
            this.put("car", 9);
            this.put("company_main", 10);
            this.put("isdn", 11);
            this.put("main", 12);
            this.put("other_fax", 13);
            this.put("radio", 14);
            this.put("telex", 15);
            this.put("tty_tdd", 16);
            this.put("mobile", 17);
            this.put("work_pager", 18);
            this.put("assistant", 19);
            this.put("mms", 20);
        }
    };
    public static final Map<String, Integer> imTypeValuesMap = new HashMap<String, Integer>(){
        {
            this.put("work", 2);
            this.put("home", 1);
            this.put("other", 3);
        }
    };
    public static final Map<String, Integer> imProtocolMap = new HashMap<String, Integer>(){
        {
            this.put("aim", 0);
            this.put("msn", 1);
            this.put("ymsgr", 2);
            this.put("skype", 3);
            this.put("qq", 4);
            this.put("gtalk", 5);
            this.put("icq", 6);
            this.put("jabber", 7);
            this.put("netmeeting", 8);
        }
    };
    public static final List<ContactMap> contactMapList = new ArrayList<ContactMap>(){
        {
            this.add(new ContactMap("emails", emailDataMap, emailTypeMap, emailTypeValuesMap));
            this.add(new ContactMap("photos", photoDataMap, null, null));
            this.add(new ContactMap("urls", websiteDataMap, websiteTypeMap, websiteTypeValuesMap));
            this.add(new ContactMap("phoneNumbers", phoneDataMap, phoneTypeMap, phoneTypeValuesMap));
            this.add(new ContactMap("addresses", addressDataMap, addressTypeMap, addressTypeValuesMap));
            this.add(new ContactMap("organizations", companyDataMap, null, null));
            this.add(new ContactMap("jobTitles", jobtitleDataMap, null, null));
            this.add(new ContactMap("notes", noteDataMap, null, null));
            this.add(new ContactMap("impp", imDataMap, imTypeMap, imTypeValuesMap));
        }
    };

    private static Map<String, Pair<String, String>> createTripleMap(String[] triplets) {
        HashMap<String, Pair> result = new HashMap<String, Pair>();
        for (int i = 0; i < triplets.length; i += 3) {
            result.put(triplets[i], new Pair((Object)triplets[i + 1], (Object)triplets[i + 2]));
        }
        return Collections.unmodifiableMap(result);
    }

    private static Map<String, String> createStringMap(String[] pairs) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < pairs.length; i += 2) {
            result.put(pairs[i], pairs[i + 1]);
        }
        return Collections.unmodifiableMap(result);
    }

    private static Map<String, String> createDataMap(String name) {
        return ContactConstants.createStringMap(new String[]{"data", name});
    }

    private static Map<String, String> createValueMap(String name) {
        return ContactConstants.createStringMap(new String[]{name, "value"});
    }

    public static class ContactMap {
        public String mName;
        public String mMimeType;
        public Map<String, String> mDataMap;
        public Map<String, String> mTypeMap;
        public Map<String, Integer> mTypeValueMap;

        public ContactMap(String n, Map<String, String> datas, Map<String, String> types, Map<String, Integer> typeValues) {
            this.mName = n;
            this.mMimeType = (String)ContactConstants.contactDataMap.get((Object)n).second;
            this.mDataMap = datas;
            this.mTypeMap = types;
            this.mTypeValueMap = typeValues;
        }
    }
}

