/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal.extension.api.contacts;

import android.content.ContentResolver;
import android.database.ContentObserver;
import android.database.Cursor;
import android.os.Handler;
import android.provider.ContactsContract;
import android.util.Log;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xwalk.core.internal.extension.api.contacts.Contacts;

public class ContactEventListener
extends ContentObserver {
    private static final String TAG = "ContactsEventListener";
    private final Contacts mContacts;
    private final ContentResolver mResolver;
    private boolean mIsListening = false;
    private HashMap<String, String> mRawID2ContactIDMaps;
    private HashMap<String, String> mRawID2VersionMaps;
    private HashSet<String> mContactIDs;

    public ContactEventListener(Handler handler, Contacts instance, ContentResolver resolver) {
        super(handler);
        this.mContacts = instance;
        this.mResolver = resolver;
    }

    public void onChange(boolean selfChange) {
        super.onChange(selfChange);
        if (!this.mIsListening) {
            return;
        }
        this.notifyChanges(false);
    }

    protected void startListening() {
        if (this.mIsListening) {
            return;
        }
        this.mIsListening = true;
        this.mContactIDs = this.getAllContactIDs();
        this.readAllRawContactInfo();
    }

    protected void onResume() {
        if (!this.mIsListening) {
            return;
        }
        this.notifyChanges(true);
    }

    private void notifyChanges(boolean bResume) {
        try {
            JSONObject jsonOutput = new JSONObject();
            HashSet<String> contactIDs = this.getAllContactIDs();
            if (bResume || contactIDs.size() > this.mContactIDs.size()) {
                HashSet<String> addedIDs = this.getDiffSet(contactIDs, this.mContactIDs);
                if (!bResume || addedIDs.size() > 0) {
                    jsonOutput.put("added", (Object)this.convertSet2JSONArray(addedIDs));
                }
            } else if (bResume || contactIDs.size() < this.mContactIDs.size()) {
                HashSet<String> removedIDs = this.getDiffSet(this.mContactIDs, contactIDs);
                if (!bResume || contactIDs.size() < 0) {
                    jsonOutput.put("removed", (Object)this.convertSet2JSONArray(removedIDs));
                }
            } else {
                HashSet<String> commonIDs = bResume ? this.getIntersectSet(this.mContactIDs, contactIDs) : contactIDs;
                HashSet<String> modifiedIDs = this.compareAllRawContactInfo(commonIDs);
                if (modifiedIDs.size() != 0) {
                    jsonOutput.put("modified", (Object)this.convertSet2JSONArray(modifiedIDs));
                }
            }
            this.notifyContactChanged(jsonOutput);
            this.mContactIDs = contactIDs;
            this.readAllRawContactInfo();
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)("notifyChanges: " + e.toString()));
        }
    }

    private void notifyContactChanged(JSONObject outObject) {
        if (outObject == null || outObject.length() == 0) {
            return;
        }
        try {
            JSONObject jsonOutput = new JSONObject();
            jsonOutput.put("reply", (Object)"contactschange");
            jsonOutput.put("data", (Object)outObject);
            this.mContacts.broadcastMessage(jsonOutput.toString());
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)("notifyContactChanged: " + e.toString()));
        }
    }

    private JSONArray convertSet2JSONArray(HashSet<String> set) {
        JSONArray jsonArray = new JSONArray();
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            jsonArray.put((Object)iterator.next());
        }
        return jsonArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashSet<String> getAllContactIDs() {
        try (Cursor c = null;){
            c = this.mResolver.query(ContactsContract.Contacts.CONTENT_URI, null, null, null, null);
            HashSet<String> contactIDs = new HashSet<String>();
            while (c.moveToNext()) {
                String contactID = c.getString(c.getColumnIndex("_id"));
                contactIDs.add(contactID);
            }
            HashSet<String> hashSet = contactIDs;
            return hashSet;
        }
    }

    private HashSet<String> getIntersectSet(HashSet<String> setA, HashSet<String> setB) {
        HashSet<String> resultSet = new HashSet<String>();
        resultSet.addAll(setA);
        resultSet.retainAll(setB);
        return resultSet;
    }

    private HashSet<String> getDiffSet(HashSet<String> setA, HashSet<String> setB) {
        HashSet<String> resultSet = new HashSet<String>();
        resultSet.addAll(setA);
        resultSet.removeAll(setB);
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAllRawContactInfo() {
        try (Cursor c = null;){
            c = this.mResolver.query(ContactsContract.RawContacts.CONTENT_URI, null, null, null, null);
            this.mRawID2ContactIDMaps = new HashMap();
            this.mRawID2VersionMaps = new HashMap();
            while (c.moveToNext()) {
                String contactID = c.getString(c.getColumnIndex("contact_id"));
                String rawContactID = c.getString(c.getColumnIndex("_id"));
                String version = c.getString(c.getColumnIndex("version"));
                this.mRawID2ContactIDMaps.put(rawContactID, contactID);
                this.mRawID2VersionMaps.put(rawContactID, version);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashSet<String> compareAllRawContactInfo(HashSet<String> commonSet) {
        HashSet<String> contactIDs = null;
        HashMap<String, String> compareMaps = null;
        try (Cursor c = null;){
            c = this.mResolver.query(ContactsContract.RawContacts.CONTENT_URI, null, null, null, null);
            contactIDs = new HashSet<String>();
            compareMaps = new HashMap<String, String>();
            while (c.moveToNext()) {
                String rawContactID = c.getString(c.getColumnIndex("_id"));
                String version = c.getString(c.getColumnIndex("version"));
                compareMaps.put(rawContactID, version);
            }
        }
        for (String rawContactID : compareMaps.keySet()) {
            String contactID;
            String newVersion = (String)compareMaps.get(rawContactID);
            String oldVersion = this.mRawID2VersionMaps.get(rawContactID);
            if (oldVersion != null && newVersion.equals(oldVersion) || (contactID = this.mRawID2ContactIDMaps.get(rawContactID)) == null || !commonSet.contains(contactID)) continue;
            contactIDs.add(contactID);
        }
        return contactIDs;
    }
}

