/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal.extension.api.contacts;

import android.content.ContentResolver;
import android.database.Cursor;
import android.os.Build;
import android.provider.ContactsContract;
import android.util.Log;
import android.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xwalk.core.internal.extension.api.contacts.ContactConstants;
import org.xwalk.core.internal.extension.api.contacts.ContactJson;
import org.xwalk.core.internal.extension.api.contacts.ContactUtils;

public class ContactFinder {
    private ContactUtils mUtils;
    private static final String TAG = "ContactFinder";

    public ContactFinder(ContentResolver resolver) {
        this.mUtils = new ContactUtils(resolver);
    }

    private JSONObject addString(JSONObject o, Cursor c, String jsonName, String dataName) {
        try {
            String value = c.getString(c.getColumnIndex(dataName));
            if (o == null) {
                o = new JSONObject();
            }
            if (value != null) {
                o.put(jsonName, (Object)value);
            }
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)("addString - Failed to build json data: " + e.toString()));
        }
        return o;
    }

    private JSONArray addString(JSONArray array, Cursor c, String dataName) {
        String value;
        if (array == null) {
            array = new JSONArray();
        }
        if ((value = c.getString(c.getColumnIndex(dataName))) != null) {
            array.put((Object)value);
        }
        return array;
    }

    private JSONObject addArrayTop(JSONObject o, Cursor c, String jsonName, String dataName, Map<String, Integer> typeValuesMap) {
        String nameString = ContactUtils.getKeyFromValue(typeValuesMap, Integer.valueOf(c.getString(c.getColumnIndex(dataName))));
        return this.ensureAddArrayTop(o, c, jsonName, nameString);
    }

    private JSONObject addArrayTop(JSONObject o, Cursor c, String jsonName, String dataName) {
        String nameString = c.getString(c.getColumnIndex(dataName));
        return this.ensureAddArrayTop(o, c, jsonName, nameString);
    }

    private JSONObject ensureAddArrayTop(JSONObject o, Cursor c, String jsonName, String nameString) {
        try {
            if (o == null) {
                o = new JSONObject();
            }
            if (nameString != null) {
                JSONArray nameArray = new JSONArray();
                nameArray.put((Object)nameString);
                o.put(jsonName, (Object)nameArray);
            }
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)("ensureAddArrayTop - Failed to build json data: " + e.toString()));
        }
        return o;
    }

    private JSONArray addTypeArray(JSONArray array, Cursor c, String data, Map<String, String> typeMap, Map<String, Integer> typeValuesMap) {
        try {
            String primary;
            if (array == null) {
                array = new JSONArray();
            }
            String preferred = c.getString(c.getColumnIndex(primary = typeMap.get("isSuperPrimary"))).equals("1") ? "true" : "false";
            JSONObject o = new JSONObject();
            o.put("preferred", (Object)preferred);
            this.addArrayTop(o, c, "types", typeMap.get("type"), typeValuesMap);
            String value = c.getString(c.getColumnIndex(data));
            if (c.getString(c.getColumnIndex("mimetype")).equals("vnd.android.cursor.item/im")) {
                int protocol = c.getInt(c.getColumnIndex("data5"));
                String prefix = ContactUtils.getKeyFromValue(ContactConstants.imProtocolMap, protocol);
                value = prefix + ':' + value;
            }
            o.put("value", (Object)value);
            array.put((Object)o);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)("addTypeArray - Failed to build json data: " + e.toString()));
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getContactIds(FindOption findOption) {
        HashSet<String> ids = null;
        try (Cursor c = null;){
            c = this.mUtils.mResolver.query(ContactsContract.Data.CONTENT_URI, null, findOption.mWhere, findOption.mWhereArgs, findOption.mSortOrder);
            ids = new HashSet<String>();
            while (c.moveToNext()) {
                ids.add(String.valueOf(c.getLong(c.getColumnIndex("contact_id"))));
            }
            HashSet<String> hashSet = ids;
            return hashSet;
        }
    }

    private String getSortOrder(List<String> sortBy, String sortOrder) {
        if (sortOrder == null) {
            return null;
        }
        String suffix = "";
        if (sortOrder.equals("ascending")) {
            suffix = " ASC";
        } else if (sortOrder.equals("descending")) {
            suffix = " DESC";
        }
        String order = "";
        for (String s : sortBy) {
            Pair<String, String> fields = ContactConstants.contactDataMap.get(s);
            if (fields == null) continue;
            order = order + (String)fields.first + suffix + ",";
        }
        return order != "" ? order.substring(0, order.length() - 1) : null;
    }

    private JSONArray getContacts(Set<String> contactIds, String sortOrder, String sortByMimeType, Long resultsLimit) {
        String where = null;
        String[] whereArgs = null;
        JSONArray returnArray = new JSONArray();
        if (contactIds.size() == 0) {
            return returnArray;
        }
        where = "contact_id in (" + ContactUtils.makeQuestionMarkList(contactIds) + ")";
        whereArgs = contactIds.toArray(new String[contactIds.size()]);
        LinkedHashMap<Long, ContactData> dataMap = null;
        try (Cursor c = null;){
            c = this.mUtils.mResolver.query(ContactsContract.Data.CONTENT_URI, null, where, whereArgs, sortOrder);
            dataMap = new LinkedHashMap<Long, ContactData>();
            if (sortOrder != null) {
                while (c.moveToNext()) {
                    long id2;
                    String mime = c.getString(c.getColumnIndex("mimetype"));
                    if (!mime.equals(sortByMimeType) || dataMap.containsKey(id2 = c.getLong(c.getColumnIndex("contact_id")))) continue;
                    dataMap.put(id2, new ContactData());
                }
                c.moveToFirst();
            }
            while (c.moveToNext()) {
                String mime;
                long id3 = c.getLong(c.getColumnIndex("contact_id"));
                if (!dataMap.containsKey(id3)) {
                    dataMap.put(id3, new ContactData());
                }
                ContactData d = (ContactData)dataMap.get(id3);
                if (d.lastUpdated == null && Build.VERSION.SDK_INT >= 18) {
                    d.lastUpdated = this.mUtils.getLastUpdated(id3);
                }
                if ((mime = c.getString(c.getColumnIndex("mimetype"))).equals("vnd.android.cursor.item/name")) {
                    d.oName = this.addString(d.oName, c, "displayName", "data1");
                    d.oName = this.addArrayTop(d.oName, c, "honorificPrefixes", "data4");
                    d.oName = this.addArrayTop(d.oName, c, "givenNames", "data2");
                    d.oName = this.addArrayTop(d.oName, c, "additionalNames", "data5");
                    d.oName = this.addArrayTop(d.oName, c, "familyNames", "data3");
                    d.oName = this.addArrayTop(d.oName, c, "honorificSuffixes", "data6");
                    continue;
                }
                if (mime.equals("vnd.android.cursor.item/nickname")) {
                    d.oName = this.addArrayTop(d.oName, c, "nicknames", "data1");
                    continue;
                }
                if (mime.equals("vnd.android.cursor.item/email_v2")) {
                    d.aEmails = this.addTypeArray(d.aEmails, c, "data1", ContactConstants.emailTypeMap, ContactConstants.emailTypeValuesMap);
                    continue;
                }
                if (mime.equals("vnd.android.cursor.item/photo")) {
                    d.aPhotos = this.addString(d.aPhotos, c, "data15");
                    continue;
                }
                if (mime.equals("vnd.android.cursor.item/website")) {
                    d.aUrls = this.addTypeArray(d.aUrls, c, "data1", ContactConstants.websiteTypeMap, ContactConstants.websiteTypeValuesMap);
                    continue;
                }
                if (mime.equals("vnd.android.cursor.item/group_membership")) {
                    String title = this.mUtils.getGroupTitle(c.getString(c.getColumnIndex("data1")));
                    if (title == null) continue;
                    if (d.aCategories == null) {
                        d.aCategories = new JSONArray();
                    }
                    d.aCategories.put((Object)title);
                    continue;
                }
                if (mime.equals("vnd.android.cursor.item/postal-address_v2")) {
                    d.aAddresses = this.addTypeArray(d.aAddresses, c, "data1", ContactConstants.addressTypeMap, ContactConstants.addressTypeValuesMap);
                    continue;
                }
                if (mime.equals("vnd.android.cursor.item/phone_v2")) {
                    d.aNumbers = this.addTypeArray(d.aNumbers, c, "data1", ContactConstants.phoneTypeMap, ContactConstants.phoneTypeValuesMap);
                    continue;
                }
                if (mime.equals("vnd.android.cursor.item/organization")) {
                    d.aOrganizations = this.addString(d.aOrganizations, c, "data1");
                    continue;
                }
                if (mime.equals("vnd.android.cursor.item/organization")) {
                    d.aJobTitles = this.addString(d.aJobTitles, c, "data4");
                    continue;
                }
                if (mime.equals("vnd.android.cursor.item/contact_event")) {
                    int type = Integer.valueOf(c.getString(c.getColumnIndex("data2")));
                    if (type == 3) {
                        d.birthday = c.getString(c.getColumnIndex("data1"));
                        continue;
                    }
                    if (type != 1) continue;
                    d.anniversary = c.getString(c.getColumnIndex("data1"));
                    continue;
                }
                if (mime.equals("vnd.android.cursor.item/note")) {
                    d.aNotes = this.addString(d.aNotes, c, "data1");
                    continue;
                }
                if (mime.equals("vnd.android.cursor.item/im")) {
                    d.aImpp = this.addTypeArray(d.aImpp, c, "data1", ContactConstants.imTypeMap, ContactConstants.imTypeValuesMap);
                    continue;
                }
                if (!mime.equals("vnd.android.cursor.item/contact_custom_gender")) continue;
                d.gender = c.getString(c.getColumnIndex("data1"));
            }
        }
        int i = 0;
        for (Map.Entry entry : dataMap.entrySet()) {
            if (resultsLimit != null && (long)(++i) > resultsLimit) break;
            JSONObject o = ((ContactData)entry.getValue()).ensurePut((Long)entry.getKey());
            returnArray.put((Object)o);
        }
        return returnArray;
    }

    private FindOption createFindIDOption(String findString) {
        String value;
        ContactJson findJson = new ContactJson(findString);
        String string2 = value = findString != null ? findJson.getString("value") : null;
        if (value == null || value.equals("") || findString.equals("")) {
            return new FindOption(null, null, null);
        }
        ArrayList<Object> args = new ArrayList<Object>();
        List<String> fields = findJson.getStringArray("fields");
        String operator = findJson.getString("operator");
        if (operator == null) {
            return new FindOption(null, null, null);
        }
        if (operator.equals("is")) {
            operator = " = ";
        } else if (operator.equals("contains")) {
            operator = " LIKE ";
            value = "%" + value + "%";
        } else {
            Log.e((String)TAG, (String)("find - Wrong Operator: [" + operator + "], should be 'is' or 'contains'"));
            return null;
        }
        String where = "";
        for (String field : fields) {
            String column = ContactConstants.findFieldMap.get(field);
            if (column == null) continue;
            Pair<String, String> name = ContactConstants.contactDataMap.get(column);
            where = where + (String)name.first + operator + " ? AND " + "mimetype" + " = ? or ";
            args.add(value);
            args.add(name.second);
        }
        if (where == "") {
            return new FindOption(null, null, null);
        }
        where = where.substring(0, where.length() - 3);
        String[] whereArgs = args.toArray(new String[args.size()]);
        return new FindOption(where, whereArgs, null);
    }

    public JSONArray find(String findString) {
        Set<String> ids = this.getContactIds(this.createFindIDOption(findString));
        if (ids == null) {
            return new JSONArray();
        }
        ContactJson findJson = new ContactJson(findString);
        List<String> sortBy = findJson.getStringArray("sortBy");
        String order = this.getSortOrder(sortBy, findJson.getString("sortOrder"));
        String orderMimeType = order == null ? null : (String)ContactConstants.contactDataMap.get((Object)sortBy.get((int)0)).second;
        String resultsLimit = findJson.getString("resultsLimit");
        Long resultsLimitLong = resultsLimit == null ? null : Long.valueOf(resultsLimit);
        return this.getContacts(ids, order, orderMimeType, resultsLimitLong);
    }

    private class ContactData {
        public String lastUpdated;
        public JSONObject oName;
        public JSONArray aEmails;
        public JSONArray aPhotos;
        public JSONArray aUrls;
        public JSONArray aCategories;
        public JSONArray aAddresses;
        public JSONArray aNumbers;
        public JSONArray aOrganizations;
        public JSONArray aJobTitles;
        public String birthday;
        public JSONArray aNotes;
        public JSONArray aImpp;
        public String anniversary;
        public String gender;

        private ContactData() {
        }

        public JSONObject ensurePut(long id2) {
            JSONObject o = new JSONObject();
            try {
                o.put("id", id2);
            }
            catch (JSONException e) {
                Log.e((String)ContactFinder.TAG, (String)("ensurePut - Failed to build json data: " + e.toString()));
            }
            this.ensurePut(o, "name", this.oName);
            this.ensurePut(o, "lastUpdated", this.lastUpdated);
            this.ensurePut(o, "emails", this.aEmails);
            this.ensurePut(o, "photos", this.aPhotos);
            this.ensurePut(o, "urls", this.aUrls);
            this.ensurePut(o, "categories", this.aCategories);
            this.ensurePut(o, "addresses", this.aAddresses);
            this.ensurePut(o, "phoneNumbers", this.aNumbers);
            this.ensurePut(o, "organizations", this.aOrganizations);
            this.ensurePut(o, "jobTitles", this.aJobTitles);
            this.ensurePut(o, "birthday", this.birthday);
            this.ensurePut(o, "notes", this.aNotes);
            this.ensurePut(o, "impp", this.aImpp);
            this.ensurePut(o, "anniversary", this.anniversary);
            this.ensurePut(o, "gender", this.gender);
            return o;
        }

        private <T> void ensurePut(JSONObject o, String jsonName, T t) {
            try {
                if (t != null) {
                    o.put(jsonName, t);
                }
            }
            catch (JSONException e) {
                Log.e((String)ContactFinder.TAG, (String)("ensurePut - Failed to add json data: " + e.toString()));
            }
        }
    }

    public static class FindOption {
        public String mWhere;
        public String[] mWhereArgs;
        public String mSortOrder;

        public FindOption(String where, String[] whereArgs, String sortOrder) {
            this.mWhere = where;
            this.mWhereArgs = whereArgs;
            this.mSortOrder = sortOrder;
        }
    }
}

