/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal.extension.api.contacts;

import android.content.ContentProviderOperation;
import android.content.ContentResolver;
import android.content.OperationApplicationException;
import android.net.Uri;
import android.os.Build;
import android.os.RemoteException;
import android.provider.ContactsContract;
import android.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xwalk.core.internal.extension.api.contacts.ContactConstants;
import org.xwalk.core.internal.extension.api.contacts.ContactJson;
import org.xwalk.core.internal.extension.api.contacts.ContactUtils;

public class ContactSaver {
    private ContactUtils mUtils;
    private static final String TAG = "ContactSaver";
    private JSONObject mContact;
    private ContactJson mJson;
    private String mId;
    private boolean mIsUpdate;
    private ArrayList<ContentProviderOperation> mOps;

    public ContactSaver(ContentResolver resolver) {
        this.mUtils = new ContactUtils(resolver);
    }

    private ContentProviderOperation.Builder newUpdateBuilder(String mimeType) {
        ContentProviderOperation.Builder builder = ContentProviderOperation.newUpdate((Uri)ContactsContract.Data.CONTENT_URI);
        builder.withSelection("contact_id=? AND mimetype=?", new String[]{this.mId, mimeType});
        return builder;
    }

    private ContentProviderOperation.Builder newInsertBuilder(String mimeType) {
        ContentProviderOperation.Builder builder = ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI);
        builder.withValueBackReference("raw_contact_id", 0);
        builder.withValue("mimetype", (Object)mimeType);
        return builder;
    }

    private ContentProviderOperation.Builder newInsertFieldBuilder(String mimeType) {
        String rawId = this.mUtils.getRawId(this.mId);
        if (rawId == null) {
            Log.e((String)TAG, (String)("Failed to create builder to insert field of " + this.mId));
            return null;
        }
        ContentProviderOperation.Builder builder = ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI);
        builder.withValue("raw_contact_id", (Object)this.mUtils.getRawId(this.mId));
        builder.withValue("mimetype", (Object)mimeType);
        return builder;
    }

    private ContentProviderOperation.Builder newInsertContactOrFieldBuilder(String mimeType) {
        return this.mIsUpdate ? this.newInsertFieldBuilder(mimeType) : this.newInsertBuilder(mimeType);
    }

    private ContentProviderOperation.Builder newBuilder(String mimeType) {
        return this.mIsUpdate ? this.newUpdateBuilder(mimeType) : this.newInsertBuilder(mimeType);
    }

    private void buildByArray(ContactConstants.ContactMap contactMap) {
        if (!this.mContact.has(contactMap.mName)) {
            return;
        }
        if (this.mIsUpdate) {
            this.mUtils.cleanByMimeType(this.mId, contactMap.mMimeType);
        }
        try {
            JSONArray fields = this.mContact.getJSONArray(contactMap.mName);
            for (int i = 0; i < fields.length(); ++i) {
                ContactJson json = new ContactJson(fields.getJSONObject(i));
                List<String> typeList = json.getStringArray("types");
                if (typeList == null || typeList.isEmpty()) continue;
                String type = typeList.get(0);
                Integer iType = contactMap.mTypeValueMap.get(type);
                ContentProviderOperation.Builder builder = this.newInsertContactOrFieldBuilder(contactMap.mMimeType);
                if (builder == null) {
                    return;
                }
                if (json.getBoolean("preferred")) {
                    builder.withValue(contactMap.mTypeMap.get("isPrimary"), (Object)1);
                    builder.withValue(contactMap.mTypeMap.get("isSuperPrimary"), (Object)1);
                }
                if (iType != null) {
                    builder.withValue(contactMap.mTypeMap.get("type"), (Object)iType);
                }
                for (Map.Entry<String, String> entry : contactMap.mDataMap.entrySet()) {
                    String value = json.getString(entry.getValue());
                    if (contactMap.mName.equals("impp")) {
                        int colonIdx = value.indexOf(58);
                        if (-1 == colonIdx) continue;
                        String protocol = value.substring(0, colonIdx);
                        builder.withValue("data5", (Object)ContactConstants.imProtocolMap.get(protocol));
                        value = value.substring(colonIdx + 1);
                    }
                    builder.withValue(entry.getKey(), (Object)value);
                }
                this.mOps.add(builder.build());
            }
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)("Failed to parse json data of " + contactMap.mName + ": " + e.toString()));
        }
    }

    private void buildByArray(String mimeType, String data, List<String> dataEntries) {
        if (this.mIsUpdate) {
            this.mUtils.cleanByMimeType(this.mId, mimeType);
        }
        for (String entry : dataEntries) {
            ContentProviderOperation.Builder builder = this.newInsertContactOrFieldBuilder(mimeType);
            if (builder == null) {
                return;
            }
            builder.withValue(data, (Object)entry);
            this.mOps.add(builder.build());
        }
    }

    private void buildByArray(ContactConstants.ContactMap contactMap, String data, List<String> dataEntries) {
        if (this.mContact.has(contactMap.mName)) {
            this.buildByArray(contactMap.mMimeType, data, dataEntries);
        }
    }

    private void buildByDate(String name, String mimeType, String data, String type, int dateType) {
        if (!this.mContact.has(name)) {
            return;
        }
        String fullDateString = this.mJson.getString(name);
        String dateString = this.mUtils.dateTrim(fullDateString);
        ContentProviderOperation.Builder builder = this.newBuilder(mimeType);
        builder.withValue(data, (Object)dateString);
        if (type != null) {
            builder.withValue(type, (Object)dateType);
        }
        this.mOps.add(builder.build());
    }

    private void buildByEvent(String eventName, int eventType) {
        this.buildByDate(eventName, "vnd.android.cursor.item/contact_event", "data1", "data2", eventType);
    }

    private void buildByContactMapList() {
        for (ContactConstants.ContactMap contactMap : ContactConstants.contactMapList) {
            if (contactMap.mTypeMap != null) {
                this.buildByArray(contactMap);
                continue;
            }
            this.buildByArray(contactMap, contactMap.mDataMap.get("data"), this.mJson.getStringArray(contactMap.mName));
        }
    }

    private void PutToContact(String name, String value) {
        if (name == null) {
            return;
        }
        try {
            this.mContact.put(name, (Object)value);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)("Failed to set " + name + " = " + value + " for contact" + e.toString()));
        }
    }

    public JSONObject save(String saveString) {
        this.mOps = new ArrayList();
        try {
            this.mContact = new JSONObject(saveString);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)("Failed to parse json data: " + e.toString()));
            return new JSONObject();
        }
        this.mJson = new ContactJson(this.mContact);
        ContentProviderOperation.Builder builder = null;
        this.mId = this.mJson.getString("id");
        this.mIsUpdate = this.mUtils.hasID(this.mId);
        Set<String> oldRawIds = null;
        if (!this.mIsUpdate) {
            oldRawIds = this.mUtils.getCurrentRawIds();
            this.mId = null;
            builder = ContentProviderOperation.newInsert((Uri)ContactsContract.RawContacts.CONTENT_URI);
            builder.withValue("account_type", null);
            builder.withValue("account_name", null);
            this.mOps.add(builder.build());
        }
        if (this.mContact.has("name")) {
            JSONObject name = this.mJson.getObject("name");
            ContactJson nameJson = new ContactJson(name);
            builder = this.newBuilder("vnd.android.cursor.item/name");
            builder.withValue("data1", (Object)nameJson.getString("displayName"));
            builder.withValue("data3", (Object)nameJson.getFirstValue("familyNames"));
            builder.withValue("data2", (Object)nameJson.getFirstValue("givenNames"));
            builder.withValue("data5", (Object)nameJson.getFirstValue("additionalNames"));
            builder.withValue("data4", (Object)nameJson.getFirstValue("honorificPrefixes"));
            builder.withValue("data6", (Object)nameJson.getFirstValue("honorificSuffixes"));
            this.mOps.add(builder.build());
            if (name.has("nicknames")) {
                builder = this.newBuilder("vnd.android.cursor.item/nickname");
                builder.withValue("data1", (Object)nameJson.getFirstValue("nicknames"));
                this.mOps.add(builder.build());
            }
        }
        if (this.mContact.has("categories")) {
            ArrayList<String> groupIds = new ArrayList<String>();
            for (String groupTitle : this.mJson.getStringArray("categories")) {
                groupIds.add(this.mUtils.getEnsuredGroupId(groupTitle));
            }
            this.buildByArray("vnd.android.cursor.item/group_membership", "data1", groupIds);
        }
        if (this.mContact.has("gender")) {
            String gender = this.mJson.getString("gender");
            if (Arrays.asList("male", "female", "other", "none", "unknown").contains(gender)) {
                builder = this.newBuilder("vnd.android.cursor.item/contact_custom_gender");
                builder.withValue("data1", (Object)gender);
                this.mOps.add(builder.build());
            }
        }
        this.buildByEvent("birthday", 3);
        this.buildByEvent("anniversary", 1);
        this.buildByContactMapList();
        try {
            this.mUtils.mResolver.applyBatch("com.android.contacts", this.mOps);
        }
        catch (Exception e) {
            if (e instanceof RemoteException || e instanceof OperationApplicationException || e instanceof SecurityException) {
                Log.e((String)TAG, (String)("Failed to apply batch: " + e.toString()));
                return new JSONObject();
            }
            throw new RuntimeException(e);
        }
        if (!this.mIsUpdate) {
            Set<String> newRawIds = this.mUtils.getCurrentRawIds();
            if (newRawIds == null) {
                return new JSONObject();
            }
            newRawIds.removeAll(oldRawIds);
            if (newRawIds.size() != 1) {
                Log.e((String)TAG, (String)("Something wrong after batch applied, new raw ids are: " + newRawIds.toString()));
                return this.mContact;
            }
            this.mId = this.mUtils.getId(newRawIds.iterator().next());
            this.PutToContact("id", this.mId);
        }
        if (Build.VERSION.SDK_INT >= 18) {
            this.PutToContact("lastUpdated", String.valueOf(this.mUtils.getLastUpdated(Long.valueOf(this.mId))));
        }
        return this.mContact;
    }
}

