/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal.extension.api.device_capabilities;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import org.json.JSONException;
import org.json.JSONObject;
import org.xwalk.core.internal.extension.XWalkExtensionWithActivityStateListener;
import org.xwalk.core.internal.extension.api.device_capabilities.DeviceCapabilitiesCPU;
import org.xwalk.core.internal.extension.api.device_capabilities.DeviceCapabilitiesCodecs;
import org.xwalk.core.internal.extension.api.device_capabilities.DeviceCapabilitiesDisplay;
import org.xwalk.core.internal.extension.api.device_capabilities.DeviceCapabilitiesMemory;
import org.xwalk.core.internal.extension.api.device_capabilities.DeviceCapabilitiesStorage;

public class DeviceCapabilities
extends XWalkExtensionWithActivityStateListener {
    public static final String JS_API_PATH = "jsapi/device_capabilities_api.js";
    private static final String TAG = "DeviceCapabilities";
    private static final String NAME = "xwalk.experimental.system";
    private DeviceCapabilitiesCPU mCPU;
    private DeviceCapabilitiesCodecs mCodecs;
    private DeviceCapabilitiesDisplay mDisplay;
    private DeviceCapabilitiesMemory mMemory;
    private DeviceCapabilitiesStorage mStorage;

    public DeviceCapabilities(String jsApiContent, Activity activity) {
        super(NAME, jsApiContent, activity);
        Context context = activity.getApplicationContext();
        this.mCPU = new DeviceCapabilitiesCPU(this);
        this.mCodecs = new DeviceCapabilitiesCodecs(this);
        this.mDisplay = new DeviceCapabilitiesDisplay(this, context);
        this.mMemory = new DeviceCapabilitiesMemory(this, context);
        this.mStorage = new DeviceCapabilitiesStorage(this, activity);
    }

    private void handleMessage(int instanceID, String message) {
        try {
            JSONObject jsonInput = new JSONObject(message);
            String cmd = jsonInput.getString("cmd");
            if (cmd.equals("addEventListener")) {
                String eventName = jsonInput.getString("eventName");
                this.handleAddEventListener(eventName);
            } else {
                String asyncCallId = jsonInput.getString("asyncCallId");
                this.handleGetDeviceInfo(instanceID, asyncCallId, cmd);
            }
        }
        catch (JSONException e) {
            this.printErrorMessage(e);
        }
    }

    private void handleGetDeviceInfo(int instanceID, String asyncCallId, String cmd) {
        try {
            JSONObject jsonOutput = new JSONObject();
            if (cmd.equals("getCPUInfo")) {
                jsonOutput.put("data", (Object)this.mCPU.getInfo());
            } else if (cmd.equals("getCodecsInfo")) {
                jsonOutput.put("data", (Object)this.mCodecs.getInfo());
            } else if (cmd.equals("getDisplayInfo")) {
                jsonOutput.put("data", (Object)this.mDisplay.getInfo());
            } else if (cmd.equals("getMemoryInfo")) {
                jsonOutput.put("data", (Object)this.mMemory.getInfo());
            } else if (cmd.equals("getStorageInfo")) {
                jsonOutput.put("data", (Object)this.mStorage.getInfo());
            }
            jsonOutput.put("asyncCallId", (Object)asyncCallId);
            this.postMessage(instanceID, jsonOutput.toString());
        }
        catch (JSONException e) {
            this.printErrorMessage(e);
        }
    }

    private void handleAddEventListener(String eventName) {
        if (eventName.equals("storageattach") || eventName.equals("storagedetach")) {
            this.mStorage.registerListener();
        }
    }

    protected void printErrorMessage(JSONException e) {
        Log.e((String)TAG, (String)e.toString());
    }

    protected JSONObject setErrorMessage(String error) {
        JSONObject out = new JSONObject();
        JSONObject errorMessage = new JSONObject();
        try {
            errorMessage.put("message", (Object)error);
            out.put("error", (Object)errorMessage);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)e.toString());
        }
        return out;
    }

    @Override
    public void onMessage(int instanceID, String message) {
        if (!message.isEmpty()) {
            this.handleMessage(instanceID, message);
        }
    }

    @Override
    public void onActivityStateChange(Activity activity, int newState) {
        switch (newState) {
            case 3: {
                this.mDisplay.onResume();
                this.mStorage.onResume();
                break;
            }
            case 4: {
                this.mDisplay.onPause();
                this.mStorage.onPause();
                break;
            }
            case 6: {
                this.mDisplay.onDestroy();
                this.mStorage.onDestroy();
                break;
            }
        }
    }

    @Override
    public String onSyncMessage(int instanceID, String message) {
        return null;
    }
}

