/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal.extension.api.device_capabilities;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.json.JSONException;
import org.json.JSONObject;
import org.xwalk.core.internal.extension.api.device_capabilities.DeviceCapabilities;

class DeviceCapabilitiesCPU {
    private static final String SYSTEM_INFO_STAT_FILE = "/proc/stat";
    private static final String TAG = "DeviceCapabilitiesCPU";
    private DeviceCapabilities mDeviceCapabilities;
    private int mCoreNum = 0;
    private String mCPUArch = "Unknown";
    private double mCPULoad = 0.0;

    public DeviceCapabilitiesCPU(DeviceCapabilities instance) {
        this.mDeviceCapabilities = instance;
        this.mCoreNum = Runtime.getRuntime().availableProcessors();
        this.mCPUArch = System.getProperty("os.arch");
    }

    public JSONObject getInfo() {
        this.getCPULoad();
        JSONObject out = new JSONObject();
        try {
            out.put("numOfProcessors", this.mCoreNum);
            out.put("archName", (Object)this.mCPUArch);
            out.put("load", this.mCPULoad);
        }
        catch (JSONException e) {
            return this.mDeviceCapabilities.setErrorMessage(e.toString());
        }
        return out;
    }

    private boolean getCPULoad() {
        try {
            RandomAccessFile file = new RandomAccessFile(SYSTEM_INFO_STAT_FILE, "r");
            String line = file.readLine();
            String[] arrs = line.split("\\s+");
            long total1 = 0L;
            for (int i = 1; i < arrs.length; ++i) {
                total1 += Long.parseLong(arrs[i]);
            }
            long used1 = total1 - Long.parseLong(arrs[4]);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                this.mCPULoad = 0.0;
                return false;
            }
            file.seek(0L);
            line = file.readLine();
            file.close();
            arrs = line.split("\\s+");
            long total2 = 0L;
            for (int i = 1; i < arrs.length; ++i) {
                total2 += Long.parseLong(arrs[i]);
            }
            long used2 = total2 - Long.parseLong(arrs[4]);
            this.mCPULoad = total2 == total1 ? 0.0 : (double)(used2 - used1) / (double)(total2 - total1);
        }
        catch (IOException e) {
            this.mCPULoad = 0.0;
            return false;
        }
        return true;
    }
}

