/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal.extension.api.device_capabilities;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.json.JSONException;
import org.json.JSONObject;
import org.xwalk.core.internal.extension.api.device_capabilities.DeviceCapabilities;

class DeviceCapabilitiesMemory {
    private static final String MEM_INFO_FILE = "/proc/meminfo";
    private static final String TAG = "DeviceCapabilitiesMemory";
    private DeviceCapabilities mDeviceCapabilities;
    private Context mContext;
    private long mAvailableCapacity = 0L;
    private long mCapacity = 0L;

    public DeviceCapabilitiesMemory(DeviceCapabilities instance, Context context) {
        this.mDeviceCapabilities = instance;
        this.mContext = context;
    }

    public JSONObject getInfo() {
        this.readMemoryInfo();
        JSONObject out = new JSONObject();
        try {
            out.put("capacity", this.mCapacity);
            out.put("availCapacity", this.mAvailableCapacity);
        }
        catch (JSONException e) {
            return this.mDeviceCapabilities.setErrorMessage(e.toString());
        }
        return out;
    }

    private void readMemoryInfo() {
        ActivityManager.MemoryInfo mem_info = new ActivityManager.MemoryInfo();
        ActivityManager activityManager = (ActivityManager)this.mContext.getSystemService("activity");
        activityManager.getMemoryInfo(mem_info);
        this.mCapacity = Build.VERSION.SDK_INT >= 16 ? mem_info.totalMem : this.getTotalMemFromFile();
        this.mAvailableCapacity = mem_info.availMem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getTotalMemFromFile() {
        long capacity = 0L;
        RandomAccessFile file = null;
        try {
            file = new RandomAccessFile(MEM_INFO_FILE, "r");
            String line = file.readLine();
            String[] arrs = line.split(":");
            if (!arrs[0].equals("MemTotal")) {
                long l = 0L;
                return l;
            }
            String[] values = arrs[1].trim().split("\\s+");
            capacity = Long.parseLong(values[0]) * 1024L;
        }
        catch (IOException e) {
            capacity = 0L;
            Log.e((String)TAG, (String)e.toString());
        }
        finally {
            try {
                if (file != null) {
                    file.close();
                }
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)e.toString());
            }
        }
        return capacity;
    }
}

