/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal.extension.api.device_capabilities;

import android.os.Build;
import java.util.Set;
import org.json.JSONObject;
import org.xwalk.core.internal.extension.api.device_capabilities.DeviceCapabilities;
import org.xwalk.core.internal.extension.api.device_capabilities.MediaCodec;
import org.xwalk.core.internal.extension.api.device_capabilities.MediaCodecNull;

abstract class XWalkMediaCodec {
    private static final String TAG = "XWalkMediaCodec";
    protected static final String[] AUDIO_CODEC_NAMES = new String[]{"ALAC", "MP3", "AMRNB", "AMRWB", "AAC", "G711", "VORBIS", "WMA", "FLAC", "OPUS"};
    protected static final String[] VIDEO_CODEC_NAMES = new String[]{"H263", "H264", "MPEG4", "AVC", "WMV", "VP8", "Theora"};
    protected Set<AudioCodecElement> mAudioCodecsSet;
    protected Set<VideoCodecElement> mVideoCodecsSet;
    protected DeviceCapabilities mDeviceCapabilities;

    XWalkMediaCodec() {
    }

    public static XWalkMediaCodec Create(DeviceCapabilities instance) {
        XWalkMediaCodec codec = Build.VERSION.SDK_INT >= 16 ? new MediaCodec(instance) : new MediaCodecNull(instance);
        return codec;
    }

    public abstract JSONObject getCodecsInfo();

    protected class VideoCodecElement {
        public String codecName;
        public boolean isEncoder;
        public boolean hwAccel;

        public VideoCodecElement(String name, boolean encoder, boolean hardware) {
            this.codecName = name;
            this.isEncoder = encoder;
            this.hwAccel = hardware;
        }

        public boolean equals(Object obj) {
            return this.codecName.equals(((VideoCodecElement)obj).codecName) && this.isEncoder == ((VideoCodecElement)obj).isEncoder && this.hwAccel == ((VideoCodecElement)obj).hwAccel;
        }

        public int hashCode() {
            return this.codecName.hashCode();
        }
    }

    protected class AudioCodecElement {
        public String codecName;

        public AudioCodecElement(String name) {
            this.codecName = name;
        }

        public boolean equals(Object obj) {
            return this.codecName.equals(((AudioCodecElement)obj).codecName);
        }

        public int hashCode() {
            return this.codecName.hashCode();
        }
    }
}

