from ScriptEngine import *
from globaldefine import *

class SpecialEffectBase:
	def __init__(self, display, layermanager, srcuin, dstuin):
		self.display = display
		self.layermanager = layermanager
		self.srcuin = srcuin
		self.dstuin = dstuin[0]
		
		self.gameobjectid = GAMEOBJECTID_AVATAR
		self.specialeffectplay = None
		self.onscriptend = self.OnScriptEnd
		self.onsize = self.OnSize		
		
		self.ImageFile = None

	def Run(self):
		RegisterEvent(self, GAMEEVENTID_ONSIZE, self.onsize)
		self.DstAvatarInfo = GetObjectInfoByID(self.dstuin, self.gameobjectid)
		if self.DstAvatarInfo != None:
			self.SetSpecialEffectParam()
			self.PlaySpecialEffect()
		
	def OnSize(self):	
		self.DstAvatarInfo = GetObjectInfoByID(self.dstuin, self.gameobjectid)
		self.ChangePosition(self.specialeffectplay)	

	def ChangePosition(self, image):
		if image != None:
			image.ChangePosition(self.DstAvatarInfo["X"], self.DstAvatarInfo["Y"])
		
	def PlaySpecialEffect(self):
		self.specialeffectplay = Image(self, self.display, self.layermanager)
		self.specialeffectplay.LoadImage(self.ImageFile)
		self.specialeffectplay.DrawImageAbove(self.DstAvatarInfo["X"], self.DstAvatarInfo["Y"], GAMEOBJECTID_SPECIALEFFECT, 1)
		self.specialeffectplay.OnDelayEvent = self.onscriptend
		
	def OnScriptEnd(self):
		ExitScript(self)
		return
