local assets=
{
    Asset("ANIM", "anim/arthas_armor.zip"),
    Asset("ATLAS", "images/inventoryimages/arthas_armor.xml")
}

local function arthas_armor_pro(inst, owner)
    inst.components.armor:SetAbsorption(1)
    
    local fx = SpawnPrefab("forcefieldfx")
    fx.entity:SetParent(owner.entity)
    fx.Transform:SetPosition(0, 0.2, 0)
    fx.Transform:SetScale(2, 2, 2)
    fx.AnimState:PlayAnimation("hit")
    fx.AnimState:PushAnimation("idle_loop")

    inst.components.armor.ontakedamage = function(inst, damage_amount)
        if owner then
            local sanity = owner.components.sanity
            if sanity then
                local unsaneness = damage_amount * 0.05
                sanity:DoDelta(-unsaneness, false)
            end
        end
    end
    inst.active = true
    --冷却时间5s
    owner:DoTaskInTime(5, function()
        fx.kill_fx(fx)
        if inst:IsValid() then
            inst.components.armor.ontakedamage = nil
            --owner.components.health.absorb = 0
            inst.components.armor:SetAbsorption(0.8)
            owner:DoTaskInTime(5, function() inst.active = false end)
        end
    end)
end
--50%概率触发
local function tryproc(inst, owner)
    if not inst.active and math.random() < 0.5 then
        arthas_armor_pro(inst, owner)
    end
end


local function onequip(inst, owner) 
        inst.procfn = function() tryproc(inst, owner) end
        owner:ListenForEvent("attacked", inst.procfn)
end

local function onunequip(inst, owner) 
        owner:RemoveEventCallback("attacked", inst.procfn)
end

local function ondrop(inst)

end


local function fn(Sim)
    local inst = CreateEntity()
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("arthas_armor")
    inst.AnimState:SetBuild("arthas_armor")
    inst.AnimState:PlayAnimation("idel")
    MakeInventoryPhysics(inst)

    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/arthas_armor.xml"
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD

    --护甲吸收0.8伤害，护甲共可吸收10000生命
    inst:AddComponent("armor")
    inst.components.armor:InitCondition(0.8, 10000)
    --inst:ListenForEvent("percentusedchange", gcPercentChanged)

    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)
    inst.components.inventoryitem:SetOnDroppedFn( ondrop )


    return inst
end
return Prefab( "common/inventory/arthas_armor", fn, assets)

