local assets=
{
	Asset("ANIM", "anim/duanjianb.zip"),
	
	Asset("ATLAS", "images/inventoryimages/duanjianb.xml"),
    Asset("IMAGE", "images/inventoryimages/duanjianb.tex"),
}

local function fn()
    
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	--inst.entity:AddSoundEmitter()
	--inst.entity:AddPhysics()
	inst.entity:AddNetwork()
	inst.entity:AddLight()
	
    MakeInventoryPhysics(inst)
	RemovePhysicsColliders(inst)

    inst.AnimState:SetBank("duanjianb")
    inst.AnimState:SetBuild("duanjianb")
    inst.AnimState:PlayAnimation("idle")

	inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )
	
	inst.Light:Enable(true)
	inst.Light:SetRadius(.5)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(238/255, 255/255, 143/255)
	
	inst.entity:SetPristine()
    if not TheWorld.ismastersim then
        return inst
    end
	
    --inst:AddComponent("edible")
    --inst.components.edible.foodtype = "ELEMENTAL"
    --inst.components.edible.hungervalue = 2
    --inst:AddComponent("tradable")
    
    inst:AddComponent("inspectable")
	

    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "duanjianb"
	inst.components.inventoryitem.atlasname = "images/inventoryimages/duanjianb.xml"
  
    return inst
end

return Prefab( "common/inventory/duanjianb", fn, assets) 
