local function fn_fx()
    local inst = CreateEntity()

    inst.entity:AddTransform()
	inst.Transform:SetScale(2,2,2)
	
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)
    RemovePhysicsColliders(inst)

    --inst.Transform:SetFourFaced()

    inst.AnimState:SetBank("fengzhishang")
    inst.AnimState:SetBuild("fengzhishang")
	--inst.AnimState:SetOrientation(ANIM_ORIENTATION.OnGround)
    --inst.AnimState:SetLayer(LAYER_BACKGROUND)
    --inst.AnimState:SetSortOrder(3)
    inst.AnimState:PlayAnimation("idle", true)

	inst:AddTag("NOCLICK")
    inst:AddTag("FX")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst.persists = false
	
	inst:AddComponent("combat")
	inst.components.combat:SetDefaultDamage(36)
	inst.components.combat:SetRange(4)
	
	inst:ListenForEvent("onhitother", function (inst, data)
		local target = data.target
		if target ~= nil and target:IsValid() then
			local impactfx = SpawnPrefab("impact")
			if impactfx ~= nil then
				local follower = impactfx.entity:AddFollower()
				follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0)
				impactfx:FacePoint(inst.Transform:GetWorldPosition())
			end
		end
	end)
	
	----
	local period = 1/30
	inst.collide_task_table = {}
	inst.collide_task_table2 = {}
	inst:DoPeriodicTask(period, function()
	
		local pt = inst:GetPosition()	
		local r = 4
		local ents = TheSim:FindEntities(pt.x, pt.y, pt.z, r)
		
		for k,v in pairs(ents) do
		
			if v and v.components.health and not v.components.health:IsDead() and v.components.combat and
				v ~= inst and v ~= inst.master and (TheNet:GetPVPEnabled() or not v:HasTag("player"))
			then
				
				if not table.contains(inst.collide_task_table, v.GUID) then
					inst.components.combat:DoAttack(v)
					v.components.combat:SuggestTarget(inst.master)
					table.insert(inst.collide_task_table, v.GUID)
				end
				
			end
			
			if v.components.workable ~= nil and 
				(v:HasTag("tree") or v:HasTag("boulder") or string.sub(v.prefab,1,10) == "stalagmite" or v.prefab == "rock_ice" or string.sub(v.prefab,1,12) == "ruins_statue" ) 
			then
				if not table.contains(inst.collide_task_table2, v.GUID) then
					SpawnPrefab("collapse_small").Transform:SetPosition(v.Transform:GetWorldPosition())
					v.components.workable:WorkedBy(inst, 3)
					table.insert(inst.collide_task_table2, v.GUID)
				end	
			end
			
			
		end
		
	end)
	
	inst:DoTaskInTime(3, function()
		if inst then 
			inst:Remove()
		end
	end)

    return inst
end

return Prefab("fengzhishang", fn_fx)
