local assets =
{
	Asset("ANIM", "anim/huoshuqiu.zip"),
    Asset("ATLAS", "images/inventoryimages/huoshuqiu.xml"),
    Asset("IMAGE", "images/inventoryimages/huoshuqiu.tex"),
}

local function onequip(inst, owner)
	owner.components.health.fire_damage_scale = 0
    owner.AnimState:OverrideSymbol("swap_body", "huoshuqiu", "swap_body")
	 inst.components.container:Open(owner)
end

local function onunequip(inst, owner)
	owner.components.health.fire_damage_scale = 1
    owner.AnimState:ClearOverrideSymbol("swap_body")
	    inst.components.container:Close(owner)
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddMiniMapEntity()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)
	--local minimap = inst.entity:AddMiniMapEntity()
    --minimap:SetIcon("huoshuqiu.tex")

    inst.AnimState:SetBank("huoshuqiu")
    inst.AnimState:SetBuild("huoshuqiu")
    inst.AnimState:PlayAnimation("anim")
	
    inst.MiniMapEntity:SetIcon( "huoshuqiu.tex" )
    inst.foleysound = "dontstarve/movement/foley/backpack"

    if not TheWorld.ismastersim then
        return inst
    end	
	
    inst.entity:SetPristine()

    inst:AddComponent("inspectable")





    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.cangoincontainer = true
	inst.components.inventoryitem.imagename = "huoshuqiu"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/huoshuqiu.xml"
	inst.components.inventoryitem.keepondeath = true

    inst:AddComponent("insulator")
    inst.components.insulator:SetInsulation(480)
	
	inst:AddComponent("waterproofer")
    inst.components.waterproofer:SetEffectiveness(0.5)	
	
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BODY

    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)
    --inst.components.health.fire_damage_scale = 0
    --inst.components.equippable.walkspeedmult = 1.5
	
    inst:AddComponent("container")
    inst.components.container:WidgetSetup("shadowchester")
MakeHauntableLaunchAndDropFirstItem(inst)

    return inst
end

return Prefab("common/inventory/huoshuqiu", fn, assets)