local assets =
{
	Asset("ANIM", "anim/jianqiao.zip"),
	Asset("ANIM", "anim/swap_jianqiao.zip"),
    Asset("ATLAS", "images/inventoryimages/jianqiao.xml"),
    Asset("IMAGE", "images/inventoryimages/jianqiao.tex"),

}


local function texiaozu(inst, owner)
    inst.components.armor:SetAbsorption(1)
    
    local fx = SpawnPrefab("forcefieldfx")
    fx.entity:SetParent(owner.entity)
    fx.Transform:SetPosition(0, 0.2, 0)
    fx.Transform:SetScale(1.2, 1.2, 1.2)
    fx.AnimState:PlayAnimation("hit")
    fx.AnimState:PushAnimation("idle_loop")

    inst.components.armor.ontakedamage = function(inst, damage_amount)
        if owner then
            local sanity = owner.components.sanity
            if sanity then
                local unsaneness = damage_amount * 0.05
                sanity:DoDelta(-unsaneness, false)
            end
        end
    end
    inst.active = true
    --冷却时间5s
    owner:DoTaskInTime(5, function()
        fx.kill_fx(fx)
        if inst:IsValid() then
            inst.components.armor.ontakedamage = nil
            --owner.components.health.absorb = 0
            inst.components.armor:SetAbsorption(0.8)
            owner:DoTaskInTime(15, function() inst.active = false end)
        end
    end)
end


local function tryproc(inst, owner)
    if not inst.active and math.random() < 0.2 then
        texiaozu(inst, owner)
    end
end


local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_body", "swap_jianqiao", "backpack")
    owner.AnimState:OverrideSymbol("swap_body", "swap_jianqiao", "swap_body")
        inst.procfn = function() tryproc(inst, owner) end
        owner:ListenForEvent("attacked", inst.procfn)
end

local function onunequip(inst, owner)
    owner.AnimState:ClearOverrideSymbol("swap_body")
    owner.AnimState:ClearOverrideSymbol("backpack")
 owner:RemoveEventCallback("attacked", inst.procfn)
    
end









local function fn()
	local inst = CreateEntity()
    
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.entity:AddMiniMapEntity()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)
    local minimap = inst.entity:AddMiniMapEntity()
    minimap:SetIcon("jianqiao.tex")
	
    inst.AnimState:SetBank("jianqiao")
    inst.AnimState:SetBuild("jianqiao")
    inst.AnimState:PlayAnimation("idle")

    inst.MiniMapEntity:SetIcon("jianqiao.png")
    
    inst.foleysound = "dontstarve/movement/foley/backpack"

    if not TheWorld.ismastersim then
        return inst
    end

    inst.entity:SetPristine()
    
    inst:AddComponent("inspectable")
    
		inst:AddComponent("trader")
    inst.components.trader:SetAcceptTest(function(inst, item) return item and item.prefab=="nightmarefue" end)
    inst.components.trader.onaccept=function(inst,giver,item)
		local finiteuses=inst.components.finiteuses
		finiteuses:SetUses(math.min(finiteuses.current+.20*finiteuses.total,finiteuses.total))
	end
    inst.components.trader.onrefuse=function(inst,giver,item) if giver.components.talker then giver.components.talker:Say("需要噩梦燃料修复") end end
	
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.keepondeath = true
	inst.components.inventoryitem.imagename = "jianqiao"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/jianqiao.xml"
	inst.components.inventoryitem.cangoincontainer = true

    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BODY

    
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)

    inst:AddComponent("armor")
    inst.components.armor:InitCondition(2000, TUNING.ARMORWOOD_ABSORPTION)

	--inst:ListenForEvent("attacked", OnAttacked)

        

 

    MakeHauntableLaunchAndDropFirstItem(inst)

    return inst
end

return Prefab("common/inventory/jianqiao", fn, assets)