local assets =
{
    Asset("ANIM", "anim/longlin.zip"),
    Asset("ANIM", "anim/swap_longlin.zip"),
	Asset("IMAGE","images/inventoryimages/tisuiya.tex"),
	Asset("ATLAS","images/inventoryimages/tisuiya.xml")
}

local function onequip(inst, owner)
inst:AddTag("feng")
	owner.components.hunger.hungerrate = 2 * TUNING.WILSON_HUNGER_RATE
 	--local water = SpawnPrefab("waterballoon")
	--water.Transform:SetPosition( target.Transform:GetWorldPosition() )
    owner.AnimState:OverrideSymbol("swap_object", "swap_longlin", "swap_longlin")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")

end

local function onunequip(inst, owner)
inst:RemoveTag("feng")
	owner.components.hunger.hungerrate = 1 * TUNING.WILSON_HUNGER_RATE
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
inst:DoTaskInTime(0.001,function()inst:Remove()end)
end


local function longlinatt(weapon, attacker, target)
	
	
	local x, y, z = target.Transform:GetWorldPosition()
	local fx = SpawnPrefab("groundpound_fx")
	target.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/bearger/groundpound")
	fx.Transform:SetPosition(x, y, z)
	
	
			if target and target:IsValid() and attacker and attacker.components.combat then
			local pos=target:GetPosition()
			local ents=TheSim:FindEntities(pos.x,0,pos.z,4,{"_health","_combat"},{"INLIMBO","wall","companion","playerghost"})
			for k, v in pairs(ents) do
				if v and v:IsValid() and v ~= attacker
					and (TheNet:GetPVPEnabled() or not v:HasTag("player"))
					and not (v.components.follower and v.components.follower.leader == attacker) 
					then
					if v ~= target then 
						v.components.combat:GetAttacked(attacker, 
							attacker.components.combat:CalcDamage(v, attacker.components.combat:GetWeapon(), 3)
						)
						SpawnPrefab("collapse_small").Transform:SetPosition(v:GetPosition():Get())
					end
					
				end
			end
		end
	
	 
			if math.random() < .2 then
			local v = target
			if v.components.health and not v.components.health:IsDead() and v.components.combat then
				--静止
				if v.brain then
					v.brain:Stop()
				end
				if v.components.combat then
					v.components.combat:SetTarget(nil)
				end
				if v.components.locomotor then
					v.components.locomotor:Stop()
				end
				
				--强制idle
				if v.sg and v.sg.sg and v.sg.sg.states and v.sg.sg.states["idle"] then
					v.sg:GoToState("idle")
				end
				
				v:DoTaskInTime(4, function()
					if v and v.brain then
						v.brain:Start()
					end
				end)
				
			end
       attacker.components.talker:Say("龙息压制！")
attacker.components.hunger:DoDelta(-10)

		end

	    
        --attacker.components.hunger:DoDelta(-2)
	
	
end



local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("longlin")
    inst.AnimState:SetBuild("longlin")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("sharp")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(79)
	inst.components.weapon:SetElectric()
inst.components.weapon:SetOnAttack(longlinatt)
    -------
    inst.components.weapon:SetRange(1.5)
   


    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "tisuiya"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/tisuiya.xml"

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)
	inst.components.equippable.walkspeedmult = 0.9



    MakeHauntableLaunch(inst)

    return inst
end

return Prefab( "common/inventory/longlin", fn, assets)