local assets =
{
    Asset("ANIM", "anim/metalclaw.zip"),
    Asset("ANIM", "anim/swap_metalclaw.zip"),
 
    Asset("ATLAS", "images/inventoryimages/metalclaw.xml"),
    Asset("IMAGE", "images/inventoryimages/metalclaw.tex"),
}




local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddLight()	
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("metalclaw")
    inst.AnimState:SetBuild("metalclaw")
    inst.AnimState:PlayAnimation("idle")
	
	inst:AddTag("sharp")

    inst.entity:SetPristine()
	

	
 
    if not TheWorld.ismastersim then
        return inst
    end
	--inst:DoTaskInTime(4,function()inst:Remove()end)	
	
	
	local function onequip(inst, owner)
		owner.AnimState:OverrideSymbol("swap_object", "swap_metalclaw", "swap_metalclaw")
		owner.AnimState:Show("ARM_carry")
		owner.AnimState:Hide("ARM_normal")

 
	end

	local function onunequip(inst, owner)

		
		owner.AnimState:Hide("ARM_carry")
		owner.AnimState:Show("ARM_normal")
		inst:DoTaskInTime(0.1,function()inst:Remove()end)
	end	

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(36)
    inst.components.weapon:SetRange(11, 13)
	inst.components.weapon:SetProjectile("feiren_projectile")


    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.keepondeath = true
    inst.components.inventoryitem.imagename = "metalclaw"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/metalclaw.xml"

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)
	inst.components.inventoryitem.keepondeath = true

    MakeHauntableLaunch(inst)

    return inst
end

return Prefab( "metalclaw", fn, assets)