local assets =
{
    Asset("ANIM", "anim/mindao.zip"),
    Asset("ANIM", "anim/swap_mindao.zip"),
	Asset("IMAGE","images/inventoryimages/tisuiya.tex"),
	Asset("ATLAS","images/inventoryimages/tisuiya.xml")
}

---------ORANGE STAFF-----------

local function onblink(staff, pos, caster)
    if caster.components.sanity ~= nil then
        caster.components.sanity:DoDelta(-10)
    end

end

local function blinkstaff_reticuletargetfn()
    local player = ThePlayer
    local rotation = player.Transform:GetRotation() * DEGREES
    local pos = player:GetPosition()
    for r = 13, 1, -1 do
        local numtries = 2 * PI * r
        local pt = FindWalkableOffset(pos, rotation, r, numtries)
        if pt ~= nil then
            return pt + pos
        end
    end
end

local function onhauntorange(inst)
    if math.random() <= TUNING.HAUNT_CHANCE_OCCASIONAL then
        local target = FindEntity(inst, 20, nil, { "locomotor" }, { "playerghost", "INLIMBO" })
        if target ~= nil then
            local pos = target:GetPosition()
            local start_angle = math.random() * 2 * PI
            local offset = FindWalkableOffset(pos, start_angle, math.random(8, 12), 60, false, true)
            local pt = pos + offset
            inst.components.blinkstaff:Blink(pt, target)
            inst.components.hauntable.hauntvalue = TUNING.HAUNT_LARGE
            return true
        end
    end
    return false
end




local function onequip(inst, owner)
inst:AddTag("feng")
    owner.AnimState:OverrideSymbol("swap_object", "swap_mindao", "swap_mindao")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")

end

local function onunequip(inst, owner)
inst:RemoveTag("feng")
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
inst:DoTaskInTime(0.001,function()inst:Remove()end)
end


local function mindaoatt(weapon, attacker, target)
	if target:HasTag("shadowcreature") then
	target.components.health:DoDelta(-100)
        --attacker.components.hunger:DoDelta(-2)
	end
	
end



local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("mindao")
    inst.AnimState:SetBuild("mindao")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("sharp")
    inst:AddTag("pointy")
    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(50)
inst.components.weapon:SetOnAttack(mindaoatt)
    -------
	inst.components.weapon.blinking = true
    inst.components.weapon:SetRange(4,1.3)



    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "tisuiya"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/tisuiya.xml"

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)
	inst.components.equippable.dapperness = - TUNING.DAPPERNESS_HUGE
--瞬移2
    inst.fxcolour = {1, 145/255, 0}
    inst.castsound = "dontstarve/common/staffteleport"

    inst:AddComponent("blinkstaff")
    inst.components.blinkstaff.onblinkfn = onblink


    MakeHauntableLaunch(inst)
    AddHauntableCustomReaction(inst, onhauntorange, true, false, true) 
    return inst
end

return Prefab( "common/inventory/mindao", fn, assets)