local assets =
{
    Asset("ANIM", "anim/pot.zip"),
    Asset("ANIM", "anim/swap_pot.zip"),
	Asset("IMAGE","images/inventoryimages/tisuiya.tex"),
	Asset("ATLAS","images/inventoryimages/tisuiya.xml")
}


local function ShouldAcceptItem(inst, item)
    if item.prefab == "redgem" or item.prefab == "walrus_tusk"  or item.prefab == "bluegem" or item.prefab == "dragon_scales" or item.prefab == "houndstooth" then
       return true
    end
    return false
end






local function onfinished(inst)
	local x, y, z = inst.Transform:GetWorldPosition()
	SpawnPrefab("duanjianr").Transform:SetPosition(x,y,z)
	SpawnPrefab("duanjianb").Transform:SetPosition(x,y,z)
--local reng =SpawnPrefab("duanjianr").Transform:SetPosition(inst:GetPosition():Get())
--local bing =SpawnPrefab("duanjianb").Transform:SetPosition(inst:GetPosition():Get())
	--local reng = SpawnPrefab("duanjianr")
	--local bing = SpawnPrefab("duanjianb")
	inst:Remove()
end




local function onAttackf(inst, owner, target)

    if target:HasTag("largecreature") and target:HasTag("monster") then
  local atkfx = SpawnPrefab("firetornado")
atkfx.Transform:SetPosition( target.Transform:GetWorldPosition() )
       
    end
end




local function onequip(inst, owner)
if owner.prefab == "quanyecha" then

    owner.AnimState:OverrideSymbol("swap_object", "swap_pot", "swap_pot")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")

--local x, y, z = inst.Transform:GetWorldPosition()
	--local fx = SpawnPrefab("buff_accelerate")
	--fx.Transform:SetPosition(x, y, z)
	--fx.Transform:SetScale(2,2,2)
else
		owner:DoTaskInTime(0, function()
			local pand = owner.components.inventory 
			if pand then
				pand:GiveItem(inst)
			end
			local talker = owner.components.talker 
			if talker then
				talker:Say("被结界阻挡,无法使用!")
			end
		end)
	end
	
	
end

local function onunequip(inst, owner)

    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")

end


local function OnGetItemFromPlayer(inst, giver, item)
    if item.prefab == "redgem" then
		wuqipd.xueyuon = true
		giver.SoundEmitter:PlaySound("dontstarve/characters/wx78/levelup")
		inst.components.talker:Say("成功吸收妖力", 2.2,true) 
	end
	 if item.prefab == "bluegem" then
		wuqipd.jingangon = true
		giver.SoundEmitter:PlaySound("dontstarve/characters/wx78/levelup")
		inst.components.talker:Say("成功吸收妖力", 2.2,true) 
	end
	 if item.prefab == "walrus_tusk" then
		wuqipd.mindaoon = true
		giver.SoundEmitter:PlaySound("dontstarve/characters/wx78/levelup")
		inst.components.talker:Say("成功吸收妖力", 2.2,true) 
	end
	 if item.prefab == "dragon_scales" then
		wuqipd.longlinon = true
		giver.SoundEmitter:PlaySound("dontstarve/characters/wx78/levelup")
		inst.components.talker:Say("成功吸收妖力", 2.2,true) 
	end
	 if item.prefab == "houndstooth" then
       inst.components.finiteuses.current = inst.components.finiteuses.current + inst.components.finiteuses.total *0.35
    end
    if inst.components.finiteuses.current > inst.components.finiteuses.total then
       inst.components.finiteuses.current = inst.components.finiteuses.total
    end
end

local function OnRefuseItem(inst, giver, item)
	if item.prefab ~= "redgem" or item.prefab ~= "bluegem"  or item.prefab ~= "walrus_tusk" or item.prefab ~= "dragon_scales" or item.prefab ~= "houndstooth" then
		inst.components.talker:Say("这种材料没有吸收的必要!")
	end
end

local function onsave(inst, data)
    --inst.level = wuqipd.xueyuon
    --data.level = inst.level
	data.level1 = wuqipd.xueyuon
	data.level2 = wuqipd.jingangon
	data.level3 = wuqipd.mindaoon
	data.level4 = wuqipd.longlinon
end

local function onpreload(inst, data)
    if data then
        wuqipd.xueyuon = data.level1
		wuqipd.jingangon = data.level2
		wuqipd.mindaoon = data.level3
		wuqipd.longlinon = data.level4

    end
end



local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)
    local minimap = inst.entity:AddMiniMapEntity()
    minimap:SetIcon("tiesuiya.tex")
	
    inst.AnimState:SetBank("pot")
    inst.AnimState:SetBuild("pot")
    inst.AnimState:PlayAnimation("idle")
    
	--inst:AddTag("shadow")
	inst:AddTag("feng")
    inst:AddTag("sharp")
    inst:AddTag("extinguisher")
	
    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(55)

    -------
    inst.components.weapon:SetRange(1.8)
    inst.components.weapon:SetOnAttack(onAttackf)

    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(350)
    inst.components.finiteuses:SetUses(350)
	if inst.components.finiteuses.current < 0 then
       inst.components.finiteuses.current = 0
    end
	inst.components.finiteuses:SetOnFinished( onfinished )
	
    inst:AddComponent("inspectable")
	
		inst:AddComponent("trader")

    inst.components.trader.onaccept = OnGetItemFromPlayer
    inst.components.trader:SetAcceptTest(ShouldAcceptItem)
 inst.components.trader.onrefuse = OnRefuseItem

    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "tisuiya"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/tisuiya.xml"
	inst.components.inventoryitem.nobounce = true
	inst.components.inventoryitem.keepondeath = true

	inst:AddComponent("spellcaster")
	
	--
	local function IsWorkAction(action)
		return action == ACTIONS.CHOP
			--or action == ACTIONS.DIG
			--or action == ACTIONS.HAMMER
			--or action == ACTIONS.MINE
	end
	
	function inst.components.spellcaster:CanCast(doer, target, pos)
		if doer == nil or doer.prefab ~= "quanyecha" then
			return false
		elseif self.spell == nil then
			return false
		elseif target == nil then
			if pos == nil then
				return self.canusefrominventory
			end
			return self.canuseonpoint and TheWorld.Map:IsAboveGroundAtPoint(pos:Get())
		elseif target:IsInLimbo()
			or not target.entity:IsVisible()
			or (target.components.health ~= nil and target.components.health:IsDead())
			or (target.sg ~= nil and (
					target.sg.currentstate.name == "death" or
					target.sg:HasStateTag("flight") or
					target.sg:HasStateTag("invisible")
				)) then
			return false
		end
		return self.canuseontargets and (
				(self.canonlyuseonrecipes and AllRecipes[target.prefab] ~= nil) or
				(self.canonlyuseonlocomotors and target.components.locomotor ~= nil and (TheNet:GetPVPEnabled() or not (target:HasTag("player") and doer:HasTag("player")))) or
				(self.canonlyuseonworkable and target.components.workable ~= nil and target.components.workable:CanBeWorked() and IsWorkAction(target.components.workable:GetWorkAction())) or
				(self.canonlyuseoncombat and doer.components.combat ~= nil and doer.components.combat:CanTarget(target))
			)
	end
	
	inst.components.spellcaster.canuseonpoint = true
    inst.components.spellcaster.canuseontargets = true
	inst.components.spellcaster.canonlyuseonrecipes = true
	inst.components.spellcaster.canonlyuseonlocomotors = true
    inst.components.spellcaster.canonlyuseonworkable = true
    inst.components.spellcaster.canonlyuseoncombat = true
    inst.components.spellcaster.quickcast = true
	
    inst.components.spellcaster:SetSpellFn( function(staff, target, pos)
		local owner = inst.components.inventoryitem.owner
		if owner then
			--owner:PushEvent("zg_mihawk_jump", {pos = target and target:GetPosition() or pos})
			local fx = SpawnPrefab("buff_accelerate")
			if fx then
			
				fx.master = owner
				local x,y,z = inst:GetPosition():Get()
				fx.Transform:SetPosition(x, 0, z)
				fx.Transform:SetRotation( owner.Transform:GetRotation() )
				fx.Physics:SetMotorVelOverride(10,0,0)
				--inst.SoundEmitter:PlaySound("dontstarve/wilson/zg_mihawk_jq")
				owner.components.talker:Say("风之伤!", 2.2,true)
				if owner.components.hunger then
					owner.components.hunger:DoDelta(-5)
				end
				if owner.components.health then
					owner.components.health:DoDelta(-2)
				end
				
			end
			
		end
	end)

	inst:AddComponent("talker")
    inst.components.talker.fontsize = 36
    inst.components.talker.font = TALKINGFONT
    inst.components.talker.colour = Vector3(.9, .4, .4)
    inst.components.talker.offset = Vector3(0, 0, 0)
    inst.components.talker.symbol = "swap_object"
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)
    inst.components.equippable.dapperness = 20/60
--inst:AddComponent("tool")
--inst.components.tool:SetAction(ACTIONS.HACK,2)
--inst.components.tool:SetAction(ACTIONS.CHOP, 5)
--inst.components.tool:SetAction(ACTIONS.MINE, 2)


    MakeHauntableLaunch(inst)

	inst.OnSave = onsave
    inst.OnPreLoad = onpreload
	
    return inst
end

return Prefab( "common/inventory/pot", fn, assets)