
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/quanyecha.zip" ),
        Asset( "ANIM", "anim/ghost_quanyecha_build.zip" ),
	Asset( "ANIM", "anim/quanyecharumo.zip" ),	
	Asset( "ANIM", "anim/quanyecharenlei.zip" ),	
		
}



local prefabs = {
"crow",
}

local start_inv = {
	    "jianqiao","pot",
}


local pugong = false





local function applyupgrades(inst)

	local max_upgrades = 40
	local upgrades = math.min(inst.level, max_upgrades)

	local hunger_percent = inst.components.hunger:GetPercent()
	local health_percent = inst.components.health:GetPercent()
	local sanity_percent = inst.components.sanity:GetPercent()

	inst.components.hunger.max = math.ceil (100 + (upgrades * 3)) --220
	inst.components.health.maxhealth = math.ceil (80 + (upgrades * 3)) --200
	inst.components.sanity.max = math.ceil (60 + (upgrades * 1)) --100

	inst.components.locomotor.walkspeed =  math.ceil (7 + upgrades / 10) --11
	inst.components.locomotor.runspeed = math.ceil (9 + upgrades / 10) --13
inst.components.talker:Say("Level up: ".. (inst.level))


	if inst.level >39 then
		inst.components.talker:Say("Level Max!")
	end

	inst.components.hunger:SetPercent(hunger_percent)
	inst.components.health:SetPercent(health_percent)
	inst.components.sanity:SetPercent(sanity_percent)	
end

local function onbecamehuman(inst)

	inst.components.locomotor.walkspeed = 4
	inst.components.locomotor.runspeed = 6
	applyupgrades(inst)
end


local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)
	
    if not inst:HasTag("playerghost") then
        onbecamehuman(inst)
    end
end



local function oneat(inst, food)
	if food and food.components.edible and food.prefab == "turkeydinner" or food.prefab == "pumpkincookie" or food.prefab == "pumpkin" or food.prefab == "pumpkin_cooked" then
		  inst.level = inst.level + 1
		  applyupgrades(inst)	
		  inst.SoundEmitter:PlaySound("dontstarve/characters/wx78/levelup")
	end
end

local function onpreload(inst, data)
	if data then
		if data.level then
			inst.level = data.level
			applyupgrades(inst)
			if data.health and data.health.health then inst.components.health.currenthealth = data.health.health end
			if data.hunger and data.hunger.hunger then inst.components.hunger.current = data.hunger.hunger end
			if data.sanity and data.sanity.current then inst.components.sanity.current = data.sanity.current end
			inst.components.health:DoDelta(0)
			inst.components.hunger:DoDelta(0)
			inst.components.sanity:DoDelta(0)
		end
		applyupgrades(inst)
	end
end

local function onsave(inst, data)
    data.level = inst.level

end







local function OnAttack(inst, data)
    if pugong then
   if not inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS) or inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS).prefab ~= "metalclaw" then
       
	
	
	inst.components.inventory:Equip(SpawnPrefab("metalclaw"))	
	
end

elseif inst.components.inventory and inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS) and inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS).prefab  == "metalclaw" then
inst.components.inventory:Unequip(EQUIPSLOTS.HANDS)
end



end











local function change(inst)

   
	if inst.components.sanity:GetPercent() < 0.3 and not TheWorld.state.isfullmoon then

inst.AnimState:SetBuild("quanyecharumo")



pugong = true

inst.components.combat.damagemultiplier = 1.5
inst.components.combat.min_attack_period = 0.3
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.5)
inst.components.sanity.night_drain_mult = 0
inst.components.health:StartRegen(1, 600)
inst.components.sanity.dapperness = 0
inst.components.health.absorb = 0.5

		if TheWorld.state.isnight or TheWorld:HasTag("cave") then
			
			inst.Light:Enable(true)
		else
			inst.Light:Enable(false)
		end
		
	

		
	elseif TheWorld.state.isfullmoon then	
	inst.AnimState:SetBuild("quanyecharenlei")
	pugong = false
	
	inst.components.combat.damagemultiplier = 0.3
	inst.components.combat.min_attack_period = 0.9
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 2)
	inst.components.sanity.night_drain_mult = 2
	inst.components.health:StartRegen(1, 600)
	inst.components.sanity.dapperness = 0
	--inst.components.sanity.dapperness = TUNING.DAPPERNESS_LARGE
	inst.components.health.absorb = -0.2
	
		inst.Light:Enable(false)
		
	if inst.components.inventory then
	if inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS).prefab  == "pot" 
	or inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS).prefab  == "jingang"
	or inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS).prefab  == "xueyu"
	or inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS).prefab  == "mindao"
	or inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS).prefab  == "longlin" then

inst.components.inventory:Equip(SpawnPrefab("potie"))
end
end
	

	else
	inst.AnimState:SetBuild("quanyecha")
	

	
	pugong = false
	
	inst.components.combat.damagemultiplier = 1
	inst.components.combat.min_attack_period = 0.5
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE)
	inst.components.sanity.night_drain_mult = 1
	inst.components.health:StartRegen(5, 30)
	inst.components.sanity.dapperness = 0
	inst.components.health.absorb = 0
	
	inst.Light:Enable(false)
	end
		
	end


local common_postinit = function(inst) 
	
	inst.MiniMapEntity:SetIcon( "quanyecha.tex" )
--inst:AddTag("mihoowner")
inst:AddTag("quanyechaa")
--inst:AddTag("quanyechabuilder")
inst:AddComponent("keyhandler")
 inst.components.keyhandler:AddActionListener("quanyecha", TUNING.WEAPON.KEYSEVEN, "ChanGe")
end

-- This initializes for the host only
local master_postinit = function(inst)
	-- Stats	
	
inst.level = 0
	inst.components.eater:SetOnEatFn(oneat)
 
	applyupgrades(inst)



	
	
	
	inst.components.temperature.maxtemp = 92
	inst.components.temperature.mintemp = -5
	inst.components.temperature.overheattemp = 80
	inst.components.health:SetMaxHealth(80)
	inst.components.hunger:SetMax(100)
	inst.components.sanity:SetMax(60)
	

	--inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.4)
	--inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.45)
	
	--inst.components.sanity.ghost_drain_mult = 0.5
	

	inst.components.combat:SetDefaultDamage(15)
	
	
	inst:ListenForEvent("onhitother", OnAttack)

    
 


	
	--inst:AddComponent("reader")
	
inst.entity:AddLight()
	inst.Light:Enable(false)
	    inst.Light:SetRadius(10)
		inst.Light:SetFalloff(0.75)
		inst.Light:SetIntensity(.2)
		inst.Light:SetColour(12/255,255/255,12/255)
    local rt = 4
    inst:DoPeriodicTask(rt, function() change(inst, rt) end)	


	inst.OnSave = onsave
    inst.OnPreLoad = onpreload
    inst.OnLoad = onload
    inst.OnNewSpawn = onload

end



return MakePlayerCharacter("quanyecha", prefabs, assets, common_postinit, master_postinit, start_inv)
